#!/perl -w
# dirbydate.pl
# AIM: Read a file output from the DIR command, and order the files in DATE
# order ... drop out the pure <DIR> entries ...
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /^\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
# debug output
my $dbg01 = 0;	# show each FOLDER as found ...
my $dbg02 = 0;	# show count and bytes as found ...
my $dbg03 = 0;	# show files, as found
my $verb3 = 0;	# show sort compare ...

my $in_file = 'C:/Program Files/Microsoft Visual Studio 8/VC/templist.txt';
my @filelist = ();
my @sortlist = ();
my $basedir = '';

sub trimall($) {	# version 20061127
	my ($ln) = shift;
	chomp $ln;			# remove CR (\n)
	$ln =~ s/\r$//;		# remove LF (\r)
	$ln =~ s/\t/ /g;	# TAB(s) to a SPACE
	while ($ln =~ /\s\s/) {
		$ln =~ s/\s\s/ /g;	# all double space to SINGLE
	}
	while ($ln =~ /^\s/) {
		$ln = substr($ln,1); # remove all LEADING space
	}
	while ($ln =~ /\s$/) {
		$ln = substr($ln,0, length($ln) - 1); # remove all TRAILING space
	}
	return $ln;
}

sub remdir {
	my ($f) = shift;
	my $b2 = quotemeta($basedir);
	$f =~ s/^$b2\\//; # remove beginning ...
	return $f;
}

# put least first
sub mycmp_ascend {
   if (${$a}[0] < ${$b}[0]) {
      prt( "-[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return -1;
   }
   if (${$a}[0] > ${$b}[0]) {
      prt( "+[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return 1;
   }
   prt( "=[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
   return 0;
}

sub mycmp_decend {
   if (${$a}[0] < ${$b}[0]) {
      prt( "+[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return 1;
   }
   if (${$a}[0] > ${$b}[0]) {
      prt( "-[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return -1;
   }
   prt( "=[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
   return 0;
}

open INF, "<$in_file" or mydie("ERROR: Can NOT open [$in_file] ... $! ...\n" );
my @lines = <INF>;	# slurp it all
close INF;
my $lc = scalar @lines;
prt( "Processing $lc lines from [$in_file] ...\n" );
my $line = '';
my $tln = '';
my $act_folder = '';
$basedir = file_dirname($in_file);
foreach $line (@lines) {
	$tln = trimall($line);
	if (length($tln)) {
		#  Volume in drive C has no label.
		#  Volume Serial Number is D833-AEFA
		if ($line =~ /Volume in drive (.*)/ ) {
			# ignore
		} elsif ($line =~ /Volume Serial Number is (.*)/ ) {
			# ignore
		} elsif ($line =~ /Total Files Listed/ ) {
			# ignore
		} elsif ($line =~ /Directory of (.*)/ ) {
			$act_folder = $1;
			prt( "Folder [$act_folder] ...\n" ) if ($dbg01);
		} elsif ($line =~ /\d+\s+File\(s\)\s+[\d,]+\s+bytes/ ) {
			prt( $line ) if ($dbg02);
		} elsif ($line =~ /\d+\s+Dir\(s\)\s+[\d,]+\s+bytes/ ) {
			prt( $line ) if ($dbg02);
		} else {
			my @arr = split(/\s/, $tln);
			my $ac = scalar @arr;
			my $pchk = 0;
			#prt( $line );
			if ($ac > 3) {
				if ($arr[2] eq '<DIR>') {
					# ignore
				} else {
					# file names of interest
					my $sz = $arr[2];
					my $nm = $arr[3];
					if ($ac > 4) {
						my $i = 4;
						while($i < $ac) {
							$nm .= ' '.$arr[$i];
							$i++;
						}
					}
					my @ar2 = split('/', $arr[0]); # get day/month/year
					my @ar3 = split(':', $arr[1]); # get hour:minutes
					if ((scalar @ar2 == 3)&&(scalar @ar3 == 2)) {
						my $ft = int($ar2[2].$ar2[1].$ar2[0].$ar3[0].$ar3[1]);
						push(@filelist, [$ft, $nm, $sz, $act_folder, $arr[0], $arr[1]]);
						prt( "$ft, $nm, $sz, $act_folder\n") if ($dbg03);
					} else {
						$pchk = 1;
					}
				}
			} else {
				$pchk = 1;
			}
			if ($pchk) {
				prt( "CHECK: " );
				for (my $i = 0; $i < $ac; $i++) {
					prt( $arr[$i].' ' );
				}
				prt("\n");
			}

		}
	}
}

my $fc = scalar @filelist;
prt( "Got $fc files ...\n" );
@sortlist = sort mycmp_decend @filelist;
my $fcs = scalar @sortlist;
prt( "Got $fcs sorted files ...\n" );
for (my $i = 0; $i < $fcs; $i++) {
	my $reldir = remdir( $sortlist[$i][3] );
	# push(@filelist, [$ft, $nm, $sz, $act_folder, $arr[0], $arr[1]]);
	my $msg = $sortlist[$i][4] . ' ' . $sortlist[$i][5] . ' ' . $sortlist[$i][1] . ' ' . $reldir;
	prt( "$msg\n" );
}
close_log($outfile,1);
exit(0);

# eof
