#!/Perl
# AIM: To read the Internet Favorites, and produce
# a HTML document, with links and description
# 2005.11.12 - works ok - geoff mclane
# update 2006.06.28 - weed out (a) duplicates (not done) and (b) local references
# Added a MAXIMUM width, so the table approximately 'fits' a 1024 wide screen
# change to using '<base target="_blank">'
#
my $DT = '2006.06.29';
$VERSION = '0.3';
$PACKAGE = 'fav-03';
my $hvers = "<!-- $DT - update -->\n";
$hvers .= '<!-- p26.2005.11.11 - List of favorites in PRO-1 geoffmclane.com/favorites.htm -->';
print "$0 ... Hello, World ...\n";
if( !defined( $ENV{'USERPROFILE'} ) ) {
	print "Can NOT locate USERPROFILE in ENVironment!\n";
	exit(1);
}
my $ff = $ENV{'USERPROFILE'} . '\\Favorites';
if( !( -d $ff ) ) {
	print "Folder $ff is NOT a directory!\n";
	exit(2);
}
# set a sample maximum title, wrap start at -10 from this - original set at 60
#             12345678901234567890123456789012345678901234567890123456789012345678901234567890
#                      1         2         3         4         5         6         7
my $maxtit = 'Domain Name Registration, Domain Transfers. Your domain'; # name search starts here.';
my $logfil = "templog.csv";
my $htmfil = 'favorites.htm';

my $basedir = $ff;
my $blen = length($basedir);
my ($fn,$ffn,$LF,$HF);
my @dirs = ($ff);
my @fils = ();
open $LF, ">$logfil" or die "Can NOT open LOG file $logfil!\n";
open $HF, ">$htmfil" or die "Can NOT open HTML file $htmfil!\n";

my $fcnt = scalar @fils;
my $dcnt = scalar @dirs;
my $maxwid = length($maxtit);
#print "Found $fcnt files, and $dcnt directories ...\n";
while (scalar @dirs) {
	local @dir2 = @dirs;
	@dirs = ();
	while ($fn = shift @dir2) {
		do_dir($fn);
	}
}
$fcnt = scalar @fils;
$dcnt = scalar @dirs;
print "Total: $fcnt URL files ...\n";
# choosing a DOCTYPE
my $doctyp4 = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">';
##my $doctypt = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">';
##my $doctyps = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">';
##my $doctyp3 = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">';

out_htm_head();
oh( "<p>This table is auto-generated from a Perl script, reading and analysing my 'Favorites' folder, from the USERPROFILE given in the environment.</p>" );
oh( '<table border="1" width="100%" summary="List of favorites - First column is title, and link -2nd is URL">' );
oh( ' <tr>' );
oh( '  <td><b>Title</b></td>' );
oh( '  <td><b>Link</b></td>' );
oh( ' </tr>' );

foreach $fn (@fils) {
	# process each file
	local $FH;
	if ( open( $FH, $fn ) ) {
		local @lns = <$FH>; # slurp in the lines
		local $sn = sb($fn);
		###prt( "Processing " . sb($fn) . " of " . scalar @lns . " lines ...\n");
		close( $FH );
		local $line;
		foreach $line (@lns) {
			chomp $line;
			if( $line =~ /^URL=/ ) {
				local $u = substr($line,4); ## ~ s/^URL=//;
				prt( "\"$sn\",$u" );
				$u =~ s/&/&amp;/g;
				oh( '   <tr>' );
				#oh( "    <td><a target=\"_blank\" href=\"$u\">$sn</a></td>" );
				oh( "    <td><a href=\"$u\">$sn</a></td>" );
				##$u =~ s/&/&amp;/o;
				oh( "    <td>".max_sub($u,$maxwid)."</td>" );
				oh( '   </tr>' );
				last;
			}
		}
	} else {
		print "Unable to open file $fn ...\n";
	}
}
oh( '</table>' );
out_htm_tail();

close( $HF );
close( $LF );
system( $htmfil );

sub get_lists {
	###foreach $fn (@files) {
	while ($fn = shift @_) {
		next if ($fn eq '.');
		next if ($fn eq '..');
		$ffn = $ff . '\\' . $fn;
		if( -d $ffn ) {
			push(@dirs, $ffn);
		} else {
			if ($fn =~ /\.url$/i) {
				push(@fils, $ffn);
			} else {
				print "Discarding file $ffn ...\n";
			}
		}
	}
	$fcnt = scalar @fils;
	$dcnt = scalar @dirs;
	print "Found $fcnt files, and $dcnt directories ...\n";
}

sub do_dir {
	local ($dn) = @_;
	print "Processing $dn ...\n";
	opendir(DIRH, $dn);
	local @f = readdir(DIRH);
	closedir(DIRH);
	print "Found " . scalar @f . " entries ...\n";
	$ff = $dn;
	get_lists(@f);
}

sub prt {
	#print @_;
	print $LF @_;
}

sub max_sub {
	my ($ln, $max) = @_;
	my $nln = $ln;
	if (length($ln) > $max) {
		my @arr = split(/ /,$ln);
		$nln = '';
		my $bit = '';
		my $bl = 0;
		my $sl = 0;
		my $sc = 0;
		foreach my $s (@arr) {
			$sl = length($s);
			$bl = length($bit);
			while ($sl > $max) {
				if ($bl) {
					$bit .= ' ';
				}
				$bit .= substr($s, 0, $max - $bl);
				$s = substr($s, $max - $bl);
				if (length($nln)) {
					$nln .= "<br>\n";
				}
				$nln .= $bit;
				$bit = '';
				$sl = length($s);
				$bl = length($bit);
				$sc = 0;
			}
			if ($bl) {
				if (( $bl + $sc + length($s) ) > $max ) {
					if (length($nln)) {
						$nln .= "<br>\n";
					}
					$nln .= $bit;
					$bit = $s;
					$sc = 0;
				} else {
					$bit .= ' ';
					$sc++;
					$bit .= $s;
				}
			} else {
				$bit = $s;
				$sc = 0;
			}
		}
		if (length($bit)) {
			if (length($nln)) {
				$nln .= "<br>\n";
			}
			$nln .= $bit;
		}
	}
	return $nln;
}


sub sb {
	local ($f) = @_;
	local $b2 = quotemeta($basedir);
	###$f =~ s/^$basedir//;
	###$f = substr( $f, (length($basedir) + 1) );
	##$f = substr( $f, ($blen + 1), (length($f) - $blen - 5) );
	$f =~ s/^$b2\\//;
	$f =~ s/\.url$//;
	#return $f;
	return (max_sub($f, $maxwid));
}

sub ohl {
	print $HF "\n";
}

sub oh {
	local ($txt) = @_;
	print $HF $txt;
	ohl();
}

sub out_htm_head {
oh( $doctyp4 );
oh( '<html>' );
oh( '<head>' );
oh( "<title>List of Favorites - $DT</title>" );
oh( '<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">' );
oh( '<meta name="Author" content="Geoff Mclane">' );
oh( '<style type="text/css">' );
oh( '<!-- /* Style Definitions */' );
oh( 'body {' );
oh( ' background-image:url("clds3.jpg");' );
oh( ' margin: 0cm 1cm 0cm 1cm;' );
oh( '}' );
oh( 'h1{' );
oh( ' background:#efefef;' );
oh( ' border-style: solid solid solid solid;' );
oh( ' border-color:#d9e2e2;' );
oh( ' border-width:1px;' );
oh( ' padding:2px 2px 2px 2px;' );
oh( ' font-size:200%;' );
oh( ' text-align:center;' );
oh( '}' );
oh( '.ctr { text-align:center; }' );
oh( '.bld { font-weight:bold; }' );
oh( '-->' );
oh( '</style>' );
oh( '<base target="_blank">' ); # set so ALL open in 'New Window'
oh( '</head>' );
oh( '<body>' );
oh( "<h1>List of Favorites $DT</h1>" );
oh( '<p class="ctr"><a href="favorite.htm">back</a> <a href="home2.htm">home</a></p>' );
}

sub out_htm_tail {
oh( '<p class="ctr"><a href="favorite.htm">back</a> <a href="home2.htm">home</a></p>' );
oh( '</body>' );
oh( $hvers );
oh( '</html>' );
}

#eof
