#!/perl -w
# NAME: fplist.pl
# AIM: Read an input DIRECTORY, and output a LIST of FRONTPAGE directories
# to be EXCLUDED ...
# 11/04/2007 - geoff mclane - geoffair.com/mperl
use strict;
use warnings;
unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
# log file stuff
my ($LF);
my $outfile = 'temp.'.$pgmname.'.txt';
open_log($outfile);
### prt( "$pgmname ... Hello, World ...\n" );
#my $in_folder = "C:\\HOMEPAGE\\P26";
my $in_folder = '';
my @excl_list = qw( _derived _private _vti_cnf _vti_pvt );
my @folders = ();
my $excl = '';
my $cnt = 0;
my ($DH);
my $verb = 0;	# additional output ...
my $full = 0;	# show full path
my $wild = 1;	# show wild path
my $out_file = '';	# set an OUTPUT FILE

my $msg = '';
parse_args(@ARGV);
if (!length($in_folder)) {
	mydie( "ERROR: NO IN-FOLDER found ... \n" );
} elsif ( !-d $in_folder) {
	mydie( "ERROR: Unable to find FOLDER [$in_folder] ... $! ... \n" );
}
$cnt = process_directory( $in_folder, 0 );
prt( "Found list of $cnt ...\n" ) if ($verb);
if (length($out_file)) {
	open OUTF, ">$out_file" or mydie( "ERROR: Unable to create $out_file! ... $! ...\n" );
}
foreach $excl (@folders) {
	$msg = get_out_msg($excl);
	prt( "$msg\n" );
	if (length($out_file)) {
		print OUTF "$msg\n";
	}
}
if (length($out_file)) {
	close OUTF;
	prt( "List written to [$out_file] ...\n" );
}
close_log($outfile,0);
exit(0);


#####################################################
sub get_out_msg {
	my ($ex) = shift;
	if (!$full) {
		$ex = sub_main($ex);
	}
	if ($wild) {
		$ex .= "\\*.*";
	}
	return $ex;
}

sub give_help {
	prt( "$pgmname [options] in-folder\n" );
	prt( "Options:\n" );
	prt( " -? or -h = this brief help\n" );
	prt( " -f       = show full path\n" );
	prt( " -n       = no wild card addition\n" );
	prt( " -o file  = output file\n" );
	prt( " -v       = set verbosity\n" );
	prt( "Default in_folder = $in_folder\n" ) if (length($in_folder));
	mydie( "                              happy listing!\n" );
}

# Ensure argument exists, or die.
sub require_arg {
    my ($arg, @arglist) = @_;
    mydie( "ERROR: no argument given for option '$arg' ...\n" ) if ! @arglist;
}

sub parse_args {
	my @av = @_;
	while (@av) {
		my $arg = $av[0];
		if ($arg =~ /^-/) {
			if (($arg eq '-?')||($arg eq '-h')) {
				give_help();
			} elsif ($arg eq '-f') {
				$full = 1;
			} elsif ($arg eq '-n') {
				$wild = 0;
			} elsif ($arg eq '-o') {
				require_arg(@av);
				shift @av;
				$out_file = $av[0];
			} elsif ($arg eq '-v') {
				$verb = 1;
			} else {
				mydie( "ERROR: UNKNOWN ARG [$arg]!\n" );
			}
		} else {
			if ( -d $arg) {
				$in_folder = $arg;
				prt( "Set input folder to [$in_folder] ...\n" );
			} else {
				mydie( "ERROR: INPUT FOLDER [$arg] DOES NOT EXIST!\n" );
			}
		}
		shift @av;
	}
}

sub in_excl_list {
	my ($d) = shift;
	my $ld = lc($d);
	foreach my $ed (@excl_list) {
		if ($ld eq lc($ed)) {
			return 1;
		}
	}
	return 0;
}

sub sub_main {
	my ($f) = shift;
	return substr($f, length($in_folder) + 1);
}

sub process_directory { ## $in_folder
	my ($inf, $lev) = @_;
	my $rcnt = 0;
	if ( !opendir($DH, $inf) ) {
		prt( "ERROR: Unable to OPEN FOLDER [$inf] ... $! ... \n" );
		return $rcnt;
	}
	my @files = readdir($DH);
	closedir $DH;
	my $fcnt = scalar @files;
	prt( "Have $fcnt to process from $inf ...\n" ) if ($verb);
	foreach my $file (@files) {
		if (($file eq '.') || ($file eq '..')) {
			next;
		}
		my $ff = $inf . "\\" . $file;
		if (-d $ff) {
			if (in_excl_list($file)) {
				push(@folders, $ff);
				$rcnt++;
			}
			$rcnt += process_directory( $ff, $lev + 1 );
		}
	}
	return $rcnt;
}

# eof - fplist.pl
