#!/perl -w
# NAME: gencast.pl
# AIM: Take a line, and convert to MSVC with cast
# Handles several type of lines, but NOT ALL!
# 9/5/2009 - geoff mclane - http://geoffair.net/mperl/
use strict;
use warnings;
use Clipboard;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

##prt( "$0 ... Hello, World ...\n" );
my $in_line = '                uint8_t *newdata = av_malloc(asf_st->pkt.size);';

sub conv_line($) {
   my ($txt_in) = shift;
   my ($ptr,$obj,$txt, $msg, $lds, $cbk, $tlb, $qal);
   $txt = $txt_in;
   #if ($txt =~ /^\s*(\w+\s+\*)\s*\w+\s*=\s*(.+)\s*;\s*$/) {
   if ($txt =~ /^(\s*)(\w+\s*\*)(\s*\w+\s*=\s*)(.+)(\s*;\s*)$/) {
      $lds = $1;
      $ptr = $2;
      $cbk = $3;
      $obj = $4;
      $tlb = $5;
      prt( "OK 1 PTR[$ptr] = OBJ[$obj]\n" );
      #$txt =~ s/$obj/\($ptr\)$obj/;
      $txt = $lds.$ptr.$cbk.'('.$ptr.')'.$obj.$tlb;
      prt( "In  text [$txt_in]\n");
      prt( "new text [$txt]\n" );

      $msg = "#ifdef _MSC_VER /* add cast */\n";
      $msg .= "$txt\n";
      $msg .= "#else /* !_MSC_VER */\n";
      $msg .= "$txt_in\n";
      $msg .= "#endif /* _MSC_VER y/n */\n";
      Clipboard->copy($msg);
      prt( "Put on clipboard...\n" );
      prt( $msg );
      #                lds  ptr    *  qal        cbk            obj tlb
   } elsif ($txt =~ /^(\s*)(\w+\s*\*)(\s*\w+)(\s+\w+\s*=\s*)(.+)(\s*;\s*)$/) {
      # ASV1Context * const a = avctx->priv_data;
      $lds = $1;
      $ptr = $2;
      $qal = $3;
      $cbk = $4;
      $obj = $5;
      $tlb = $6;
      prt( "OK 2 LDS=[$lds] PTR[$ptr] QAL=[$qal] = OBJ[$obj]\n" );
      #$txt =~ s/$obj/\($ptr\)$obj/;
      $txt = $lds.$ptr.$qal.$cbk.'('.$ptr.$qal.')'.$obj.$tlb;
      prt( "In  text [$txt_in]\n");
      prt( "new text [$txt]\n" );

      $msg = "#ifdef _MSC_VER /* add cast */\n";
      $msg .= "$txt\n";
      $msg .= "#else /* !_MSC_VER */\n";
      $msg .= "$txt_in\n";
      $msg .= "#endif /* _MSC_VER y/n */\n";
      Clipboard->copy($msg);
      prt( "Put on clipboard...\n" );
      prt( $msg );
      #                lds  qal     ptr    *    cbk           obj tlb
   } elsif ($txt =~ /^(\s*)(\w+\s+)(\w+\s*\*)(\s*\w+\s*=\s*)(.+)(\s*;\s*)$/) {
      # const uint8_t *pi=  in[ch];
      $lds = $1;
      $ptr = $2;
      $qal = $3;
      $cbk = $4;
      $obj = $5;
      $tlb = $6;
      prt( "OK 3 LDS=[$lds] PTR=[$ptr] QAL=[$qal] CBK=[$cbk] OBJ=[$obj] TLB=[$tlb]\n" );
      #$txt =~ s/$obj/\($ptr\)$obj/;
      $txt = $lds.$ptr.$qal.$cbk.'('.$ptr.$qal.')'.$obj.$tlb;
      prt( "In  text [$txt_in]\n");
      prt( "new text [$txt]\n" );
      $msg = "#ifdef _MSC_VER /* add cast */\n";
      $msg .= "$txt\n";
      $msg .= "#else /* !_MSC_VER */\n";
      $msg .= "$txt_in\n";
      $msg .= "#endif /* _MSC_VER y/n */\n";
      Clipboard->copy($msg);
      prt( "Put on clipboard...\n" );
      prt( $msg );
      #                1         =   2     ( sizeof      (  /w+       ));
   #} elsif ($txt =~ /^(\s*\w+\s*=)(\s*\w+\s*)(\(\s*sizeof\s*\()(\s*\w+\s*)(\)\s*\)\s*;\s*)$/) {
   # } elsif ($txt =~ /^(\s*\w+\s*=)(\s*\w+\s*)(\(.*sizeof\s*\()(\s*\w+\s*)(\)\s*\)\s*;\s*)$/) {
   } elsif ($txt =~ /^(.+=)(\s*\w+\s*)(\(\s*sizeof\s*\()(\s*\w+\s*)(\)\s*\)\s*;\s*)$/) {
      # ctx = av_malloc(sizeof(AVAudioConvert));
      # prt( "1[$1]=2[$2]3[$3]4[$4]5[$5]\n" );
      $lds = $1;
      $ptr = $2;
      $qal = $3;
      $cbk = $4;
      $obj = $5;
      prt( "OK 4 1[$lds] ($cbk *)2[$ptr]3[$qal]4[$cbk]5[$obj]\n" );
      #$txt = $lds."($cbk *)".$ptr.$qal.$cbk.$obj;
      $txt = $lds;
      $txt .= ' ' if !($txt =~ /\s$/);
      $txt .= "($cbk *)";
      $txt .= ' ' if !($ptr =~ /^\s/);
      $txt .= $ptr.$qal.$cbk.$obj;
      prt("In  text [$txt_in]\n");
      prt("New text [$txt]\n");
      $msg = "#ifdef _MSC_VER /* add cast */\n";
      $msg .= "$txt\n";
      $msg .= "#else /* !_MSC_VER */\n";
      $msg .= "$txt_in\n";
      $msg .= "#endif /* _MSC_VER y/n */\n";
      Clipboard->copy($msg);
      prt( "Put on clipboard...\n" );
      prt( $msg );
   } elsif ($txt =~ /^(.+=)(\s*\w+\s*)(\(.*sizeof\s*\()(\s*\w+\s*)(\)\s*\)\s*;\s*)$/) {
      $lds = $1;
      $ptr = $2;
      $qal = $3;
      $cbk = $4;
      $obj = $5;
      prt( "OK 5 1[$lds] ($cbk *)2[$ptr]3[$qal]4[$cbk]5[$obj]\n" );
      $txt = $lds;
      $txt .= ' ' if !($txt =~ /\s$/);
      $txt .= "($cbk *)";
      $txt .= ' ' if !($ptr =~ /^\s/);
      $txt .= $ptr.$qal.$cbk.$obj;
      prt("In  text [$txt_in]\n");
      prt("New text [$txt]\n");
      $msg = "#ifdef _MSC_VER /* add cast */\n";
      $msg .= "$txt\n";
      $msg .= "#else /* !_MSC_VER */\n";
      $msg .= "$txt_in\n";
      $msg .= "#endif /* _MSC_VER y/n */\n";
      Clipboard->copy($msg);
      prt( "Put on clipboard...\n" );
      prt( $msg );

   } else {
      prt("*** ERROR *** NO GO for line=[$txt]\n");
      close_log($outfile,0);
      exit(1);
   }
}

$in_line = Clipboard->paste;
chomp $in_line;
$in_line =~ s/\n$//;
$in_line =~ s/\r$//;
conv_line( $in_line );


close_log($outfile,0);
exit(0);

# eof - gencast.pl

