#!/perl -w
# NAME: genclist.pl
# AIM: Convert a set of #define ABC, into a structure
# 28/09/2007 - geoff mclane - http://geoffair.net/mperl
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $in_file = 'C:\FG\FGCOM\fgcom\build\fgcom\ineterror.txt';
my $out_file = 'templist.txt';
my @list = ();
my $lstcnt = 0;
if (open INF, "<$in_file") {
	my @lines = <INF>;
	close INF;
	my $lncnt = @lines;
	my $itmcnt == 0;
	my $base = '';
	my $bgn = 12000;
	my $dig = 0;
	my $tot = 0;
	my $nitem = '';
	# ERROR_
	prt( "Processing $lncnt lines from $in_file ...\n" );
	foreach my $line (@lines) {
		$line = trim_all($line);
		$dig = 0;
		if ($line =~ /^#\s*define\s+(\w+)\s+(.*)/) {
			my $item = $1;
			my $bal = $2;
			$tot = $bgn;
			if ($bal =~ /\+\s+(\d+)[\)\s]+/) {
				$dig = $1;
				$tot += $dig;
			}
			$nitem = "$item($tot)";
			#prt( "$item($tot)\n" );
			$nitem = substr($nitem,6);
			prt( "$nitem\n" );
			push(@list, [$item, $nitem]);
			$itmcnt++;
		}
	}
} else {
	prt( "ERROR: Failed to open $in_file ...\n" );
}
$lstcnt = scalar @list;
prt( "Got $lstcnt items ...\n" );
if( $lstcnt > 0 ) {
	if (open OF, ">$out_file") {
		for (my $i = 0; $i < $lstcnt; $i++) {
			my $item = $list[$i][0];
			my $valu = $list[$i][1];
			print OF "   { $item, \"$valu\" },\n";
		}
		close OF;
	} else {
		prt( "ERROR: Failed to open out file $out_file ...\n" );
	}
}

close_log($outfile,1);
exit(0);

# eof
