#!/bin/perl
use strict;
use warnings;
use Geo::TAF;

my $test = 2;

my $t = new Geo::TAF;
if ($test == 1) {
    $t->metar("EGSH 311420Z 29010KT 1600 SHSN SCT004 BKN006 01/M00 Q1021");
} elsif ($test == 2) {
    #  or
    $t->taf("EGSH 311205Z 311322 04010KT 9999 SCT020 ".
        "TEMPO 1319 3000 SHSN BKN008 PROB30 ".
        "TEMPO 1318 0700 +SHSN VV/// ".
        "BECMG 1619 22005KT");
} else {
    print "Test number not set...\n";
    exit 1;
}
#  or 
#  $t->decode("METAR EGSH 311420Z 29010KT 1600 SHSN SCT004 BKN006 01/M00 Q1021");
#  or
#  $t->decode("TAF EGSH 311205Z 311322 04010KT 9999 SCT020
#     TEMPO 1319 3000 SHSN BKN008 PROB30
#     TEMPO 1318 0700 +SHSN VV///
#     BECMG 1619 22005KT");
print "As string list...\n";
foreach my $c ($t->chunks) {
    print $c->as_string, ' ';
    print "\n";
}
#  or
#  print $self->as_string;
print "\n";

print "As chunk list...\n";
foreach my $c ($t->chunks) {
      print $c->as_chunk, ' ';
}
print "\n";
#  or 
#  print $self->as_chunk_string;
#my @out = $self->as_strings;
#my @out = $self->as_chunk_strings;
#my $line = $self->raw;
#print Geo::TAF::is_weather($line) ? 1 : 0;

# eof
