#!/Perl
# html2text.pl - to escape all the '<' and '>' chars
# 23 Feb 2006
my $in_file = '';
my $out_file = 'tempout.txt';
my ($OF, $IF);
print "$0: Usage: in <in_file> [out <out_file>] (default out=$out_file)...\n";
parse_arguments(@ARGV);
if (length($in_file) == 0) {
	die "Usage: $0 in infile out outfile\n";
}
open $OF, ">$out_file" or die "Can not create $out_file!\n";

print( "Processing file $in_file ...\n" );
open $IF, "<$in_file" or die "Can not OPEN $in_file!\n";
print( "Loading $in_file ...\n");
my $line = '';
my @lines = <$IF>; # slurp whole file, to an array of lines
my $lncnt = scalar @lines;
close($IF);
print( "Processing $lncnt lines ...\n"); 
foreach $line (@lines) {
	$line =~ s/</\&lt;/g;
	$line =~ s/>/\&gt;/g;
	prt( $OF, $line );
}
close $OF;
print( "Done $lncnt lines ...\n"); 

######################
### subs only below
sub parse_arguments {
    my @av = @_;
    while (@av) {
		my $arg = lc($av[0]); # get argument
		if ($arg eq "in") {
			require_argument(@av);
			shift @av;
			$arg = $av[0];
			print "Setting in file to $arg...\n";
			$in_file = $arg;
		} elsif ($arg eq "out") {
			print "Setting in file to $arg...\n";
			$out_file = $arg;
		}
		shift @av;
	}
}

# Ensure argument exists, or die.
sub require_argument
{
    my ($arg, @arglist) = @_;
    die "am2dsp: no argument given for option \`$arg'\n"
        if ! @arglist;
}

sub prt {
	my ($fh,$t) = @_;
	print $t;
	print $fh $t;
}

# eof - html2text.pl
