#!perl -w
# NAME: iftest.pl
# AIM: Test soem IF patterns, from Makefile.am files
# 11/11/2008 - geoff mclane - http://geoffair.net/mperl
# ####################################################
use strict;
use warnings;

# constants
my $IF_PATTERN = "^if[ \t]+\([A-Za-z][A-Za-z0-9_]*\)[ \t]*\(#.*\)?\$";
my $NIF_PATTERN = "^if[ \t]+!(.+)\$";
my $ELSE_PATTERN = "^else[ \t]*\(#.*\)?\$";
my $ENDIF_PATTERN = "^endif[ \t]*\(#.*\)?\$";

my $txt = <<EOF;
if !WOE32DLL
libgettextlib_la_SOURCES += html-styled-ostream.c
else
libgettextlib_la_SOURCES += ../woe32dll/c++html-styled-ostream.cc
endif
# This is a Makefile rule that generates multiple files at once; see the
EOF

my @arr = split(/\n/,$txt);
my $lnnum = 0;
foreach my $line (@arr) {
    $lnnum++;
    print "$lnnum: [$line]\n";
    if ($line =~ /$IF_PATTERN/) {
        print "Begin IF [$1]\n";
    } elsif ($line =~ /$NIF_PATTERN/) {
        print "Begin NOT IF [$1]\n";
    } elsif ($line =~ /$ELSE_PATTERN/) {
        print "ELSE IF [$1]\n";
    } elsif ($line =~ /$ENDIF_PATTERN/) {
        print "END IF\n";
    } elsif ($line =~ /^(\w+)\s*=\s*(.*)$/) {
        print "EQUAL: [$1] = [$2]\n";
    } elsif ($line =~ /^(\w+)\s*\+=\s*(.*)$/) {
        print "PLUS EQUAL: [$1] = [$2]\n";
    }
}

