#!/perl -w
# NAME: list2array.pl
# AIM: Take a file list, and build a perl array item.
# 16/07/2010 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[.]*/] )
use Cwd;
unshift(@INC, 'C:\GTools\perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:\GTools\perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 1;
my $in_file = 'templist.txt';
my $max_width = 100;

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub process_file($) {
    my ($inf) = @_;
    if (!open INF, "<$inf") {
        pgm_exit(1,"ERROR: Can NOT open file [$inf]...\n");
    }
    my @lines = <INF>;
    close INF;
    my ($line,$word,$out,$len,$ch,$lncnt,$i,$j);
    $word = '';
    $out = '';
    $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    for ($i = 0; $i < $lncnt; $i++) {
        $line = $lines[$i];
        $line = trim_all($line);
        $len = length($line);
        for ($j = 0; $j < $len; $j++) {
            $ch = substr($line,$j,1);
            if ($ch =~ /\s/) {
                if (length($word)) {
                    $out .= ' ' if (length($out));
                    $out .= $word;
                    if (length($out) > $max_width) {
                        prt("$out\n");
                        $out = '';
                        #pgm_exit(1,"TEMP");
                    }
                }
                $word = '';
            } else {
                $word .= $ch;
            }
        }

        if (length($word)) {
            $out .= ' ' if (length($out));
            $out .= $word;
            if (length($out) > $max_width) {
                prt("$out\n");
                $out = '';
                #pgm_exit(1,"TEMP2");
            }
            $word = '';
        }
    }
    if (length($word)) {
        $out .= ' ' if (length($out));
        $out .= $word;
    }
    if (length($out)) {
        prt("$out\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_file($in_file);
prt( "$pgmname: in [$cwd]: Hello, World...\n" );
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-05-05\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have follwoing argument!\n")
        if (!@av);
}
sub parse_args {
    my (@av) = @_;
    while (@av) {
        my $arg = $av[0];
        if ($arg =~ /-/) {
            my $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /-/);
            if (($sarg =~ /h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }
}

# eof - template.pl
