#!/perl -w
# NAME: listfpfolders.pl
# AIM: Given an imput foldeer. make a list of all FRONTPAGE folders
# I use this list to avoid ZIPPING these folders, when doing a zip backup ...
# 17/07/2008 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}

my $outfile = 'C:\GTools\perl\temp.'.$pgmname.'.txt';
open_log($outfile);
### prt( "$0 ... Hello, World ...\n" );
my $in_folder = '';
my $def_folder = 'C:\HOMEPAGE';
$in_folder = shift @ARGV || $def_folder;

my @fpfolders = qw( _vti_cnf _vti_pvt _private _derived );
my @folderlist = ();
my $fndcnt = 0;
my $filcnt = 0;
my $dircnt = 0;
my $file = '';
my $start_time = time();
prt( "Processing folder $in_folder ...\n" );

get_folder_list($in_folder);
$fndcnt = scalar @folderlist;
prt( "Found $fndcnt FRONTPAGE folders ... in $dircnt directories, $filcnt files ...(in ".elapsed_seconds()." secs)\n" );
foreach $file (@folderlist) {
    prt( "$file\n" );
}
prt( "Printed $fndcnt FRONTPAGE folders ... (in ".elapsed_seconds()." secs)\n" );

close_log($outfile,1);
exit(0);

######################################
sub elapsed_seconds {
    my $tm = time();
    return ($tm - $start_time);
}

sub is_fp_folder {
    my ($fdr) = shift;
    my $tst;
    foreach $tst (@fpfolders) {
        if ($tst eq $fdr) {
            return 1;
        }
    }
    return 0;
}

sub get_folder_list {
    my ($inf) = shift;
    my ($itm, $ff);
    my @fldrs = ();
	if ( opendir( DIR, $inf ) ) {
		my @files = readdir(DIR);
		closedir DIR;
		foreach $itm (@files) {
			if (($itm eq '.') || ($itm eq '..')) {
				next;
			}
			$ff = $inf . "\\" . $itm;
			if (-d $ff) {
                if ( is_fp_folder($itm) ) {
                    push(@folderlist, $ff);
                }
                push(@fldrs,$ff);
                $dircnt++;
                if (($dircnt % 100) == 0) {
                    prt( "Found ".scalar @folderlist." FRONTPAGE folders ... in $dircnt directories, $filcnt files ... (".elapsed_seconds()." secs)\n" );
                }
            } else {
                $filcnt++;
            }
        }
        foreach $itm (@fldrs) {
            get_folder_list($itm);
        }
    } else {
        prt( "ERROR: Failed to OPEN $inf ...\n" );
    }
}

# eof - listfpfolders.pl
