#!/usr/bin/perl -w
# NAME: match.pl
# AIM: Testing 'matching' to wild functions
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my $in_file = '';

my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        ###prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

my $wild = '?b*.dsw';
my $file1 = 'abcd.dsw';
my $test1 = 'Makefile.*';
my $test2 = 'Makefile';
my $test3 = 'Makefile.debug';
my @user_xcludes = ();
my $dbg_mww = 0;
sub match_with_wild($$) {
    my ($fil1,$fil2) = @_;
    my $len1 = length($fil1);
    my $len2 = length($fil2);
    prt("match_with_wild: [$fil1] [$fil2] ") if ($dbg_mww);
    my ($i,$j,$c1,$c2);
    $i = 0;
    $j = 0;
    if (($len1 > 0) && ($len2 > 0)) {
        while (($i < $len1)&&($j < $len2)) {
            $c1 = substr($fil1,$i,1);
            $c2 = substr($fil2,$j,1);
            if (($c1 eq $c2)||($c1 eq '?')||($c2 eq '?')) {
                $i++;
                $j++;
                prt("$c1= ") if ($dbg_mww);
            } elsif ($c2 eq '*') {
                $i++; # any $c1 matches asterick
                if (($j + 1) < $len2) {
                    # but if more, maybe time to step past '*'
                    $c2 = substr($fil2,($j+1),1);
                    if ($c1 eq $c2) {
                        $j += 2;
                    }
                }
                prt("$c1* ") if ($dbg_mww);
            } elsif ($c1 eq '*') {
                $j++; # any $c2 matches asterick
                if (($i + 1) < $len1) {
                    # but if more, maybe time to step past '*'
                    $c1 = substr($fil1,($i+1),1);
                    if ($c1 eq $c2) {
                        $i += 2;
                    }
                }
                prt("$c2* ") if ($dbg_mww);
            } else {
                prt(" = 0 - [$c1] ne [$c2]\n") if ($dbg_mww);
                return 0;
            }
        }
        if (($i == $len1)&&($j == $len2)) {
            prt(" = 1 - both ran out of chars\n") if ($dbg_mww);
            return 1; # both ran out of chars
        } elsif (($i == $len1)&&($c2 eq '*')&&(($j + 1) == $len2)){
            prt(" = 1 - first ran out and last is second $c2\n") if ($dbg_mww);
            return 1; # first ran out, and second is last '*'
        } elsif (($j == $len2)&&($c1 eq '*')&&(($i + 1) == $len1)){
            prt(" = 1 - second ran out and last of first is $c1\n") if ($dbg_mww);
            return 1; # second ran out, and second is last '*'
        } 
        prt(" = 0 - failed - no case\n") if ($dbg_mww);
    } elsif ($len1 > 0) {
        # 2nd is nul
        if ($fil1 eq '*') {
            prt(" = 1 - asterix matches nul\n") if ($dbg_mww);
            return 1; # nul matches asterix
        }
        prt(" = 0 - len1 > 0, but [$fil1]\n") if ($dbg_mww);
    } elsif ($len2 > 0) {
        # 1st is nul
        if ($fil2 eq '*') {
            prt(" = 1 - nul match asterix\n") if ($dbg_mww);
            return 1; # nul matches asterix
        }
        prt(" = 0 - len2 > 0, but [$fil1]\n") if ($dbg_mww);
    } else {
        prt(" = 0 - no case\n") if ($dbg_mww);
    }
    return 0;
}

sub matches_wild($$) {
    my ($fil,$wild) = @_;
	my ($n1,$d1,$e1) = fileparse( $fil, qr/\.[^.]*/ );
	my ($n2,$d2,$e2) = fileparse( $wild, qr/\.[^.]*/ );
    my $lcn1 = lc($n1);
    my $lcn2 = lc($n2);
    # strip . from extension
    $e1 =~ s/^\.//;
    $e2 =~ s/^\.//;
    my $lce1 = lc($e1);
    my $lce2 = lc($e2);
    prt("matches_wild: [$n1] [$n2] and [$e1] [$e2]\n");
    return 1 if (($lcn1 eq $lcn2)&&($lce1 eq $lce2));
    return 2 if (($lcn1 eq $lcn2)&&($lce2 eq '*'));
    return 3 if (($lcn2 eq '*')&&($lce1 eq $lce2));
    return 4 if (match_with_wild($lcn1,$lcn2) && match_with_wild($lce1,$lce2));
    return 0;
}

sub has_wild($) {
    my $txt = shift;
    my $len = length($txt);
    my ($i,$c);
    for ($i = 0; $i < $len; $i++) {
        $c = substr($txt,$i,1);
        if (($c eq '?')||($c eq '*')) {
            return 1;
        }
    }
    return 0;
}

sub in_user_excludes($) {
    my ($fil) = shift;
    my ($nam,$dir) = fileparse($fil);
    my ($item);
    my $hw = has_wild($fil);
    foreach $item (@user_xcludes) {
        return 1 if ($nam eq $item);
        if ($hw || has_wild($item)) {
            return 2 if (matches_wild($item,$nam));
        }
    }
    return 0;
}

my $res = matches_wild($file1,$wild);
if ($res > 0) {
    prt("MATCH: file [$file1] matches [$wild] ($res)\n");
} else {
    prt("NO MATCH: file [$file1] DOES NOT match [$wild] ($res)\n");
}

push(@user_xcludes,'Makefile.*');
if (in_user_excludes($test1)) {
    prt("Found [$test1]\n");
} else {
    prt("NO MATCH [$test1]\n");
}
if (in_user_excludes($test2)) {
    prt("Found [$test2]\n");
} else {
    prt("NO MATCH [$test2]\n");
}
if (in_user_excludes($test3)) {
    prt("Found [$test3]\n");
} else {
    prt("NO MATCH [$test3]\n");
}
#########################################
### MAIN ###
#parse_args(@ARGV);
#prt( "$pgmname: in [$cwd]: Hello, World...\n" );
#process_in_file($in_file);
pgm_exit(0,"");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-09-11\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

# eof - template.pl
