#!/perl -w
# NAME: msvcvers.pl
# AIM: To check what VERSIONS of MSVC build files exist in a particular folder ...
# If *.dsp (and maybe *.dsp) then Version 6 (MSVC6)
# If *.sln (and maybe *.vcproj) then CHECK if 7 or 8 ...
# 14/11/2009 - minor update
use strict;
use warnings;
use File::stat;
use Cwd;
# so it can be run from anywhere ...
unshift(@INC, 'G:\GTools\perl');
#require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
#my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
   my @tmparr = split(/(\\|\/)/,$pgmname);
   $pgmname = $tmparr[-1];
}
#my $outfile = 'temp.'.$0.'.txt';
#if ($0 =~ /\w{1}:\\.*/) {
#	my @tmpsp = split(/\\/,$0);
#	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
#}
#open_log($outfile);
my $folder = 'G:\Gtools\tools\dc4w';
my $cwd = getcwd();
my @files = ();
my $fcnt = 0;
# debug
my $dbg1 = 0;	# show extent
my $dbg2 = 0;	# show directories
my $dbg3 = 0;	# show discards
my $dbg4 = 0;	# show folder in process
my $dbg5 = 0;	# show files is MSVC type
my $typ1 = 1;	# is DSW
my $typ2 = 2;	# is DSP
my $typ3 = 3;	# is SLN
my $typ4 = 4;	# is VCPROJ
# version counts
my $cver5 = 0;
my $cver6 = 0;
my $cver7 = 0;
my $cver8 = 0;
my $cver9 = 0;
my $cvero = 0;
my @others = ();
my $ctot = 0;

if (@ARGV) {
	$folder = pop(@ARGV);
   prt( "$pgmname: Set folder to $folder...\n" );
}
if ($folder eq '.') {
	$folder = $cwd;
}
scandir( $folder );
$fcnt = scalar @files;
if ($fcnt) {
	prt( "Found $fcnt MSVC files in folder, or sub-folder of, $folder ...\n" );
	eliminate_dupes();
	scanfiles();
	$ctot = $cver5 + $cver6 + $cver7 + $cver8 + $cver9 + $cvero;
	if ($ctot) {
		prt( "Found $ctot: " );
		if( $cver5 ) {
			prt( "$cver5 vers 5, " );
		}
		if( $cver6 ) {
			prt( "$cver6 vers 6, " );
		}
		if( $cver7 ) {
			prt( "$cver7 vers 7, " );
		}
		if( $cver8 ) {
			prt( "$cver8 vers 8, " );
		}
		if( $cver9 ) {
			prt( "$cver9 vers 9, " );
		}
		if( $cvero ) {
			# my @others = ();
			prt( "$cvero vers others " );
		}
		prt( "in $folder folder ...\n" );
		if( $cvero ) {
			foreach my $m (@others) {
				prt( "$m\n" );
			}
		}
	}
} else {
	prt( "Did NOT file any MSVC files in folder, or sub-folder of, $folder ...\n" );
}

#close_log($outfile,1);
#print "Deleting $outfile ...\n";
#if (unlink($outfile)==0) {
#	print "Deleted $outfile ...\n";
#} else {
#	print "WARNING: $outfile not deleted ...$! ...\n";
#}
exit(0);

# subs ========================
sub prt {
	my ($msg) = shift;
	print $msg;
}

sub eliminate_dupes {
	# push(@files, [$fdr, $fil, $ft, 1]);
	my ($i, $j, $cnt, $fdr, $fil, $typ, $ff, $sb, $act, $fn, $fn2);
	$cnt = scalar @files;
	for ($i = 0; $i < $cnt; $i++) {
		$fdr = $files[$i][0];
		$fil = $files[$i][1];
		$typ = $files[$i][2];
		$act = $files[$i][3];
		$ff = $fdr . '\\' . $fil;
		$sb = stat($ff);
		if (defined $sb) {
			if ($typ == $typ1) { # found a DSW
				# eliminate equivalent DSP, if it EXISTS
				$fn = uc(get_file_name($fil));
				for ($j = 0; $j < $cnt; $j++) {
					if ($i != $j) {
						if ($files[$j][2] == $typ2) {
							$fn2 = uc(get_file_name($files[$j][1]));
							if ($fn eq $fn2) {
								$files[$j][3] = 0;
							}
						}
					}
				}
			}
		} else {
			$files[$i][3] = 0;
			prt( "ERROR: Failed to stat [$ff] ... $! ...\n" );
		}
	}
}

sub get_file_name {
	my ($fil) = shift;
	my @arr = split(/\./,$fil);
	my $cnt = scalar @arr;
	$cnt-- if ($cnt > 1);
	my $rfn = ' ';
	for (my $i = 0; $i < $cnt; $i++) {
		$rfn .= '.' if (length($rfn));
		$rfn .= $arr[$i];
	}
	return $rfn;
}

sub ver_count {
	my ($v) = shift;
	if ($v == 5) {
		$cver5++;
	} elsif ($v == 6) {
		$cver6++;
	} elsif ($v == 7) {
		$cver7++;
	} elsif ($v == 8) {
		$cver8++;
	} elsif ($v == 9) {
		$cver9++;
	} else {
		$cvero++;
		return 1;
	}
	return 0;
}

sub scanfiles {
	# push(@files, [$fdr, $fil, $ft, 1]);
	my ($i, $cnt, $fdr, $fil, $typ, $ff, $sb, $act, $vers, $mver, $msg);
	my @arr = ();
	$cnt = scalar @files;
	for ($i = 0; $i < $cnt; $i++) {
		$fdr = $files[$i][0];
		$fil = $files[$i][1];
		$typ = $files[$i][2];
		$act = $files[$i][3];
		if ($act == 0) {
			next;
		}
		$ff = $fdr . '\\' . $fil;
		$sb = stat($ff);
		if (defined $sb) {
			open( IF, $ff ) or next;
			while (<IF>) {
				if ($_ =~ /.+Format\s+Version\s+(\d+\.\d+)$/i) {
					$vers = $1;	# get n.nn version
					@arr = split(/\./,$vers);
					$mver = $arr[0];
					###prt( YYYYMMDD( $sb->mtime ). " $fil = Format Version $1 [$fdr]\n" );
					$msg = "$vers $fil ". YYYYMMDD( $sb->mtime ). " [$fdr]";
					if ( ver_count($mver) ) {
						push(@others, $msg);
					}
					prt( "$msg\n" );
					last;
				}
			}
			close IF;
		} else {
			prt( "ERROR: Failed to stat [$ff] ... $! ...\n" );
		}
	}
}

################################################
# My particular time 'translation' - replaced date_string
sub YYYYMMDD {
	#  0    1    2     3     4    5     6     7     8
	my ($tm) = shift;
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($tm);
	$year += 1900;
	$mon += 1;
	my $ymd = "$year/";
	if ($mon < 10) {
		$ymd .= '0'.$mon.'/';
	} else {
		$ymd .= "$mon/";
	}
	if ($mday < 10) {
		$ymd .= '0'.$mday;
	} else {
		$ymd .= "$mday";
	}
	return $ymd;
}

sub is_my_files {
	my ($file) = shift;
	my @arr = split(/\./, $file);
	my $ext = lc($arr[-1]);
	prt( "Got ext=$ext from $file ...\n" ) if ($dbg1);
	if ($ext eq 'dsw') {
		return $typ1;
	} elsif ($ext eq 'dsp') {
		return $typ2;
	} elsif ($ext eq 'sln') {
		return $typ3;
	} elsif ($ext eq 'vcproj') {
		return $typ4;
	}
	return 0;
}

sub scandir {
	my ($fdr) = shift;
	prt( "Checking folder [$folder] ...\n" ) if ($dbg4);
	my ($dh, $ff, $fil, $ft);
	my $cnt = 0;
	my @dirs = ();
	if ( !opendir($dh, $fdr) ) {
		prt( "ERROR: Can NOT open directory [$fdr]!\n" );
		return;
	}
	while ($fil = readdir($dh)) {
		next if (($fil eq '.') || ($fil eq '..'));
		$ff = $fdr . '\\' . $fil; # get FULL PATH
		if ( -d $ff ) {
			prt( "Got directory [$ff] ...\n" ) if ($dbg2);
			push(@dirs, $ff);
		} else {
			$ft = is_my_files( $fil );
			if ($ft) {
				prt( "$fil is MSVC ...\n" ); # if ($dbg5);
				push(@files, [$fdr, $fil, $ft, 1]);
				$cnt++;
			} else {
				prt( "Discarding [$fil] ...\n" ) if ($dbg3);
			}
		}
	}
	closedir($dh);
	if ($cnt) {
		prt( "Found $cnt MSVC files ...\n" ) if ($dbg5);
	} else {
		prt( "Found NO MSVC files ...\n" ) if ($dbg4);
	}
	foreach $ff (@dirs) {
		scandir($ff);
	}
}

# eof - msvcvers.pl
