#!/usr/bin/perl

use Test;
BEGIN { plan tests => 5 }
use XML::XPath;
my $xp = XML::XPath->new(filename => 'order.xml');
my (@nodes, $test); # pre-declare a few vars

@nodes = $xp->findnodes('/order');
ok(@nodes == 1, 1, "the root element must be an 'order'");

@nodes = $xp->findnodes('/order/customer/shipping_info');
ok(@nodes == 1, 1, "an order must contain a 'customer' element with a 'shipping_info' child");

$test = $xp->find('count(/order/item)');
ok($test > 0, 1, "an order must contain at least one 'item' element");

$test  = $xp->find('boolean(count(/order/item/product)=count(/order/item))');
#$test = $xp->find('boolean(count(/order/item/product)=count(/order/item/))');
ok($test == 1, 1, "a 'item' element must contain a an 'product' element.");

$test = $xp->find('boolean(count(/order/item/quantity)=count(/order/item))');
ok($test == 1, 1,  "a 'item' element must contain a 'quantity' element.");

