#!/usr/bin/perl -w
# NAME: ratio.pl
# AIM: Given a size like 3296x2472, and a desired width, like 400, find height
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2011-11-03";
my $load_log = 0;
my $in_ratio = '';
my $verbosity = 0;
my $debug_on = 0;
my $def_file = '3296x2472';
my $out_xml = '';

my $usr_width = 0;
my $usr_height = 0;
my $des_width = '';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub show_ratio() {
    my $ratio = $usr_width / $usr_height;
    prt("Ratio is [$ratio]\n");
    if (length($des_width)) {
        my $tw = $des_width;
        my ($imgSx, $imgSy);
        if($ratio > 1) {
            $imgSx = $tw;
            $imgSy = int( ($tw / $ratio) + 0.5 );
        } else {
            $imgSx = int( ($tw * $ratio) + 0.5 );
            $imgSy = $tw;
        }
        prt("New image size convert <input> resize ${imgSx}x${imgSy} <output>\n");
        prt(" width=\"$imgSx\" height=\"$imgSy\"\n");
    }
}


#########################################
### MAIN ###
parse_args(@ARGV);
### prt( "$pgmname: in [$cwd]: Hello, World...\n" );
##process_in_file($in_ratio);
show_ratio();

pgm_exit(0,"");
########################################
sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] ratio desired\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    #prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    # prt(" --out <file>  (-o) = Write output to this file.\n");
}

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg,@arr);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity, but does nothing...\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                $load_log = 1;
                prt("Set to load log at end.\n") if (VERB1());
            #} elsif ($sarg =~ /^o/) {
            #    need_arg(@av);
            #    shift @av;
            #    $sarg = $av[0];
            #    $out_xml = $sarg;
            #    prt("Set out file to [$out_xml].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            if (length($in_ratio)) {
                if (length($des_width)) {
                    pgm_exit(1,"ERROR: Already have ratio [$in_ratio], and desired width [$des_width]\nWhat is this value [$arg]?\n");
                } else {
                    $des_width = $arg;
                }
            } else {
                $in_ratio = $arg;
                prt("Set input to [$in_ratio]\n");
            }
        }
        shift @av;
    }

    if ((length($in_ratio) ==  0) && $debug_on) {
        $in_ratio = $def_file;
        $des_width = 600;
    }
    if (length($in_ratio) ==  0) {
        pgm_exit(1,"ERROR: No input ratio found in command!\n");
    }
    @arr = split(/x/,$in_ratio);
    if (scalar @arr != 2) {
        pgm_exit(1,"ERROR: Ratio [$in_ratio] did not split into 2 by an 'x'!\n");
    }
    $usr_width = $arr[0];
    $usr_height = $arr[1];
    if (($usr_width <= 0)||($usr_height <= 0)) {
        pgm_exit(1,"ERROR: Ratio [$in_ratio] - Width=$usr_width, Height=$usr_height bot not positive!\n");
    }
}

# eof - template.pl
