#!/Perl
# reg04.pl
# search for entries in the registry ...
use Win32::Registry;
%TYPES = (
  &REG_SZ         =>  "REG_SZ",
  &REG_EXPAND_SZ  =>  "REG_EXPAND_SZ",
  &REG_MULTI_SZ   =>  "REG_MULTI_SZ",
  &REG_DWORD      =>  "REG_DWORD",
  &REG_BINARY     =>  "REG_BINARY"
);
$giTotal = $giTotalMatch = 0;
require "logfile.pl" or die "ERROR: Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';

my $keyroot = $HKEY_CURRENT_USER;
###@finds = qw(wmserver wmplayer);
my @finds = qw(MRU);
###@finds = qw(access-05b.txt);
my $inipath = '';	# sort of '\' root
my $lastpath = '';
my $fndcnt = 0;
my $dbg1 = 1;
my $msg = '';
my $fnd = '';
my @Keysfound = ();

open_log($outfile);
prt( "Processing root=[$keyroot] path=[$inipath]...\n" );
ProcessKey( $keyroot, $inipath );
$fndcnt = scalar @Keysfound;
prt( "\nIn finding [" . join(' ', @finds) . "] ...\n" );
prt( "Total values checked          : $giTotal\n" );
prt( "Total values matching criteria: $giTotalMatch ($fndcnt)\n" );

##  $msg = sprintf( " % 6d) %s:%s = '%s'\n",
##    ++$giTotalMatch, $Path,
##    $ValueName, $Data );
##	push( @Keysfound, [ $Path, $ValueName, $Data, $msg ] );
## 1) Software\Microsoft\Keyboard\Native Media Players\WMP:ExePath = 'C:\Program Files\Windows Media Player\wmplayer.exe'
my $fpb = '';
for (my $i = 0; $i < $fndcnt; $i++) {
	my $p = $Keysfound[$i][0]; # path
	my $n = $Keysfound[$i][1]; # name
	my $fp = $p.":".$n;	# get FULL path name
	my $dp = 0;
	my $df = 0;
	$msg = sprintf( " % 6d) ", ($i + 1) );
	while ( length($fpb) < length($fp) ) {
		$fpb .= ' ';
	}
	if ($lastpath ne $fp) {
		$msg .= $fp;
		$dp = 1;
		$lastpath = $fp;
	}
	if (!$dp) {
		$msg .= $fpb;
	}

	my $d = $Keysfound[$i][2]; # data
	foreach $fnd (@finds) {
		if ($d =~ /$fnd/i) {
			$msg .= " = [$fnd]";
			$df = 1;
			last;
		}
	}
	if (!$df) {
		$msg .= "*** CHECK THIS ITEM ***";
	}
	prt( "012F $msg\n" );

	$msg = $Keysfound[$i][3];
	prt( "---3 $msg\n" );
}


close_log( $outfile, 1 );

# Begin Callout A
sub ProcessKey
# End Callout A
{
  my( $Root, $Path ) = @_;
  my $Key;
  $giTotal++;
  if (!( $Path =~ /[\\\/]/ ) && ($lastpath ne $Path)) {
	  prt( "Processing path [$Path] ...\n" );
	  $lastpath = $Path;
  }
  if (($giTotal % 1000) == 0) {
	  prt( "Found $giTotalMatch match of $giTotal, keys\n" );
  }
# Begin callout B
  if( $Root->Open( $Path, $Key ) )
# End callout B
  {
    my @KeyList;
    my %Values;
# Begin Callout C
    $Key->GetKeys( \@KeyList );
# End Callout C
# Begin Callout D
    if( $Key->GetValues( \%Values ) )
# End Callout D
    {
# Begin Callout E
      foreach my $ValueName ( sort( keys( %Values ) ) )
      {
        my $Type = $Values{$ValueName}->[1];
        my $Data = $Values{$ValueName}->[2];
# Begin Callout F
        $ValueName = "<Default Class>" if( "" eq $ValueName );
# End Callout F
        ##foreach my $Target ( @{$Config{find}} )
        foreach my $Target ( @finds )
        {
          if( $Data =~ /$Target/i )
          {
# Begin Callout G
			++$giTotalMatch; # bump match counter
            $msg = sprintf( " % 6d) %s:%s = '%s'\n",
                    $giTotalMatch, $Path,
                    $ValueName, $Data );
			push( @Keysfound, [ $Path, $ValueName, $Data, $msg ] );
			prt( $msg ) if ($dbg1);
# End Callout G
            last;
          }
        }
      }
# End Callout E
    }
    else
    {
      prt( "Unable to get values for key: '$Path'\n" );
    }
# Begin Callout H
    $Key->Close();
    $Path .= "\\" unless ( "" eq $Path );
    foreach my $SubKey ( sort ( @KeyList ) )
    {
      ProcessKey( $Root, $Path . $SubKey );
    }
# End Callout H
  }
  else
  {
    prt( "Unable to open the key: '$Path'\n" );
  }
}

sub Syntax
{
# Begin Callout K
    my $Script = ( Win32::GetFullPathName( Win32::GetLongPathName( $0 )))[1];
# End Callout K
    my $Line = "-" x length( $Script );
    print STDERR << "EOT";

    $Script
    $Line
    Locates specified strings in the Registry.
    Syntax: $Script [-r <Root>] [-k KeyPath] <Find> [<Find2> [<Find3> [...]]]
      Root..........Registry root to look into such as
                    HKEY_LOCAL_MACHINE or HKEY_CURRENT_USER
                    Default: HKEY_LOCAL_MACHINE
      KeyPath.......Path to a key in the specified root.
                    Default = "\\"
      Find..........String to search for.

      Examples:
        perl $Script -r HKEY_LOCAL_MACHINE wmserver wmplayer
EOT
}

