#!/perl -w
# NAME: setifdef.pl
# AIM: Given a line on the clipboard, extract, duplicate, and set #ifdef _MSC_VER around it
# and back into the clipboard
use strict;
use warnings;
use Clipboard;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
#prt( "$0 ... Hello, World ...\n" );

my $txt = Clipboard->paste;
chomp $txt;
$txt =~ s/\n$//;
$txt =~ s/\r$//;
prt( "Got [$txt] from clipboard...\n" );
my $ntxt = "#ifdef _MSC_VER /* CHECKME!!! */\n";
$ntxt .= "$txt\n";
$ntxt .= "#else /* !_MSC_VER */\n";
$ntxt .= "$txt\n";
$ntxt .= "#endif /* _MSC_VER y/n */\n";
prt( "Returning to clipboard -\n" );
prt( $ntxt );
Clipboard->copy($ntxt);

close_log($outfile,0);
exit(0);

# eof
