# test hash reference building
use strict;
use warnings;
sub prt($) { my ($txt) = shift; print $txt; }
sub build_hash() {
    my %hash = ();
    my @dirs = qw( dir1 dir2 dir3 );
    my @fils = qw( file1 file2 file3 );
    my @type = qw( HTML IMG SCRIPT Other );
    my $tcnt = scalar @type;
    my ($dir,$file,$hr,$cnt,$ar,$typ);
    $cnt = 0;
    foreach $dir (@dirs) {
        $hash{$dir} = { };  # set empty ref hash
        foreach $file (@fils) {
            $typ = $type[$cnt];
            $cnt++;
            $cnt = 0 if ($cnt >= $tcnt);
            $hr = $hash{$dir};  # get ref hash
            # set ref array, if none
            ${$hr}{$typ} = [] if (!defined ${$hr}{$typ});
            $ar = ${$hr}{$typ}; # extract ref array
            push(@{$ar},$file); # and add a file...
        }
    }
    return \%hash;
}

sub show_hash_ref($) {
    my ($hr) = @_;
    my ($key,$val,$k2,$v2,$v3);
    foreach $key (keys %{$hr}) {
        $val = ${$hr}{$key};    # extract hash ref
        foreach $k2 (keys %{$val}) {
            $v2 = ${$val}{$k2};
            foreach $v3 (@{$v2}) {
                prt("$key $k2 $v3\n");
            }
        }
    }
}

my $ref_hash = build_hash();
show_hash_ref($ref_hash);

# eof - test-hash-ref.pl

