#!/usr/local/bin/perl -wT

# Added by Suretec Systems Ltd. - http://www.suretecsystems.com - 14/05/2006
use warnings;
use strict; 

my $callfiledir="/var/spool/asterisk/outgoing";
my $originateContext = 'home-out';
my $tmpdir = '/var/tmp'; # must be on same file system as $callfiledir
my $wakeupFile = 'tt-monkeys';
my $confirmFile = 'auth-thankyou';

use Asterisk::AGI;
use Time::Local;
use IO::File;
use File::Temp qw/ tempfile /;

my $AGI = new Asterisk::AGI;
$AGI->setcallback(\&callback);
sub callback() { exit; }

my %agiEnv = $AGI->ReadParse();

my ($caller) = $agiEnv{callerid} =~ /<(\d+)>/;
if (!defined $caller) {
    ($caller) = $agiEnv{callerid} =~ /(\d+)/;
}

$extension = $agiEnv{extension};
$extension =~ s/\%23/\#/g;         # unquote pound sign

$AGI->answer();
sleep 1;

if (!defined $caller) {
    print STDERR "Could not get caller id for wakeup call\n";
    $AGI->stream_file('tt-somethingwrong');
} elsif ($extension eq "#55#") {
    foreach my $fn (<$callfiledir/wakeup.$caller.*.call>)
    {
        unlink $fn;
    }
    $AGI->stream_file($confirmFile);
} elsif ($extension eq "*#55#") {
    my $foundOne = 0;
    foreach my $fn (<$callfiledir/wakeup.$caller.*.call>)
    {
        $foundOne = 1;
        my ($hour, $minute) = $fn =~ /\.(\d{2})(\d{2})\.call/;
        $AGI->say_number($hour);
        $AGI->say_number($minute);
    }
    if (!$foundOne) {
        $AGI->stream_file('dir-nomatch');
    }
} elsif ($extension =~ /^[\#\*]55\*\d{4}\#$/) {
    my $set = $extension =~ /^\*/;
    my ($hour, $minute) = ($extension =~ /^[\#\*]55\*(\d{2})(\d{2})\#$/);

    if ($hour > 23 || $minute > 59) {
        $AGI->stream_file('privacy-incorrect');
        $AGI->hangup();
        exit;
    }

    my $filename = sprintf("%s/wakeup.%s.%02d%02d.call",
                           $callfiledir,
                           $caller,
                           $hour,
                           $minute);
    if ($set) {
        my ($fh, $tmpfilename) = tempfile(DIR => $tmpdir);
        if (!$fh) { die $!; }
        print $fh "Channel: Local/$caller@"."$originateContext\n";
        print $fh "MaxRetries: 2\nRetryTime: 240\nWaitTime: 60\n";
        print $fh "Application: Playback\n";
        print $fh "Data: $wakeupFile\n";
       # print $fh "Callerid: *55*\n";
        print $fh "Callerid: \"Wakeup service\" <*55*>\n";
# i added the name to caller id number feel free to delete/change it if its broken - LuisManson
        flush $fh;

        my ($sec,$nowMin,$nowHour,$mday,$mon,$year,$wday,$yday) =
            localtime(time);
        if ($hour < $nowHour || $hour == $nowHour && $minute < $nowMin) {
            ($sec,$nowMin,$nowHour,$mday,$mon,$year,$wday,$yday) =
                localtime(time + 24 * 3600);
        }
        my $callTime = timelocal(0,$minute,$hour,$mday,$mon,$year);

        utime $callTime, $callTime, $tmpfilename;
        rename $tmpfilename, $filename;
        close $fh;
    } else {
        unlink $filename;
    }

    $AGI->stream_file($confirmFile);
} else {
    $AGI->stream_file('tt-somethingwrong');
}

$AGI->hangup();

# eof - wakeup-call.pl
