#!/perl -w
# NAME: xmlwrap02.pl
# AIM: Exploring XML::Parser::Wrapper, loading from file ...
# 28/07/2008 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use XML::Parser::Wrapper;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ... exploring XML::Parser::Wrapper\n" );
prt( "from: http://search.cpan.org/~dowens/XML-Parser-Wrapper-0.08/lib/XML/Parser/Wrapper.pm\n" );

my $parser = XML::Parser::Wrapper->new;
my $root3 = $parser->parse({ file => 'books.xml' });
my ($tag, $type, $element, $childs, $isele, $ne);
my $root_tag_name = $root3->name;
my $roots_children = $root3->elements;
prt( "root tag name = $root_tag_name ...\n" );
my $xcnt = 0;
foreach $element (@$roots_children) {
    $xcnt++;
    $isele = 0;
    if ($element->is_text()) {
        $tag = trim_all($element->text());
        $type = 'TEXT';
    } else {
        $tag = $element->name();
        $type = 'element name';
        $isele = 1;
    }
    if (length($tag)) {
        prt( "$xcnt: $type = $tag\n" );
    } else {
        prt( "$xcnt: $type = <all spacey>\n" );
    }
    if ($isele) {
        $childs = $element->elements();
        foreach $ne (@$childs) {
            if (! $ne->is_text()) {
                prt( " sub ".$ne->name()."\n" );
                process_element($ne);
            }
        }
    }
}

close_log($outfile,1);
exit(0);

sub process_element {
    my ($ele) = shift;
    my $ch = $ele->elements();
    foreach my $itm (@$ch) {
        if ($itm->is_text()) {
            prt( "   Txt ".$itm->text()."\n" );
        } else {
            prt( "   Sub ".$itm->name()."\n" );
        }
    }
}

# eof
