# GeoCoord.pm
# Geo coordinates class
# 30/09/2011 geoff mclane http://geoffair.net/mperl
package GeoCoord;

use strict;
use warnings;
use Carp;

require 'fg_wsg84.pl' or die "ERROR: Unable to load 'fg_wsg84.pl'!\n";

our ($VERSION);
$VERSION = "0.1";

sub new {
    my $class = shift;
    my $self = {};
    $self->{LAT} = undef;   # degrees
    $self->{LON} = undef;   # degrees
    $self->{ALT} = undef;   # feet
    $self->{x} = undef;
    $self->{y} = undef;
    $self->{z} = undef;
    $self->{pdirty} = 1;    # polar - deg,deg,feet
    $self->{cdirty} = 1;    # cartesian

    bless ($self, $class);

    return $self;
}

sub lon {
    my $self = shift;
    if (@_) { 
        $self->{LON} = shift;
        $self->{cdirty} = 1;
        print "Set LON = ".$self->{LON}."\n";
    }
    return $self->{LON};
}

sub lat {
    my $self = shift;
    if (@_) { 
        $self->{LAT} = shift;
        $self->{cdirty} = 1;
        print "Set LAT = ".$self->{LAT}."\n";
    }
    return $self->{LAT};
}

sub alt {
    my $self = shift;
    if (@_) { 
        $self->{ALT} = shift;
        $self->{cdirty} = 1;
        print "Set ALT = ".$self->{ALT}."\n";
    }
    return $self->{ALT};
}

sub cupdate {
    my $self = shift;
    if ( $self->{cdirty} ) {
        my @geod = ( $self->{LAT}, $self->{LON}, $self->{ALT} );
        my @cart = ( 0, 0, 0 );
        SGGeod_DEG_FT_ToCart(\@geod,\@cart);
        $self->{x} = $cart[0];
        $self->{y} = $cart[1];
        $self->{z} = $cart[2];
        $self->{cdirty} = 0;
    } else {
        print "NOT cdirty ". $self->{cdirty} . "\n";
    }
}

sub get_x {
    my $self = shift;
    cupdate();
    return $self->{x};
}

sub get_y {
    my $self = shift;
    cupdate();
    return $self->{y};
}

sub get_z {
    my $self = shift;
    cupdate();
    return $self->{z};
}


1; # for require or use to succeed
# eof - GeoCoord.pm
