#File Tree.pm, module for class Tree
#The "package Tree" syntax declares it as a package (class)
package Tree;
#The constructor is always called new(). It can take as many args
#as required.
sub new     {
	#Arg0 is the type because the constructor will look like     
	#  my($instance) = Tree->new(arg1,arg2,whatever)     
	#so arg0 will be Tree.     
	my($type) = $_[0];     
	#Make subroutine-local var $self, and make it a reference.     
	#Specifically, make it a reference to a (right now) empty hash.     
	#Later on, that hash will contain object properties.     
	my($self) = {};     
	#For now, we'll have one instance variable (property, whatever)     
	#It will be in the hash referenced by $self, and will have     
	#the index 'root'. This will be the first arg (inside the parentheses)     
	#of the call to the constructor in the main program.     
	$self->{'root'} = $_[1];    
	#remember $_[0] was the Tree before the ->     
	#There's nothing reserved about the word $self. It could have been     
	#called $oodolaboodola. To link the object with both the hash pointed     
	#to by $self and the type (Tree), we use the 2 argument version     
	#of the keyword bless:     
	bless($self, $type);     
	#Now finally, return the hash as a reference to be used as an "object"
	return($self);
}
#Now make diagnostic routine tellroot to make sure everything's OK.
sub tellroot     {     
	#first "find yourself". Once again, there's nothing reserved     
	#about the word $self. We simply assume that whoever called tellroot     
	#was smart enough to call it like $myinstance->tellroot().     
	my($self)=$_[0];     
	#Now that we have $self, we can get the root from the hash after     
	#dereferencing.     
	print "Root is $self->{'root'}.\n";
}

return(1);
#package files must always return 1.
