#!/Perl
#
# from : http://www.foo.be/docs/tpj/issues/vol3_2/tpj0302-0008.html
use Win32::ODBC;
use Win32::OLE;
# Include the constants for the Microsoft Access
# "Data Access Object".
use Win32::OLE::Const 'Microsoft DAO';

my $DSN      = 'T-Bonds';
my $Driver   = 'Microsoft Access Driver (*.mdb)';
my $Desc     = 'US T-Bond Quotes';
my $Dir      = 'c:\tmp\tpj';
my $File     = 'T-Bonds.mdb';
my $Fullname = "$Dir\\$File";

# Remove old database and dataset name
unlink $Fullname if -f $Fullname;

Win32::ODBC::ConfigDSN(ODBC_REMOVE_DSN, $Driver, "DSN=$DSN")
                       if Win32::ODBC::DataSources($DSN);

# Create new database
my $Access = Win32::OLE->new('Access.Application', 'Quit');
my $Workspace = $Access->DBEngine->CreateWorkspace('','Admin', '');
my $Database = $Workspace->CreateDatabase($Fullname, dbLangGeneral);

# Add new database name
Win32::ODBC::ConfigDSN(ODBC_ADD_DSN, $Driver,
        "DSN=$DSN", "Description=$Desc", "DBQ=$Fullname",
        "DEFAULTDIR=$Dir", "UID=", "PWD=");



# eof - autoaccess01.pl
