#!/usr/bin/perl -w
#< file: btgvers.pl
use strict;
use warnings;
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
sub prt($) {
    print shift;
}
sub show_help() {
    prt("$pgmname: version 0.0.1 2011-11-19\n");
    prt("Usage:\n");
    prt(" $pgmname single_in_file, or\n");
    prt(" $pgmname \"*.btg.gz\", to do 'glob' list.\n");
}
sub show_header($) {
    my $file = shift;
    my ($data,$n,$i,$hex,$hexstg,$ascii,$c,$num,$vers);
    open IF, "gzip -d -c $file|" or 
    die "ERROR: CAN NOT OPEN $file...$!...\n";
    binmode IF;
    if ($n = read IF, $data, 4) {
        prt("File: $file. Read $n byte header: ");
        $hexstg = '';
        $ascii = '';
        for ($i = 0; $i < $n; $i++) {
            $c = substr($data,$i,1);
            $num = ord($c);
            $hex = sprintf("%02X ",$num);
            $hexstg .= $hex;
            if (($c lt ' ')||($c gt '~')) {
                $c = '.';
            }
            $ascii .= $c;
            $vers = $num if ($i == 0);
        }
        prt("Hex $hexstg $ascii Version $vers\n");
    }
    close IF;
}
if (@ARGV) {
    my $file = $ARGV[0];
    if ($file =~ /^-/) {
        show_help();
        exit 0;
    } elsif ($file =~ /(\*|\?)/) {
        my @arr = glob $file; # assum wild card
        my $cnt = scalar @arr;
        prt("Got $cnt files from input [$file]...\n");
        foreach $file (@arr) {
            show_header($file);
        }
    } else {
        show_header($file); # assume file name
    }
} else {
    prt("Enter name of BTG file to check!\n");
    exit 1;
}
exit 0;
# eof - btgvers.pl
