#!/usr/bin/perl -w
# NAME: chk4incs.pl
# AIM: Given a C/C++ files, check for #include <inc.h> or "inc.h" etc, and follow that list
# 07/05/2012 - Initial cut
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
require 'lib_incs.pl'  or die "Unable to load 'lib_incs.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2012-01-06";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $debug_on = 1;
my $def_file1 = 'C:\Projects\newmat11\test_exc.cpp';
my $def_file2 = 'C:\Projects\newmat11\example.cpp';
my $def_file3 = 'C:\Projects\newmat11\garch.cpp';
my @def_files = qw( nl_ex.cpp nm_ex1.cpp nm_ex2.cpp sl_ex.cpp nm_ex3.cpp tmt.cpp );
my $out_xml = '';

### program variables
my @warnings = ();
my $cwd = cwd();
my @in_files = ();
my %dupes = ();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub trim_include($) {
    my $file = shift;
    $file = substr($file,1,length($file)-2) if ($file =~ /^\".+\"$/);
    $file = substr($file,1,length($file)-2) if ($file =~ /^<.+>$/);
    return $file;
}

sub process_in_file($) {
    my ($inf) = @_;
    my @arr = ();
    if (get_include_file_list_ra($inf,\@arr)) {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my ($name,$dir) = fileparse($inf);
    my ($file,$ff,$cnt,$msg);
    $cnt = 0;
    foreach $file (@arr) {
        $file = trim_include($file);
        if (!defined $dupes{$file}) {
            $dupes{$file} = 1;
            $cnt++;
            $ff = $dir.$file;
            $msg = "$cnt: $file";
            if (-f $ff) {
                my @a = ();
                if (!get_include_file_list_ra($inf,\@a)) {
                    foreach $file (@a) {
                        $file = trim_include($file);
                        if (!defined $dupes{$file}) {
                            $dupes{$file} = 1;
                            $msg .= " $file";
                            $ff = $dir.$file;
                            if (-f $ff) {
                                my @a2 = ();
                                if (!get_include_file_list_ra($inf,\@a2)) {
                                    foreach $file (@a2) {
                                        $file = trim_include($file);
                                        if (!defined $dupes{$file}) {
                                            $dupes{$file} = 1;
                                            $msg .= " $file";
                                            $ff = $dir.$file;
                                            if (-f $ff) {
                                                my @a3 = ();
                                                if (!get_include_file_list_ra($inf,\@a3)) {
                                                    foreach $file (@a3) {
                                                        $file = trim_include($file);
                                                        if (!defined $dupes{$file}) {
                                                            $dupes{$file} = 1;
                                                            $msg .= " $file";
                                                            $ff = $dir.$file;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            prt("$msg\n");
        }
    }
}

sub process_in_files() {
    my ($file);
    foreach $file (@in_files) {
        process_in_file($file);
    }
}


#########################################
### MAIN ###
parse_args(@ARGV);
process_in_files();
pgm_exit(0,"");
########################################
sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                $load_log = 1;
                prt("Set to load log at end.\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_xml = $sarg;
                prt("Set out file to [$out_xml].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            if (-f $in_file) {
                push(@in_files,$in_file);
                prt("Added input [$in_file]\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Input file [$in_file] does NOT exist!");
            }
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file1;
        push(@in_files,$def_file1);
        push(@in_files,$def_file2);
        push(@in_files,$def_file3);
        my ($n,$d) = fileparse($def_file1);
        my ($ff);
        foreach $n (@def_files) {
            $ff = $d.$n;
            push(@in_files,$ff);
        }
        prt("Set DEFAULT input to [$in_file]\n");
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

# eof - template.pl
