#!/perl -w
# NAME: chkdbgflag.pl
# AIM: VERY SPECIFIC - Check for ($dbg & (\d+))
# 02/08/2010 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[.]*/] )
use Cwd;
unshift(@INC, 'C:\GTools\perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:\GTools\perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 1;
my $in_file = '';
my $ignore_comments = 1;

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub strip_comment($) {
    my ($txt) = @_;
    my $len = length($txt);
    my ($i,$ch,$inquote,$qc);
    my $ntxt = '';
    $inquote = 0;
    for ($i = 0; $i < $len; $i++) {
        $ch = substr($txt,$i,1);
        if ($inquote) {
            $inquote = 0 if ($ch eq $qc);
        } else {
            if (($ch eq '"') || ($ch eq "'")) {
                $qc = $ch;
                $inquote = 1;
            }
        }
        if (!$inquote && ($ch eq '#')) {
            return $ntxt;
        }
        $ntxt .= $ch;
    }
    return $ntxt;
}

sub process_file($) {
    my ($fil) = @_;
    if (! open INF, "<$fil") {
        pgm_exit(1,"ERROR: Unable to open [$fil]!\n");
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Got $lncnt lines, from [$fil], to process...\n");
    my ($line,$num);
    my %numbs = ();
    foreach $line (@lines) {
        $line = trim_all($line);
        if ($ignore_comments) {
            next if ($line =~ /^\s*#/);
            $line = strip_comment($line);
        }
        if ($line =~ /\(\s*\$dbg\s+\&\s+(\d+|[A-F]+|x)+\s*\)/i) {
            $num = $1;
            prt("$line [$num]\n");
            if (defined $numbs{$num}) {
                $numbs{$num}++;
            } else {
                $numbs{$num} = 1;
            }
        }
    }
    foreach my $key (keys %numbs) {
        $num = $numbs{$key};
        prt( "$key ($num)\n" );
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
#prt( "$pgmname: in [$cwd]: Hello, World...\n" );
process_file($in_file);
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-05-05\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have follwoing argument!\n")
        if (!@av);
}
sub parse_args {
    my (@av) = @_;
    while (@av) {
        my $arg = $av[0];
        if ($arg =~ /-/) {
            my $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /-/);
            if (($sarg =~ /h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }
    if ((length($in_file) == 0) || ( ! -f $in_file )) {
        pgm_exit(1,"ERROR: No input, or input file NOT found! [$in_file]\n");
    }
}

# eof - template.pl
