#!/perl -w
# NAME: cmpdirs.pl
# AIM: A simple COMPARE of the files in one directory, with those in another
# 01/11/2008 - geoff mclane - http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;
unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
###require 'fgutils.pl' or die "Unable to load fgutils.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

# OPTIONS
my $recurse = 1;
my $ignoreCVS = 1;
my $exclude_ext = 1;

my @excluded_exts = qw( .old .bak .obj .err .pdb .lst .pch .ilk .NCB .plg .OPT .idb 
.aps .sbr .suo .user .res .dep .exp .manifest .htm .lib .dll .exe .dsp );

my $in_dir1 = 'C:\FGCVS\lpng1232\lpng1232';
my $in_dir2 = 'C:\FG\20\lpng';
#my $in_dir1 = 'C:\FGCVS\FlightGear\data';
#my $in_dir2 = 'C:\FG\20\data';
my @warnings = ();

prt( "$0 ... Hello, comparing [$in_dir1] with [$in_dir2] ...\n" );

my @dir1 = load_directory($in_dir1);
my $dcnt1 = scalar @dir1;
prt( "Loaded $dcnt1 from $in_dir1 ...\n" );
my @dir2 = load_directory($in_dir2);
my $dcnt2 = scalar @dir2;
prt( "Loaded $dcnt2 from $in_dir2 ...\n" );
compare_entries( $in_dir1, \@dir1, $in_dir2, \@dir2 );

show_warnings();

close_log($outfile,1);
exit(0);

#######################################
### SUBS ONLY

## compare_entries( $in_dir1, \@dir1, $in_dir2, \@dir2 );
sub compare_entries {
    my ( $dir1, $d1r, $dir2, $d2r ) = @_;
    my ($cnt1, $cnt2, $i, $j, $ent1, $ent2, $fnd, $msg);
    my $len1 = length($dir1) + 1;
    my $len2 = length($dir2) + 1;
    my @miss1 = ();
    my @miss2 = ();
    $cnt1 = scalar @{$d1r};
    $cnt2 = scalar @{$d2r};
    prt( "Comparing $dir1($cnt1)$len1 with $dir2($cnt2)$len2 entries ...\n" );
    for ($i = 0; $i < $cnt1; $i++) {
        $ent1 = $$d1r[$i];
        $msg = $ent1;
        $ent1 = substr($ent1,$len1);
        $msg .= " to [$ent1] ... ";
        ##prt($msg);
        $fnd = 0;
        for ($j = 0; $j < $cnt2; $j++) {
            $ent2 = substr($$d2r[$j],$len2);
            if ($ent1 eq $ent2) {
                $fnd = 1;
                last;
            }
        }
        if (!$fnd) {
            prt( "$ent1 NOT found in directory 2 ...\n" );
            push(@miss1,$ent1);
        } else {
            ##prt(" found\n" );
        }
    }
    for ($i = 0; $i < $cnt2; $i++) {
        $ent1 = substr($$d2r[$i],$len2);
        $fnd = 0;
        for ($j = 0; $j < $cnt1; $j++) {
            $ent2 = substr($$d1r[$j],$len1);
            if ($ent1 eq $ent2) {
                $fnd = 1;
                last;
            }
        }
        if (!$fnd) {
            prt( "$ent1 NOT found in directory 1 ...\n" );
            push(@miss2,$ent1);
        }
    }
    if (@miss1 || @miss2) {
        # we have some differences, already shown
        $len1 = scalar @miss1;
        $len2 = scalar @miss2;
        prt( "$dir1 NOT the same content as $dir2 ... $len1 in 1 not in 2, and $len2 in 2 not in 1\n" );
    } else {
        if ($exclude_ext) {
            $len1 = scalar @excluded_exts;
            prt( "$dir1 is perhaps same content as $dir2 ... except $len1 extensions excluded.\n" );
        } else {
            prt( "$dir1 is the same content as $dir2 ...\n" );
        }
    }

}

sub load_directory {
    my ($dir) = shift;
    my ($fil, $ff, $nm, $dr, $ex);
    my @files = ();
    my @dirs = ();
	if ( opendir( DIR, $dir ) ) {
		my @fils = readdir(DIR);
		closedir DIR;
        foreach $fil (@fils) {
            next if (($fil eq '.')||($fil eq '..'));
            $ff = $dir."\\".$fil;
            if (-d $ff) {
                if (($fil =~ /^CVS$/i)||($fil =~ /^\.svn$/i)) {
                    push(@dirs,$ff) if (!$ignoreCVS);
                } else {
                    push(@dirs,$ff);
                }
            } else {
                if ($exclude_ext) {
                    ($nm, $dr, $ex) = fileparse( $fil, qr/\.[^.]*/ );
                    if (!is_in_array_nc($ex, @excluded_exts)) {
                        push(@files,$ff);
                    }
                } else {
                    push(@files,$ff);
                }
            }
        }
        if ($recurse) {
            foreach $fil (@dirs) {
                push(@files,load_directory($fil));
            }

        }
    } else {
        prtw( "WARNING: Failed to OPEN directory [$dir] ...\n" );
    }
    return @files;
}

sub is_in_array_nc {
	my ($itm, @arr) = @_;
    $itm = lc($itm);
	foreach my $val (@arr) {
        $val = lc($val);
		if ($val eq $itm) {
			return 1;
		}
	}
	return 0;
}

sub prtw {
    my ($tx) = shift;
    if ($tx =~ /\n$/) {
        prt($tx);
        $tx =~ s/\n$//;
    } else {
        prt("$tx\n");
    }
    push(@warnings,$tx);
}

sub show_warnings {
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS ...\n" );
        foreach my $line (@warnings) {
            prt("$line\n" );
        }
        prt("\n");
    } else {
        prt("\nNo warnings issued.\n\n");
    }
}


# eof - cmpdirs.pl
