#!/perl -w
# NAME: cmpvc8todsp.pl
# AIM: Load a VC8 project file (.VCPROJ), and compare it with a VC6 DSP (.DSP) file,
# and SHOW different sources ...
use strict;
use warnings;
use File::Basename;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
### prt( "$0 ... Hello, World ...\n" );

# features
my $skip_dupes = 1;	# skip duplicates
my $try_harder = 0;	# compare ONLY file title and externsion
my $killfilt = 1;	# this should be ON always

# debug VC8
my $dbg11 = 0;		# show EACH VC8 source pushed into %v8_srcs
my $dbg_src1 = 0;
my $dbg_src2 = 0;
my $dbg_src3 = 0;
my $dbg_src4 = 0;	# show Filter
my $dbg_src5 = 1;	# show lines NOT in tumble, or excepted ... THERE SHOULD BE NONE!
my $dbg_src6 = 0;	# show v8 configuration found
my $dbg_src7 = 0;	# show each <Tool Name="????" ...
my $dbg_src8 = 1;	# show compiler tool and definitions added $v8_link{$conf} = $1;
my $dbg_src9 = 0;	# show each TAG, and TYPE
my $dbg_srcv = 0;	# show XML version line
my $dbg_srcc = 0;	# show CLOSE tags
my $dbg_src10 = 0;	# show BEGIN and END Configurations
my $dbg_src11 = 0;	# show project name, and vcproj version ...

# debug DSP
my $dbg_ds9 = 0;	# show EACH VC6 source pushed
my $dbg_dsp = 0;
my $dbg_ds1 = 0;
my $dbg_ds2 = 0;
my $dbg_ds3 = 0;
my $dbg_ds4 = 0;	# show CPP and LINK config items - %v6_conf
my $dbg_ds5 = 0;	# show Defined items - %v6_defs
my $dbg_ds6 = 0;	# show !IF, !ELSEIF switching
my $dbg_ds7 = 0;	# show %v6_conf listing
my $dbg_ds8 = 0;	# show VC6 Filter and Group Name
my $dbg_dsp10 = 0;	# prt( "SOURCE = $src ($ff)... $ins \n" )

# debug compare
my $big_dbg = 0;	# prt( "$i1 $nm1 - " )
my $big_dbg2 = 0;	# prt( "$ff1 SAME AS $ff2 " )
my $big_dbg3 = 0;	# prt( "$nm2 " )
my $big_dbg4 = 0;	# prt( "$xnm1 eq $xnm2 and $xext1 eq $xext2 ($ff1 - $ff2)" )

my @v8_srcs = ();
my %v8_link = ();	# compiler definitions, by configuration
my %v8_depend = ();	# linker addtional dependencies, by configuration
my %v8_apptyp = ();	# application TYPE, per project name
my %v8_defines = ( '_CONSOLE' => 'Console Application',
 '_USRDLL' => 'Dynamic-Link Library',
 '_LIB' => 'Static Library' );
 my $typelse = 'Application';

my $TYP_OPEN = 1;
my $TYP_CLOSE = 2;
my $TYP_OPENCLOSE = 3;
my $TYP_VERSION = 4;

my $v8_cfgexp = '<Configuration\\s+.*Name=\\"(\\S+)\\"\\s';
my $v8_toolexp = '<Tool\\s+.?\\s*Name=\\"(\\S+)\\"\\s';
my $v8_prepexp = '\\s+PreprocessorDefinitions=\\"(\\S+)\\"';

my @v6_srcs = ();  # relnm full group filter
my %v6_defs = ();
my %v6_conf = ();
my @extra_projects = ();

# grep
my $test_key = 'greputils';
my $test_dir = 'C:\Projects\Grep\build';
my @test_set = qw( greputils );

# xmlrpccpp
#my $test_key = 'testmem';
#my $test_dir = 'C:\GTools\Tools\testmem';
#my @test_set = qw( crt_dbg1 memtestDLL memtestStatic testmem );

##my $test_key = 'xmlrpccpp';
##my $test_in_vc8 = 'C:\FG\FGCOMXML\xmlrpc-c\Windows\xmlrpccpp.vcproj';
##my $test_in_dsp = 'C:\FG\FGCOMXML\xmlrpc-c\Windows\xmlrpccpp.dsp';

#my $test_key = 'rpctest';
#my $test_in_vc8 = 'C:\FG\FGCOMXML\xmlrpc-c\Windows\rpctest.vcproj';
#my $test_in_dsp = 'C:\FG\FGCOMXML\xmlrpc-c\Windows\rpctest.dsp';
my $compres = 0;

my %dsw_projects = ();
my @warnings = ();

foreach my $fil (@test_set) {
	my $ffvc = $test_dir."\\".$fil.'.vcproj';
	my $ffdsp = $test_dir."\\".$fil.'.dsp';
	if ((-f $ffvc)&&(-f $ffdsp)) {
		get_xml_sources($ffvc);
		process_DSP( $test_key, $ffdsp );
		$compres += compare_proj_with_dsp( $test_key );
	} else {
		prt( "WARNING: $ffvc or $ffdsp DOES NOT EXIST!\n" );
	}
}

#get_xml_sources($test_in_vc8);
#process_DSP( $test_key, $test_in_dsp );
#$compres += compare_proj_with_dsp( $test_key );

show_warnings();
close_log($outfile,1);
exit(0);

sub process_DSP {
	my ($proj, $fil) = @_;
	my ($line, $prjname, $grpname, $filter, $ff, $src, $chr, $tmp, $conf, $ffnr);
	my ($itm1, $itm2, $key, $targtype);
	my $scnt = 0;
	my @dsp_lines = ();
	prt( "\nProcess DSP file $fil ... " );
	if ( -f $fil ) {
		prt( "already exists ...\n" );
		my ($name,$dir,$suffix) = fileparse($fil);
		if ( open IF, "<$fil" ) {
			@dsp_lines = <IF>;
			close IF;
			prt( "Got ".scalar @dsp_lines." lines to process ...\n" );
			my $ins = 0;
			foreach $line (@dsp_lines) {
				$line = trim_all($line);
				$chr = substr($line, 0, 1);	# get FIRST char of LINE
				if( $chr eq '#' ) {
					# line begins with SHARP
					if ($line =~ /\s+Microsoft Developer Studio Project File - Name=\"([\.\w\s]+)+/) {
						$prjname = $1;
						prt( "Project NAME = $prjname ...\n" ) if ($dbg_dsp);
					} elsif ($line =~ /\s+Microsoft Developer Studio Generated Build File, Format Version ([\d\.]+)/) {
						prt( "MSVC Version $1 ...\n" ) if ($dbg_dsp);
					} elsif ($line =~ /\s*TARGTYPE\s+\"(.+)\"\s+/) { # Win32 (x86) Console Application" 0x0103
						$targtype = $1;
						prt( "TARGTYPE: $targtype, name=$prjname ($proj)\n" );
					} elsif ($line =~ /Begin Group \"([\s\w]+)+/ ) {
						$grpname = $1;
						prt( "Begin group ... $grpname\n" ) if ($dbg_dsp);
					} elsif ($line =~ /PROP\s+Default_Filter\s+\"([\w;]+)+\"/ ) {
						$filter = $1;
						prt( "Begin Filter group $grpname, filter $filter\n" ) if ($dbg_ds8);
					} elsif ($line =~ /Begin Source File/) {
						$ins = 1;
						prt( "Begin source ... $ins ...\n" ) if ($dbg_dsp);
					} elsif ($line =~ /End Source File/) {
						$ins = 0;
						prt( "End source ... $ins ...\n" ) if ($dbg_dsp);
					} elsif ( $line =~ /ADD BASE CPP (.+)/ )  {
						# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" /Yu"stdafx.h" /FD /c
						$key = 'CPP '.$conf;
						prt( "ADD BASE $key [$1]\n" ) if ($dbg_ds4);
						$v6_conf{$key} = $1;
					} elsif ( $line =~ /ADD CPP (.+)/ )  {
						# ADD CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" /FD /c
						$key = 'CPP '.$conf;
						prt( "ADD $key [$1]\n" ) if ($dbg_ds4);
						$v6_conf{$key} = $1;
					} elsif ( $line =~ /ADD BASE LINK32 (.+)/ )  {
						# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:windows /machine:I386
						$key = 'LINK '.$conf;
						prt( "ADD BASE $key [$1]\n" ) if ($dbg_ds4);
						$v6_conf{$key} = $1;
					} elsif ( $line =~ /ADD LINK32 (.+)/ )  {
						$key = 'LINK '.$conf;
						# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:windows /machine:I386
						prt( "ADD $key [$1]\n" ) if ($dbg_ds4);
						$v6_conf{$key} = $1;
					}
				} elsif ( $chr eq '!' ) {
					if ($line =~ /^!IF\s+(.+)/i ) {
						prt( "Entering IF $1 ...\n" ) if ($dbg_ds6);
						if ($line =~ /!IF\s+(.+) == (.+)/i) {
							$itm1 = $1;
							$itm2 = $2;
							$itm1 =~ s/\"//g;
							$itm2 =~ s/\"//g;
							prt( "Got [$itm1] [$itm2]...\n" ) if ($dbg_ds6);
							if ($itm1 =~ /^\$\((.+)\)/ ) {
								if (defined $v6_defs{$1}) {
									if ($v6_defs{$1} eq $itm2) {
										$tmp = "TRUE";
									} else {
										$tmp = "FALSE";
									}
									if( $1 eq 'CFG' ) {
										$conf = $itm2;
									}
									prt( "and [$1] defined as \"$v6_defs{$1}\" ... $tmp $conf\n" ) if ($dbg_ds6);
								} else {
									prt( "NOT DEFINED [$1] ...\n" );
								}
							}
						} else {
							prt( "FAILED IF == [$line]\n" );
						}
					} elsif ( $line =~ /^!ELSE\s+/i ) {
						prt( "Entering ELSE ...\n" ) if ($dbg_ds6);
					} elsif ( $line =~ /^!ELSEIF\s+(.+)/i ) {
						prt( "Entering ELSEIF $1 ...\n" ) if ($dbg_ds6);
						if ($line =~ /!ELSEIF\s+(.+) == (.+)/i) {
							$itm1 = $1;
							$itm2 = $2;
							$itm1 =~ s/\"//g;
							$itm2 =~ s/\"//g;
							prt( "Got [$itm1] [$itm2]...\n" ) if ($dbg_ds6);
							if ($itm1 =~ /^\$\((.+)\)/ ) {
								if (defined $v6_defs{$1}) {
									if ($v6_defs{$1} eq $itm2) {
										$tmp = "TRUE";
									} else {
										$tmp = "FALSE";
									}
									if( $1 eq 'CFG' ) {
										$conf = $itm2;
									}
									prt( "and [$1] defined as \"$v6_defs{$1}\" ... $tmp $conf\n" ) if ($dbg_ds6);
								} else {
									prt( "NOT DEFINED [$1] ...\n" );
								}
							}
						} else {
							prt( "FAILED ELSEIF == [$line]\n" );
						}
					} elsif ( $line =~ /^!ENDIF\s*/i ) {
						prt( "Out ENDIF ...\n" ) if ($dbg_ds6);
					}
				} else {
					### if ($line =~ /SOURCE=([\.\\\w-]+)/ ) {
					if ($line =~ /SOURCE=([\.\\\w-"]+)/ ) {
						$src = $1;
						$src =~ s/"//g;
						$ff = $dir.$src;
						$ffnr = fix_rel_path($ff);
						if ($ins) {
							prt( "SOURCE = $src ($ff)... $ins \n" ) if ($dbg_dsp || $dbg_dsp10);
						} else {
							prt( "source = $src ($ff) OUTSIDE 'in source' ... $ins\n" );
						}
						if (is_c_source($src)) {
							prt("SOURCE=[$src]\n") if ($dbg_ds1);
						} elsif (is_h_source($src)) {
							prt("HEADER=[$src]\n") if ($dbg_ds2);
						} elsif (is_h_special($src)) {
							prt("HEADER=[$src]\n") if ($dbg_ds2);
						} else {
							prt("OTHER=[$src]\n") if ($dbg_ds3);
						}
						#                0     1      2          3          4  5  6
						#push(@v8_srcs, [$src, $ffnr, $filtname, $filttype, 0, 0, $projname] );
						push(@v6_srcs, [$src, $ffnr, $grpname, $filter, 0, 0, $proj] );
						$scnt++;
						prt( "$scnt v6_srcs: $src, $ffnr, $grpname, $filter, 0, 0, $proj\n" ) if ($dbg_ds9);
					} elsif ( $line =~ /(.*)=(.*)/ ) {
						$itm1 = $1;
						$itm2 = $2;
						$v6_defs{$itm1} = $itm2;
						prt( "Defined [$itm1] = [$itm2] ...\n" ) if ($dbg_ds5);
					}
				}
			}
			prt( "End DSP - got $scnt source files ...\n" );
			if ($dbg_ds7) {
				foreach $key (keys %v6_conf) {
					prt( "Config $key = [$v6_conf{$key}]\n" );
				}
			}
		} else {
			prt( "ERROR: FAILED TO OPEN $fil FILE!\n" );
		}
	} else {
		prt( "*** DOES NOT EXIST ***\n" );
	}
}

sub get_xml_tag {
	my ($lin) = shift;
	my $len = length($lin);
	my $tag = '';
	my $pch = '';
	for (my $t = 0; $t < $len; $t++) {
		my $ch = substr($lin,$t,1);
		if ($ch eq '<') {
			prt( "WARNING: Second TAG in line! ($lin)\n" ) if (length($tag));
			$tag = '';
			$t++;
			for ( ; $t < $len; $t++) {
				$ch = substr($lin,$t,1);
				if ($ch =~ /\s/) {
					# end of tag
					$t++;
					for ( ; $t < $len; $t++) {
						$ch = substr($lin,$t,1);
						if ($ch eq '>') {
							$tag .= $pch if ($pch eq '/');
							prt( "WARNING: Premature CLOSE! ($lin)(1)\n" ) if (($t +1) < $len);
							last;	# end of TAG
						}
						$pch = $ch;	# keep last
					}
					last;
				} elsif ($ch eq '>') {
					prt( "WARNING: Premature CLOSE! ($lin)(2)\n" ) if (($t +1) < $len);
					last;
				}
				$tag .= $ch;
			}
		}
	}
	return $tag;
}

sub tag_typ_2_stg {
	my ($typ) = shift;
	if ($typ == $TYP_OPEN) {
		return "OPEN";
	} elsif ($typ == $TYP_CLOSE) {
		return "CLOSE";
	} elsif ($typ == $TYP_OPENCLOSE) {
		return "OPENCLOSE";
	} elsif ($typ == $TYP_VERSION) {
		return "VERSION";
	}
	return "UNKNOWN";
}

sub get_tag_typ {
	my ($xt) = shift;
	my $typ = $TYP_OPEN;
	if ($xt =~ /^\//) {
		$typ = $TYP_CLOSE;
	} elsif ($xt =~ /\/$/) {
		$typ = $TYP_OPENCLOSE;
	} elsif ($xt eq '?xml') {
		$typ = $TYP_VERSION;
	}
	###prt( "For [$xt] returning [$typ] ...\n" );
	return $typ;
}

sub get_app_type {
	my ($defs) = shift;
	my @arr = split(';',$defs);
	foreach my $def (@arr) {
		foreach my $key (keys %v8_defines) {
			if ($def eq $key) {
				return $v8_defines{$key};
			}
		}
	}
	return $typelse;
}

# get_xml_source
# process the XML project file (*.vcproj) and
# extract the SOURCE file list
sub get_xml_sources {
	my ($in) = shift;
	##my $in_fd = file_dirname($in);
	my ($name,$in_fd,$suffix) = fileparse($in);
	my ($src, $ff, $pline);
	my $stf = '<File\\s+RelativePath=\\"([\\.\\\\\\w-]+)+\\"+(.)+';
	#my $filt = '^<Filter\\s+Name=\\"([\\w\\s]+)\\"\\s+Filter=\\"([\\w;]+)\\"';
	my @lines = ();
	my $line = '';
	my $filtname = '';
	my $filttype = '';
	my $conf = '';
	my $tname = '';
	my $version = '';
	my $projname = '';
	my $srccount = 0;
	my @xmltags = ();
	my $xmltag = '';
	my $tagtyp = 0;
	my $lnnum = 0;
	my $bgn = 0;
	my $end = 0;
	my $ll = 0;
	my $ch = '';
	my $bgnend = '';
	my $inconfigs = 0;
	my $ppdefs = '';
	my $apptype = '';
	prt( "Loading [$in] file in directory [$in_fd] ...\n" );
	open FH, "<$in" or mydie( "ERROR: Can not open [$in] ... aborting ...\n" );
	@lines = <FH>; # slurp the whole file
	close( FH );
	my $fline = '';
	prt( "Processing ".scalar @lines." lines in $in ...\n" );
	my $hadver = 0;
	foreach $line (@lines) {
		$lnnum++;
		$line = trim_all($line);
		$ll = length($line);
		if ($ll) {
			if (length($fline)) {
				$fline .= ' '.$line;
			} else {
				$ch = substr($line,0,1);
				$fline .= $line;
				if ($ch eq '<') {
					$bgn = $lnnum;
				}
			}
		} else {
			next;
		}
		if ($fline =~ />/) {
			$bgnend = "$bgn-$lnnum";
			$bgn = -1;
			$xmltag = get_xml_tag($fline);
			$tagtyp = get_tag_typ($xmltag);
			prt( "$bgnend: $xmltag ".tag_typ_2_stg($tagtyp). " ($tagtyp)\n" ) if ($dbg_src9);
			if ($fline =~ /<VisualStudioProject\s+/) {
				if ($fline =~ /.+Version="(\d+\.{1}\d+)+".+/ ) {
					$version = $1;
				}
				if ($fline =~ /.+Name="(\w+)".+/) {
					$projname = $1;
				}
				##prt( "$fline\n" );
				prt( "Project=$projname, v=$version\n" ) if ($dbg_src11);
			} elsif ($fline =~ /$stf/) {
				# <File RelativePath="src\FDM\SP\ACMS.cxx" >
				$src = $1;
				$ff = $in_fd . $src;
				my $ffnr = fix_rel_path($ff);
				if (is_c_source($src)) {
					prt("SOURCE=[$src]\n") if ($dbg_src1);
					#push(@csrc_array, [$src, $ff, $filtname, $filttype, 0] );
				} elsif (is_h_source($src)) {
					prt("HEADER=[$src]\n") if ($dbg_src2);
					#push(@hsrc_array, [$src, $ff, $filtname, $filttype, 0] );
				} elsif (is_h_special($src)) {
					prt("HEADER=[$src]\n") if ($dbg_src2);
					#push(@hsrc_array, [$src, $ff, $filtname, $filttype, 0] );
				} else {
					prt("OTHER=[$src]\n") if ($dbg_src3);
					#push(@osrc_array, [$src, $ff, $filtname, $filttype, 0] );
				}
				$srccount++;
				#                0    1      2          3          4  5  6
				push(@v8_srcs, [$src, $ffnr, $filtname, $filttype, 0, 0, $projname] );
				prt( "$srccount v8_srcs: $src, $ffnr, $filtname, $filttype, 0, 0, $projname);\n" ) if ($dbg11);

			} elsif ($fline =~ /<Filter\s+(.*)/) {
				# <Filter Name="Source Files" Filter="cpp;c;cxx;rc;def;r;odl;idl;hpj;bat">
				$filtname = ''; # = NO FILTER NAME, like Source Files
				$filttype = ''; # = NOR FILTER TYPE, like cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
				if ($fline =~ /\s+Name=\"([\w\s]+)\"[\s>]+/) {
					$filtname = $1; # = Source Files
				}
				if ($fline =~ /\s+Filter=\"([\w;,]+)\"[\s>]+/) {
					$filttype = $1; # = cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
				}
				prt("FILTNAME=[$filtname] [$filttype]\n") if ($dbg_src4);
			} elsif ($fline =~ /$v8_cfgexp/ ) {
				##if ($fline =~ /<Configuration\s+.*Name=\"(\S+)\"\s/ ) {
				$conf = $1;
				prt( "Got configuration $conf\n" ) if ($dbg_src6);
			} elsif ($fline =~ /<Tool\s+(.*)$/ ) {
				#} elsif ($fline =~ /$v8_toolexp/ ) {
				$pline = $1;
				if ($pline =~ /\s*Name=\"*(\w+)\"*/) {
					$tname = $1;
					prt( "Got Tool name $tname\n" ) if ($dbg_src7);
					if ($tname eq 'VCCLCompilerTool') {
						# <Tool
						# Name="VCCLCompilerTool"
						# Optimization="0"
						# AdditionalIncludeDirectories="../lib,../lib/curl_transport,...
						# PreprocessorDefinitions="_DEBUG;WIN32;_LIB;ABYSS_WIN32;CURL_STATICLIB" 
						# MinimalRebuild="true" 
						# BasicRuntimeChecks="3" 
						# RuntimeLibrary="1" 
						# PrecompiledHeaderFile=".\Debug\xmlrpccpp/xmlrpccpp.pch" 
						# AssemblerListingLocation=".\Debug\xmlrpccpp/" 
						# ObjectFile=".\Debug\xmlrpccpp/" 
						# ProgramDataBaseFileName=".\Debug\xmlrpccpp/" 
						# WarningLevel="3" 
						# SuppressStartupBanner="true" 
						# DebugInformationFormat="4" />]
						prt( "Is compiler tool ...[$fline]\n" ) if ($dbg_src7);
						##if ($fline =~ /\s+PreprocessorDefinitions=\"(\S+)\"/ ) {
						##if ($fline =~ /$v8_prepexp/ ) {
						if ($fline =~ /\s*PreprocessorDefinitions=\"*(\S+)\"/ ) {
							$ppdefs = trim_all($1);
							if ($inconfigs) {
								$apptype = get_app_type($ppdefs);
								prt( "Setting DEFS: $conf [$ppdefs] $apptype\n" ) if ($dbg_src8);
								$v8_link{$conf} = $ppdefs;
								if (defined $v8_apptyp{$projname}) {
									if ($v8_apptyp{$projname} ne $apptype) {
										prt( "WARNING: ALREADY HAVE $projname with ".$v8_apptyp{$projname}." which is NOT $apptype!!!\n" );
									}
								} else {
									$v8_apptyp{$projname} = $apptype;
								}
							} elsif (length($ppdefs)) {
								prt( "Got DEFS: $conf [$1] OUTSIDE COnfigurations!\n" ) if ($dbg_src10);
							}
						}
					} elsif ($tname eq 'VCLinkerTool') {
						prt( "Is linker tool ...[$fline]\n" ) if ($dbg_src7);
						if ($fline =~ /\s+AdditionalDependencies=\"(\S+)\"/ ) {
							$v8_depend{$conf} = $1;
						}
					}
				} else {
					prt( "WARNING: FAILED Name [$fline]\n" );
				}
			} elsif ($fline =~ /<\/Filter>/) {
				if ($killfilt) {
					$filtname = ''; # = NO FILTER NAME, like Source Files
					$filttype = ''; # = NOR FILTER TYPE, like cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
				}
			} elsif ($fline =~ /<Platforms/) {
				# 8-8: LINE=[<Platforms>]
			} elsif ($fline =~ /<Platform/) {
				# 9-11: LINE=[<Platform Name="Win32" />]
			} elsif ($fline =~ /<ToolFiles/) {
				# 13-13: LINE=[<ToolFiles>]
			} elsif ($fline =~ /<Configurations/) {
				# 15-15: LINE=[<Configurations>]
				$inconfigs = 1;
				prt( "Enter Configurations ... ($fline)\n" ) if ($dbg_src10);
			} elsif ($fline =~ /<References/) {
				# 167-167: LINE=[<References>]
			} elsif ($fline =~ /<Files/) {
				# 169-169: LINE=[<Files>]
			} elsif ($fline =~ /<FileConfiguration/) {
				# 177-179: LINE=[<FileConfiguration Name="Debug|Win32" >]
			} elsif ($fline =~ /<Globals/) {
				# 591-591: LINE=[<Globals>]
			} else {
				if ($tagtyp == $TYP_VERSION) {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_srcv);
				} elsif ($tagtyp == $TYP_CLOSE) {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_srcc);
				} else {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_src5);
				}
			}
			if ($tagtyp == $TYP_OPEN) {
				push(@xmltags,$xmltag);
			} elsif ($tagtyp == $TYP_CLOSE) {
				if (@xmltags) {
					my $tmptag = pop @xmltags;
					$xmltag = substr($xmltag,1);
					if ($tmptag ne $xmltag) {
						prt( "WARNING: Closing TAG [$xmltag] not last [$tmptag]! $bgnend\n" );
					}
					if ($xmltag eq 'Configurations') {
						$inconfigs = 0;
						prt( "Exit Configurations ... ($fline)\n" ) if ($dbg_src10);
					}
				} else {
					prt( "WARNING: CLOSE TAG NOT OPEN! [$fline]\n" );
				}
			}
			$fline = '';
		}
	}
	prt( "Project: $projname, as $apptype\n" );
	my $new_srcs = scalar @v8_srcs;
	prt( "Got new $new_srcs C/C++ files, header files, and others \n" );
}

sub mystricmp {
	my ($tx1, $tx2) = @_;
	my $ltx1 = lc($tx1);
	my $ltx2 = lc($tx2);
	if ($ltx1 eq $ltx2) {
		return 1;
	}
	return 0;
}

# the 'main' process - compare vcproj with dsp sources
# ====================================================
sub compare_proj_with_dsp {
	my ($key) = shift;
	my ($i1, $i2, $fnd, $matched);
	##	push(@cv8_srcs, [$src, $ff, $filtname, $filttype, $flag, $projname] );
	my ($src1, $ff1, $fnm1, $typ1, $flg1);
	my ($src2, $ff2, $fnm2, $typ2, $flg2);
	my ($nm1, $pth1);
	my ($nm2, $pth2);
	my ($added, $subed);
	my ($miss1, $miss2, $msg);
	my ($xnm1,$xdir1,$xext1);
	my ($xnm2,$xdir2,$xext2);
	# compare @v8_srcs, with @v6_srcs
	my $v8_tot = scalar @v8_srcs;
	my $v6_tot = scalar @v6_srcs;
	prt( "\nCompare of sources " );
	prt( "MSVC 8 total = $v8_tot, with " ); 
	prt( "MSVC 6 total = $v6_tot\n" );
	$fnd = 0;
	$matched = 0;

	# 1 - clear the compare flag
	for ($i1 = 0; $i1 < $v8_tot; $i1++) {
		$v8_srcs[$i1][4] = 0;
	}
	for ($i2 = 0; $i2 < $v6_tot; $i2++) {
		$v6_srcs[$i2][4] = 0;
	}

	# 2 - extract each vcproj source, and 'find' in dsp
	for ($i1 = 0; $i1 < $v8_tot; $i1++) {
		$src1 = $v8_srcs[$i1][0];
		$ff1  = $v8_srcs[$i1][1];
		$fnm1 = $v8_srcs[$i1][2];
		$typ1 = $v8_srcs[$i1][3];
		$flg1 = $v8_srcs[$i1][4];
		($nm1,$pth1) = fileparse( $src1 );
		($xnm1,$xdir1,$xext1) = fileparse( $src1, qr/\.[^.]*/ );
		prt( "$i1 $nm1 - " ) if ($big_dbg);
		$fnd = 0;
		for ($i2 = 0; $i2 < $v6_tot; $i2++) {
			$src2 = $v6_srcs[$i2][0];
			$ff2  = $v6_srcs[$i2][1];
			$fnm2 = $v6_srcs[$i2][2];
			$typ2 = $v6_srcs[$i2][3];
			$flg2 = $v6_srcs[$i2][4];
			if ($skip_dupes && $flg2) {
				next;
			}
			($nm2,$pth2) = fileparse( $src2 );
			($xnm2,$xdir2,$xext2) = fileparse( $src2, qr/\.[^.]*/ );
			prt( " $nm2 " ) if ($big_dbg3);
			if (is_same_DOS_file($ff1,$ff2)) {
				$fnd = 1;
				prt( "$ff1 SAME AS $ff2 " ) if ($big_dbg2);
			}
			if ( !$fnd && mystricmp( $xnm1, $xnm2 ) && mystricmp( $xext1, $xext2 ) ) {
				if ($try_harder) {
					$fnd = 1;
				}
				prt( "$xnm1 eq $xnm2 and $xext1 eq $xext2 ($ff1 - $ff2)" ) if ($big_dbg4);
			}
			if ($fnd) {
				$v6_srcs[$i2][4] = $i1 + 1;
				$v8_srcs[$i1][4] = $i2 + 1;
				last;
			}
		}
		if ($fnd) {
			prt( " ok\n" ) if ($big_dbg);
			$matched++;
		} else {
			prt( " NO MATCH\n" ) if ($big_dbg);
		}
	}
	$added = $v8_tot - $matched;
	$subed = $v6_tot - $matched;
	$miss1 = 0;
	$miss2 = 0;
	for ($i1 = 0; $i1 < $v8_tot; $i1++) {
		if ($v8_srcs[$i1][4] == 0) {
			$miss1++;
		}
	}
	for ($i2 = 0; $i2 < $v6_tot; $i2++) {
		if ($v6_srcs[$i2][4] == 0) {
			$miss2++;
		}
	}
	prt( "Matched $matched of $v8_tot, with $matched of $v6_tot ...\n" );
	if (($added == 0) && ($subed == 0)) {
		prt( "DSP appears EQUIVALENT to VCPROJ file - no DSP modification needed.\n" );
	} else {
		if ($v6_tot > 0) {
			prt( "DSP needs to be MODIFIED ... add = $added, subed = $subed\n" );
		} else {
			prt( "DSP needs to be CREATED ... with $added sources ...\n" );
		}
	}

	if ($miss1) {
		prt( "\nThere are $miss1 files in VCPROJ, NOT in DSP\n" );
		for ($i1 = 0; $i1 < $v8_tot; $i1++) {
			if ($v8_srcs[$i1][4] == 0) {
				$src1 = $v8_srcs[$i1][0];
				$ff1  = $v8_srcs[$i1][1];
				$msg = "$src1 ($ff1) ";
				if (-f $ff1) {
					$msg .= "ok";
				} else {
					$msg .= "NOT FOUND";
				}
				prt( "$msg\n" );
			}
		}
	} else {
		prt( "There are NO files in VCPROJ, NOT in DSP\n" );
	}

	if ($miss2) {
		prt( "\nThere are $miss2 files in DSP, NOT in VCPROJ\n" );
		for ($i2 = 0; $i2 < $v6_tot; $i2++) {
			if ($v6_srcs[$i2][4] == 0) {
				$src2 = $v6_srcs[$i2][0];
				$ff2  = $v6_srcs[$i2][1];
				$msg = "$src2 ($ff2) ";
				if (-f $ff2) {
					$msg .= "ok";
				} else {
					$msg .= "NOT FOUND";
				}
				prt( "$msg\n" );
			}
		}
	} else {
		prt( "There are NO files in DSP, NOT in VCPROJ\n" );
	}

	prt("\n");
	# whether modified, or new, keep the DSW entry
	$dsw_projects{$key} = "$key.dsp";
	return ($added + $subed);	# return CHANGE counter
}

sub is_same_DOS_file {
	my ($f1, $f2) = @_;
	my $len = length($f1);
	if ($len != length($f2)) {
		return 0;	# not the SAME LENGTH
	}
	$f1 =~ s/\//\\/g;
	$f2 =~ s/\//\\/g;
	my $lcf1 = lc($f1);
	my $lcf2 = lc($f2);
	my $i = 0;
	while ($i < $len) {
		if (substr($lcf1,$i,1) ne substr($lcf2,$i,1)) {
			return 0;
		}
		$i++;
	}
	return 1;
}


sub fix_rel_path {
	my ($path) = shift;
	my @a = split(/\\/, $path);
	my $npath = '';
	my $max = scalar @a;
	my @na = ();
	for (my $i = 0; $i < $max; $i++) {
		my $p = $a[$i];
		if ($p eq '.') {
			# ignore this
		} elsif ($p eq '..') {
			if (@na) {
				pop @na;	# discard previous
			} else {
				prt( "WARNING: Got relative .. without previous!!! path=$path\n" );
			}
		} else {
			push(@na,$p);
		}
	}
	foreach my $pt (@na) {
		$npath .= "\\" if length($npath);
		$npath .= $pt;
	}
	return $npath;
}

### utitlity subs
sub is_c_source {
	my $f = shift;
	if ( ($f =~ /\.c$/i) || ($f =~ /\.cpp$/i) || ($f =~ /\.cxx$/i) ) {
		return 1;
	}
	##if (!is_h_source($f)) {
	##	prt( "Item [$f] IS NOT C/C++ SOURCE!\n" );
	##}
	return 0;
}

sub is_h_special {
	my $f = shift;
	if (($f =~ /osg/i)||($f =~ /OpenThreads/i)||($f =~ /Producer/i)) {
		return 1;
	}
	return 0;
}

sub is_h_source {
	my $f = shift;
	if ( ($f =~ /\.h$/i) || ($f =~ /\.hpp$/i) || ($f =~ /\.hxx$/i) ) {
		return 1;
	}
	##if (!is_c_source($f)) {
	##	prt( "Item [$f] IS NOT C/C++ SOURCE!\n" );
	##}
	return 0;
}

sub prtw {
	my ($wmsg) = shift;
	prt($wmsg);
	push(@warnings,$wmsg);
}

sub show_warnings {
	if (@warnings) {
		prt( "WARNING: Got ".scalar @warnings." warnings messages ...\n" );
		foreach my $wm (@warnings) {
			prt($wm);
		}
	} else {
		prt( "No warning messages ...\n" );
	}
}

# eof
