#!/perl -w
# NAME: color_rb.pl
# AIM: Another attempt a generating a color table
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

# rainbow colors
# red orange yellow green blue indego violet

#            0    1    2    3    4    5    6    7
my @clrs = ('ff','c0','a0','80','60','40','20','00');
my @clrv = ( 255, 192, 160, 128,  96,  64,  32,   0);

#            0     1    2    3    4    5    6    7    8  = 9
my @clrs2 = ('ff','e0','c0','a0','80','60','40','20','00');
my @clrv2 = ( 255, 224, 192, 160, 128,  96,  64,  32,   0);


sub gen_full_color_array() {
   my @arr = ();
   my ($i,$j,$k);
   my ($red,$grn,$blu);
   my ($redv,$grnv,$bluv);
   my ($bclr,$fclr);
   for ($i = 0; $i < 9; $i++) {
      for ($j = 0; $j < 9; $j++) {
         for ($k = 0; $k < 9; $k++) {
            $red = $clrs2[$i];
            $grn = $clrs2[$j];
            $blu = $clrs2[$k];
            $redv = $clrv2[$i];
            $grnv = $clrv2[$j];
            $bluv = $clrv2[$k];
            $bclr = $red.$grn.$blu;
            $fclr = $clrs[8-$i].$clrs[8-$j].$clrs[8-$k];
            push(@arr, [$bclr,$fclr,$red,$grn,$blu,$redv,$grnv,$bluv,0]);
         }
      }
   }
   return \@arr;
}

sub genrainbow() {
   my $tbl = '';
   my ($i,$j,$k,$red,$grn,$blu,$btxt,$ftxt,$bval,$dtxt,$ntxt);
 	$tbl .= "  <a name=\"tablerb\"\n";
	$tbl .= "     id=\"tablerb\"></a>\n";
	#$tbl .= "  <center>\n";
	$tbl .= "  <table border=\"1\"\n";
   $tbl .= "         align=\"center\"\n";
	$tbl .= "         cellpadding=\"4\"\n";
	$tbl .= "         cellspacing=\"4\"\n";
	$tbl .= "         summary=\"table of 9x9x9 colors\">\n";
   for ($i = 0; $i < 9; $i++) {
      for ($j = 0; $j < 9; $j++) {
         $tbl .= "   <tr>\n";
         for ($k = 0; $k < 9; $k++) {
            $red = $clrs2[$i];
            $grn = $clrs2[$j];
            $blu = $clrs2[$k];
            $btxt = $red.$grn.$blu;
            $ntxt = sprintf("%3d,%3d,%3d",$clrv2[$i],$clrv2[$j],$clrv2[$k]);
            $dtxt = $ntxt."<br>0x".$btxt;
            $ftxt = $clrs2[8-$i].$clrs2[8-$j].$clrs2[8-$k];
				$bval = hex($btxt);
				$tbl .= "    <td bgcolor=\"#".$btxt."\" nowrap align=\"center\">\n";
				$tbl .= "     <a href=\"javascript:clk();\"\n";
				$tbl .= "         onmouseover=\"sbgc('#".$btxt."'); return true;\">";
            #$tbl .= "      <tt>";
				$tbl .= "       <font color=\n";
				$tbl .= '           "#'.$ftxt.'"> ';
				$tbl .= "         <span class=\"fnt75\">";
				$tbl .= $dtxt; # add the TEXT content
            $tbl .= "         </span>";
            $tbl .= "       </font>";
            #$tbl .= "      </tt>";
            $tbl .= "     </a>\n";
            $tbl .= "    </td>\n";
         }
         $tbl .= "   </tr>\n";
      }
   }
	$tbl .= "  </table>\n";
	#$tbl .= "  </center>\n";
   return $tbl;
}

sub get_html_head {
	my $head = <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
 <head>
  <title>
   Table of 9x9x9 colors
  </title>
  <meta http-equiv="Content-Language"
        content="en-us">
  <meta http-equiv="Content-Type"
        content="text/html; charset=us-ascii">
  <meta name="keywords"
        content="web,html,html code,color chart,background colors,colorchart,charts,bgcolor,font colors,color numbers,hexidecimal,rgb,color code,colorcode,code">
  <meta name="description"
        content="geoffair.net color charts, a rainbow array of 729 Colors for your web page.">
  <link rel="stylesheet"
        href="cxx_nbg.css"
        type="text/css">
  <script language="JavaScript"
        type="text/javascript">
<!-- Begin
  // *** CROSS-BROWSER COMPATIBILITY ***
  var isDOM = (document.getElementById ? true : false); 
  var isIE4 = ((document.all && !isDOM) ? true : false);
  var isNS4 = (document.layers ? true : false);
  var isDyn = (isDOM || isIE4 || isNS4);
  var winWidth;
  var winHeight;
  var dnclick = 0;

  // get a reference
  function getRef(id)
  {
  if (isDOM) return document.getElementById(id);
  if (isIE4) return document.all[id];
  if (isNS4) return document.layers[id];
  }
  // get style
  function getSty(id)
  {
  return (isNS4 ? getRef(id) : getRef(id).style);
  }
  // change background
  function sbgc(hex) {
  document.bgColor=hex;
  }

  function clk() {
  if(dnclick)
  dnclick = 0;
  else
  dnclick = 1;
  }

  //  End -->
  </script>
  <style type="text/css">
  <!--
  .fnt100{ font-size : 100% }
  .fnt75{ font-size : 75%; font-weight : bold }
  .fnt50{ font-size : 50% }
  a:link{ text-decoration:none; }
  // -->
  </style>
 </head>
 <body>
  <a name="top"
        id="top"></a>
  <h1>
   Table of 9x9x9 colors
  </h1>

  <p align="center"><a href=\"index.htm\">index</a> <a href=\"#end\">end</a></p>

  <p>
   Perl generated 512 color tables ... This is generated from a Perl array, my
   \@clr = ('ff','e0','c0','a0','80','60','40','20','00'); into an 9 x 81 table. With
   javascript enabled, the window background should be set to the particular color on
   mouse hover over a color.
  </p>

EOF
   return $head;
}

sub get_YYYYMMDD_hhmmss($) {
    my ($t) = shift;
    my @f = (localtime($t))[0..5];
    my $m = sprintf( "%04d/%02d/%02d %02d:%02d:%02d",
        $f[5] + 1900, $f[4] +1, $f[3], $f[2], $f[1], $f[0]);
    return $m;
}

sub get_tail_html() {
   my $tail = <<EOF;
  <p align=\"center\"><a href=\"#top\">top</a></p>
  <p>
   <a name="end"
      id="end"></a> <a target="_blank"
      href="http://tidy.sourceforge.net/"><img border="0"
        src="samples/checked_by_tidy.gif"
        alt="checked by tidy"
        width="32"
        height="32"></a>&nbsp; <a href="http://validator.w3.org/check?uri=referer"
      target="_blank"><img src="samples/valid-html401.gif"
        alt="Valid HTML 4.01 Transitional"
        width="88"
        height="31"></a>
  </p>
EOF
    
    $tail .= "  <p>Generated ".get_YYYYMMDD_hhmmss(time())." by $pgmname.</p>\n";
    $tail .= "  <p align=\"center\"><a href=\"#top\">top</a></p>";
    $tail .= "  <!-- mperl/colors9.html - 2010-03-07 - Initial page generation -->\n";
    $tail .= " </body>\n</html>";

   return $tail;
}

sub write_out_html($) {
   my ($out) = shift;
   my $msg = get_html_head();
   if (open OUT, ">$out") {
      print OUT $msg;
      my $tbltxt = genrainbow();
      print OUT $tbltxt;
      $msg = get_tail_html();
      print OUT $msg;
      close OUT;
      system($out);
   }
}

my $out_html = "temprb.htm";
write_out_html($out_html);


close_log($outfile,0);
exit(0);

# eof
