#!/perl -w
# NAME: colortable.pl
# AIM: Generate an 512 color table
# 12/01/2008 - geoff mclane - http://geoffair.net/mperl
#
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
my $addtable2 = 1;
my $addtable3 = 1;
my $addtable4 = 1;
my $addtable5 = 1;
my $addatlas = 1;
my $addlinks = 1;
my $wraptbl4 = 5;	# 5 named colors per row
# for DEBUG ONLY
my $compcolors = 0; # if ($compcolors) { do_color_compare(); } COmpare NAMED and (adjusted) TIDY lists

open_log($outfile);
###prt( "$0 ... Hello, World ...\n" );

# NOTE: The site http://www.immigration-usa.com/html_colors.html uses
# likewise - http://desktoppublishing.com/color-codes.html
my @clrs_alt = ( 'ff', 'cc', '99', '66', '33', '00' );

#my @clr = ('00','20','40','60','80','a0','c0','ff');
my @clr = ('ff','c0','a0','80','60','40','20','00');
my $out_file = 'colortable.htm';
my @bgcolors = ();
my @fgcolors = ();
my @sortcolors = ();
my @tbl3colors = ();

#                white     red       orange    yellow    green     blue       indego,  black
##my $mycolorset = ( 'ffffff', 'ff0000', 'ff8000', 'ffff00', '00ff00', '0000ff', '000080', '000000' );
# from : http://www.w3.org/TR/css3-color/#html4
# it seems the W3C only define, some of these, and state they are case sensitive!?!? lowercase
# black = #000000   green = #008000  silver = #C0C0C0   lime = #00FF00  
# gray = #808080   olive = #808000   white = #FFFFFF   yellow = #FFFF00  
# maroon = #800000   navy = #000080  red = #FF0000   blue = #0000FF  
# purple = #800080   teal = #008080   fuchsia = #FF00FF   aqua = #00FFFF  

my @namedcolors = (
['aliceblue','f0f8ff'],
['antiquewhite','faebd7'],
['aqua','00ffff'],
['aquamarine','7fffd4'],
['azure','f0ffff'],
['beige','f5f5dc'],
['bisque','ffe4c4'],
['burlywood','deb887'],
['blanchedalmond','ffebcd'],
['blue','0000ff'],
['blueviolet','8a2be2'],
['brown','a52a2a'],
['black','000000'],
['cadetblue','5f9ea0'],
['chartreuse','7fff00'],
['chocolate','d2691e'],
['coral','ff7f50'],
['cornflowerblue','6495ed'],
['cornsilk','fff8dc'],
['crimson','dc143c'],
['cyan','00ffff'],
['darkblue','00008b'],
['darkcyan','008b8b'],
['darkgoldenrod','b8860b'],
['darkgray','a9a9a9'],
['darkgreen','006400'],
['darkkhaki','bdb76b'],
['darkmagenta','8b008b'],
['darkolivegreen','556b2f'],
['darkorange','ff8c00'],
['darkorchid','9932cc'],
['darkred','8b0000'],
['darksalmon','e9967a'],
['darkseagreen','8fbc8f'],
['darkslateblue','483d8b'],
['darkslategray','2f4f4f'],
['darkturquoise','00ced1'],
['darkviolet','9400d3'],
['deeppink','ff1493'],
['deepskyblue','00bfff'],
['dimgray','696969'],
['dodgerblue','1e90ff'],
['firebrick','b22222'],
['floralwhite','fffaf0'],
['forestgreen','228b22'],
['fuchsia','ff00ff'],
['gainsboro','dcdcdc'],
['ghostwhite','f8f8ff'],
['gold','ffd700'],
['goldenrod','daa520'],
['gray','808080'],
['green','008000'],
['greenyellow','adff2f'],
['honeydew','f0fff0'],
['hotpink','ff69b4'],
['indianred','cd5c5c'],
['indigo','4b0082'],
['ivory','fffff0'],
['khaki','f0e68c'],
['lavender','e6e6fa'],
['lavenderblush','fff0f5'],
['lawngreen','7cfc00'],
['lemonchiffon','fffacd'],
['lightblue','add8e6'],
['lightcoral','f08080'],
['lightcyan','e0ffff'],
['lightgoldenrodyellow','fafad2'],
['lightgreen','90ee90'],
['lightgrey','d3d3d3'],
['lightpink','ffb6c1'],
['lightsalmon','ffa07a'],
['lightseagreen','20b2aa'],
['lightskyblue','87cefa'],
['lightslategray','778899'],
['lightsteelblue','b0c4de'],
['lightyellow','ffffe0'],
['lime','00ff00'],
['limegreen','32cd32'],
['linen','faf0e6'],
['magenta','ff00ff'],
['maroon','800000'],
['mediumaquamarine','66cdaa'],
['mediumblue','0000cd'],
['mediumorchid','ba55d3'],
['mediumpurple','9370d8'],
['mediumseagreen','3cb371'],
['mediumslateblue','7b68ee'],
['mediumspringgreen','00fa9a'],
['mediumturquoise','48d1cc'],
['mediumvioletred','c71585'],
['midnightblue','191970'],
['mintcream','f5fffa'],
['mistyrose','ffe4e1'],
['moccasin','ffe4b5'],
['navajowhite','ffdead'],
['navy','000080'],
['oldlace','fdf5e6'],
['olive','808000'],
['olivedrab','688e23'],
['orange','ffa500'],
['orangered','ff4500'],
['orchid','da70d6'],
['palegoldenrod','eee8aa'],
['palegreen','98fb98'],
['paleturquoise','afeeee'],
['palevioletred','d87093'],
['papayawhip','ffefd5'],
['peachpuff','ffdab9'],
['peru','cd853f'],
['pink','ffc0cb'],
['plum','dda0dd'],
['powderblue','b0e0e6'],
['purple','800080'],
['red','ff0000'],
['rosybrown','bc8f8f'],
['royalblue','4169e1'],
['saddlebrown','8b4513'],
['salmon','fa8072'],
['sandybrown','f4a460'],
['seagreen','2e8b57'],
['seashell','fff5ee'],
['sienna','a0522d'],
['silver','c0c0c0'],
['skyblue','87ceeb'],
['slateblue','6a5acd'],
['slategray','708090'],
['snow','fffafa'],
['springgreen','00ff7f'],
['steelblue','4682b4'],
['tan','d2b48c'],
['teal','008080'],
['thistle','d8bfd8'],
['tomato','ff6347'],
['turquoise','40e0d0'],
['violet','ee82ee'],
['wheat','f5deb3'],
['white','ffffff'],
['whitesmoke','f5f5f5'],
['yellow','ffff00'],
['yellowgreen','9acd32'],

);

# added aliceblue
my @tidycolors = (
    [ "aliceblue",            "F0F8FF"],
    [ "darkgreen",            "006400" ],
    [ "antiquewhite",         "FAEBD7" ],
    [ "aqua",                 "00FFFF" ],
    [ "aquamarine",           "7FFFD4" ],
    [ "azure",                "F0FFFF" ],
    [ "beige",                "F5F5DC" ],
    [ "bisque",               "FFE4C4" ],
    [ "black",                "000000" ],
    [ "blanchedalmond",       "FFEBCD" ],
    [ "blue",                 "0000FF" ],
    [ "blueviolet",           "8A2BE2" ],
    [ "brown",                "A52A2A" ],
    [ "burlywood",            "DEB887" ],
    [ "cadetblue",            "5F9EA0" ],
    [ "chartreuse",           "7FFF00" ],
    [ "chocolate",            "D2691E" ],
    [ "coral",                "FF7F50" ],
    [ "cornflowerblue",       "6495ED" ],
    [ "cornsilk",             "FFF8DC" ],
    [ "crimson",              "DC143C" ],
    [ "cyan",                 "00FFFF" ],
    [ "darkblue",             "00008B" ],
    [ "darkcyan",             "008B8B" ],
    [ "darkgoldenrod",        "B8860B" ],
    [ "darkgray",             "A9A9A9" ],
    [ "darkgreen",            "006400" ],
    [ "darkkhaki",            "BDB76B" ],
    [ "darkmagenta",          "8B008B" ],
    [ "darkolivegreen",       "556B2F" ],
    [ "darkorange",           "FF8C00" ],
    [ "darkorchid",           "9932CC" ],
    [ "darkred",              "8B0000" ],
    [ "darksalmon",           "E9967A" ],
    [ "darkseagreen",         "8FBC8F" ],
    [ "darkslateblue",        "483D8B" ],
    [ "darkslategray",        "2F4F4F" ],
    [ "darkturquoise",        "00CED1" ],
    [ "darkviolet",           "9400D3" ],
    [ "deeppink",             "FF1493" ],
    [ "deepskyblue",          "00BFFF" ],
    [ "dimgray",              "696969" ],
    [ "dodgerblue",           "1E90FF" ],
    [ "firebrick",            "B22222" ],
    [ "floralwhite",          "FFFAF0" ],
    [ "forestgreen",          "228B22" ],
    [ "fuchsia",              "FF00FF" ],
    [ "gainsboro",            "DCDCDC" ],
    [ "ghostwhite",           "F8F8FF" ],
    [ "gold",                 "FFD700" ],
    [ "goldenrod",            "DAA520" ],
    [ "gray",                 "808080" ],
    [ "green",                "008000" ],
    [ "greenyellow",          "ADFF2F" ],
    [ "honeydew",             "F0FFF0" ],
    [ "hotpink",              "FF69B4" ],
    [ "indianred",            "CD5C5C" ],
    [ "indigo",               "4B0082" ],
    [ "ivory",                "FFFFF0" ],
    [ "khaki",                "F0E68C" ],
    [ "lavender",             "E6E6FA" ],
    [ "lavenderblush",        "FFF0F5" ],
    [ "lawngreen",            "7CFC00" ],
    [ "lemonchiffon",         "FFFACD" ],
    [ "lightblue",            "ADD8E6" ],
    [ "lightcoral",           "F08080" ],
    [ "lightcyan",            "E0FFFF" ],
    [ "lightgoldenrodyellow", "FAFAD2" ],
    [ "lightgreen",           "90EE90" ],
    [ "lightgrey",            "D3D3D3" ],
    [ "lightpink",            "FFB6C1" ],
    [ "lightsalmon",          "FFA07A" ],
    [ "lightseagreen",        "20B2AA" ],
    [ "lightskyblue",         "87CEFA" ],
    [ "lightslategray",       "778899" ],
    [ "lightsteelblue",       "B0C4DE" ],
    [ "lightyellow",          "FFFFE0" ],
    [ "lime",                 "00FF00" ],
    [ "limegreen",            "32CD32" ],
    [ "linen",                "FAF0E6" ],
    [ "magenta",              "FF00FF" ],
    [ "maroon",               "800000" ],
    [ "mediumaquamarine",     "66CDAA" ],
    [ "mediumblue",           "0000CD" ],
    [ "mediumorchid",         "BA55D3" ],
    [ "mediumpurple",         "9370DB" ],
    [ "mediumseagreen",       "3CB371" ],
    [ "mediumslateblue",      "7B68EE" ],
    [ "mediumspringgreen",    "00FA9A" ],
    [ "mediumturquoise",      "48D1CC" ],
    [ "mediumvioletred",      "C71585" ],
    [ "midnightblue",         "191970" ],
    [ "mintcream",            "F5FFFA" ],
    [ "mistyrose",            "FFE4E1" ],
    [ "moccasin",             "FFE4B5" ],
    [ "navajowhite",          "FFDEAD" ],
    [ "navy",                 "000080" ],
    [ "oldlace",              "FDF5E6" ],
    [ "olive",                "808000" ],
    [ "olivedrab",            "6B8E23" ],
    [ "orange",               "FFA500" ],
    [ "orangered",            "FF4500" ],
    [ "orchid",               "DA70D6" ],
    [ "palegoldenrod",        "EEE8AA" ],
    [ "palegreen",            "98FB98" ],
    [ "paleturquoise",        "AFEEEE" ],
    [ "palevioletred",        "DB7093" ],
    [ "papayawhip",           "FFEFD5" ],
    [ "peachpuff",            "FFDAB9" ],
    [ "peru",                 "CD853F" ],
    [ "pink",                 "FFC0CB" ],
    [ "plum",                 "DDA0DD" ],
    [ "powderblue",           "B0E0E6" ],
    [ "purple",               "800080" ],
    [ "red",                  "FF0000" ],
    [ "rosybrown",            "BC8F8F" ],
    [ "royalblue",            "4169E1" ],
    [ "saddlebrown",          "8B4513" ],
    [ "salmon",               "FA8072" ],
    [ "sandybrown",           "F4A460" ],
    [ "seagreen",             "2E8B57" ],
    [ "seashell",             "FFF5EE" ],
    [ "sienna",               "A0522D" ],
    [ "silver",               "C0C0C0" ],
    [ "skyblue",              "87CEEB" ],
    [ "slateblue",            "6A5ACD" ],
    [ "slategray",            "708090" ],
    [ "snow",                 "FFFAFA" ],
    [ "springgreen",          "00FF7F" ],
    [ "steelblue",            "4682B4" ],
    [ "tan",                  "D2B48C" ],
    [ "teal",                 "008080" ],
    [ "thistle",              "D8BFD8" ],
    [ "tomato",               "FF6347" ],
    [ "turquoise",            "40E0D0" ],
    [ "violet",               "EE82EE" ],
    [ "wheat",                "F5DEB3" ],
    [ "white",                "FFFFFF" ],
    [ "whitesmoke",           "F5F5F5" ],
    [ "yellow",               "FFFF00" ],
    [ "yellowgreen",          "9ACD32" ],
);

if ($compcolors) {
	do_color_compare();
}

prt( "Generating table text ...\n" );
my $tbltxt = gen_table_text();
@sortcolors = sort_colors();

my $tbl2txt = gen_table2_text();
my $tbl3txt = gen_table3_text();
my $tbl4txt = get_name_color_table();
my $tbl5txt = gen_table5_text();
my $atlastxt = get_atlas_table();

###out_named_colors($tbl4txt);

prt( "Writing HTML file $out_file ...\n" );
out_html_head($out_file);

append2file($tbltxt,$out_file);

if ($addtable2) {
	out_html_divide($out_file);
	append2file($tbl2txt,$out_file);
}

if ($addtable3) {
	out_html_divide($out_file);
	append2file($tbl3txt,$out_file);
}

if ($addtable4) {
	out_html_divide($out_file);
	append2file($tbl4txt,$out_file);
}

if ($addtable5) {
	out_html_divide($out_file);
	append2file($tbl5txt,$out_file);
}

if ($addatlas) {
	out_html_divide($out_file);
	append2file($atlastxt,$out_file);
}

out_html_divide($out_file);
out_html_tail($out_file);

prt( "Loading HTML file $out_file ...\n" );
system($out_file);

close_log($outfile,0);
exit(0);

sub gen_table2_text {
	my $cc = scalar @sortcolors;
	my $cc2 = scalar @bgcolors;
	my ($i, $r1, $g1, $b1, $r2, $g2, $b2, $ftxt, $btxt, $argb);
	my $wrap = 0;
	my $menu = 0;
	my $tbl = '';
	prt( "Getting table 2 text ... $cc colors ...\n" );
	$tbl .= "  <a name=\"table2\"\n";
	$tbl .= "     id=\"table2\"></a>\n";
	$tbl .= "  <p>\n";
	$tbl .= "   Table of (sort of ;=)) sorted colors ... REDish, GREENish, BLUEish, then others ...\n";
	$tbl .= "  </p>\n";
	$tbl .= "  <center>\n";
	$tbl .= "  <table border=\"1\"\n";
	$tbl .= "         cellpadding=\"8\"\n";
	$tbl .= "         summary=\"table of colors ($cc)\">\n";
	for ($i = 0; $i < $cc; $i++ ) {
		$btxt = $sortcolors[$i][0];
		$r1 = $sortcolors[$i][2];
		$g1 = $sortcolors[$i][3];
		$b1 = $sortcolors[$i][4];
		$r2 = 255 - $r1;
		$g2 = 255 - $g1;
		$b2 = 255 - $b1;
		$argb = "$r2,$g2,$b2";
		$ftxt = rgb_color_2_hex($argb);

		$tbl .= "\n   <tr>\n" if ($wrap == 0);

		$tbl .= "    <td bgcolor=\"#".$btxt."\">\n";
		$tbl .= "     <a href=\"javascript:clk();\"\n";
		$tbl .= "         onmouseover=\"sbgc('#".$btxt."'); return true;\">";
		$tbl .= "<tt><font color=\n";
		$tbl .= '         "#'.$ftxt.'"> ';
		$tbl .= $btxt." </font></tt></a>\n";
		$tbl .= "    </td>\n";

		$wrap++;
		if ($wrap == 8) {
			$tbl .= "   </tr>\n";
			$wrap = 0;
			$menu++;
			if ($menu == 8) {
				if (($i + 1) < $cc) {
					$tbl .= "\n   <tr>\n";
					$tbl .= "    <td colspan=\"8\">\n";
					$tbl .= "     <p class=\"top\">\n";
					$tbl .= "      <span class=\"fnt70\">";
					$tbl .= get_menu_text();
					$tbl .= "      </span>\n";
					$tbl .= "     </p>\n";
					$tbl .= "    </td>\n";
					$tbl .= "   </tr>\n";
				}
				$menu = 0;
			}
		}
	}

	# get those MISSED ...
	for ($i = 0; $i < $cc2; $i++ ) {
		if ($bgcolors[$i][1] == 0) {
			# output the NOT done in sort of SORT
			$btxt = $bgcolors[$i][0];
			$ftxt = $fgcolors[$i];

			$tbl .= "\n   <tr>\n" if ($wrap == 0);
			$tbl .= "    <td bgcolor=\"#".$btxt."\">\n";
			$tbl .= "     <a href=\"javascript:clk();\"\n";
			$tbl .= "         onmouseover=\"sbgc('#".$btxt."'); return true;\">";
			$tbl .= "<tt><font color=\n";
			$tbl .= '         "#'.$ftxt.'"> ';
			$tbl .= $btxt." </font></tt></a>\n";
			$tbl .= "    </td>\n";
			$wrap++;
			if ($wrap >= 8) {
				$tbl .= "   </tr>\n";
				$wrap = 0;
				$menu++;
				if ($menu == 8) {
					if (($i + 1) < $cc2) {
						$tbl .= "\n   <tr>\n";
						$tbl .= "    <td colspan=\"8\">\n";
						$tbl .= "     <p class=\"top\">\n";
						$tbl .= "      <span class=\"fnt70\">";
						$tbl .= get_menu_text();
						$tbl .= "      </span>\n";
						$tbl .= "     </p>\n";
						$tbl .= "    </td>\n";
						$tbl .= "   </tr>\n";
					}
					$menu = 0;
				}
			}
		}
	}

	if ($wrap) {
		while ($wrap < 8) {
			$tbl .= "    <td>\n";
			$tbl .= "     &nbsp;";
			$tbl .= "    </td>\n";
			$wrap++;
		}
	}
	$tbl .= "</table>\n";
	$tbl .= "  </center>\n";
	return $tbl;
}

sub gen_table3_text {
	my @arr = sort mycmp_decend @tbl3colors;
	my $cc = scalar @arr;
	my ($i, $r1, $g1, $b1, $r2, $g2, $b2, $ftxt, $btxt, $argb, $menu);
	my $wrap = 0;
	my $tbl = '';
	prt( "Getting table 3 text ... $cc colors ...\n" );
	$tbl .= "  <a name=\"table3\"\n";
	$tbl .= "     id=\"table3\"></a>\n";
	$tbl .= "  <p>\n";
	$tbl .= "   Table of (sort of ;=)) sorted colors ... by a 'luminosity value ... derived \n";
	$tbl .= "   by 	lum = (0.29 * r) + (0.587 * g) + (0.114 * b) ...\n";
	$tbl .= "  </p>\n";
	$tbl .= "  <table border=\"1\"\n";
	$tbl .= "         cellpadding=\"8\"\n";
	$tbl .= "         summary=\"table of colors ($cc)\"";
	$tbl .= "         align=\"center\">\n";
	$menu = 0;
	for ($i = 0; $i < $cc; $i++ ) {
		$btxt = $arr[$i][1];
		$r1 = $arr[$i][2];
		$g1 = $arr[$i][3];
		$b1 = $arr[$i][4];
		$r2 = 255 - $r1;
		$g2 = 255 - $g1;
		$b2 = 255 - $b1;
		$argb = "$r2,$g2,$b2";
		$ftxt = rgb_color_2_hex($argb);

		$tbl .= "\n   <tr>\n" if ($wrap == 0);

		$tbl .= "    <td bgcolor=\"#".$btxt."\">\n";
		$tbl .= "     <a href=\"javascript:clk();\"\n";
		$tbl .= "         onmouseover=\"sbgc('#".$btxt."'); return true;\">";
		$tbl .= "<tt><font color=\n";
		$tbl .= '         "#'.$ftxt.'"> ';
		$tbl .= $btxt." </font></tt></a>\n";
		$tbl .= "    </td>\n";

		$wrap++;
		if ($wrap >= 8) {
			$tbl .= "   </tr>\n";
			$wrap = 0;
			$menu++;
			if ($menu == 8) {
				if (($i + 1) < $cc) {
					$tbl .= "\n   <tr>\n";
					$tbl .= "    <td colspan=\"8\">\n";
					$tbl .= "     <p class=\"top\">\n";
					$tbl .= "      <span class=\"fnt70\">";
					$tbl .= get_menu_text();
					$tbl .= "      </span>\n";
					$tbl .= "     </p>\n";
					$tbl .= "    </td>\n";
					$tbl .= "   </tr>\n";
				}
				$menu = 0;
			}
		}
	}
	if ($wrap) {
		while ($wrap < 8) {
			$tbl .= "    <td>\n";
			$tbl .= "     &nbsp;";
			$tbl .= "    </td>\n";
			$wrap++;
		}
	}
	$tbl .= "</table>\n";
	return $tbl;
}


sub hex_color_2_rgb {
	my ($colr) = shift;
	my $cl = length($colr);
	my $rgb = '';
	if ($cl == 6) {
		for (my $i = 0; $i < 6; $i += 2) {
			my $hclr = substr($colr,$i,2);
			my $num = hex($hclr);
			$rgb .= ',' if length($rgb);
			$rgb .= "$num";
		}
	} else {
		prt( "WARNING: Not 6 length hex color!\n" );
	}
	return $rgb;
}

sub rgb_color_2_hex {
	my ($argb) = shift;
	my $hex = '';
	my @arr = split(',',$argb);
	if (scalar @arr == 3) {
		$hex .= sprintf("%2.2x", $arr[0]);
		$hex .= sprintf("%2.2x", $arr[1]);
		$hex .= sprintf("%2.2x", $arr[2]);
	} else {
		prt( "WARNING: Not an array of 3 comma separated values!\n" );
	}
	return $hex;
}

sub get_red_color {
	my ($argb) = shift;
	my $colr = 0;
	my @arr = split(',',$argb);
	if (scalar @arr == 3) {
		$colr = $arr[0];
	} else {
		prt( "WARNING: Not an array of 3 comma separated values!\n" );
	}
	return $colr;
}
sub get_green_color {
	my ($argb) = shift;
	my $colr = 0;
	my @arr = split(',',$argb);
	if (scalar @arr == 3) {
		$colr = $arr[1];
	} else {
		prt( "WARNING: Not an array of 3 comma separated values!\n" );
	}
	return $colr;
}
sub get_blue_color {
	my ($argb) = shift;
	my $colr = 0;
	my @arr = split(',',$argb);
	if (scalar @arr == 3) {
		$colr = $arr[2];
	} else {
		prt( "WARNING: Not an array of 3 comma separated values!\n" );
	}
	return $colr;
}


sub sort_colors {
	my ($clr1, $rgb1, $i, $r1, $g1, $b1);
	my ($clr2, $rgb2, $j, $r2, $g2, $b2);
	my $ncnt = 0;
	my $fnd = 1;
	my $cc = scalar @bgcolors;
	my @newc = ();
	prt( "Processingt $cc colors ...\n" );
	for ($i = 0; $i < $cc; $i++) {
		$bgcolors[$i][1] = 0;
	}
	while ($fnd) {
		$fnd = 0;
		for ($i = 0; $i < $cc; $i++) {
			if ($bgcolors[$i][1] == 0) {
				$clr1 = $bgcolors[$i][0];
				$rgb1 = hex_color_2_rgb($clr1);
				$r1 = get_red_color($rgb1);
				$g1 = get_green_color($rgb1);
				$b1 = get_blue_color($rgb1);
				if (($r1 > $g1)&&($r1 > $b1)) {
					$fnd = 1;
					push(@newc,[$clr1, 0, $r1, $g1, $b1]);
					$bgcolors[$i][1] = 1;	# mark as DONE
				}
			}
		}
	}
	$ncnt = scalar @newc;
	prt( "Got $ncnt where RED greater ...\n" );
	$fnd = 1;
	while ($fnd) {
		$fnd = 0;
		for ($i = 0; $i < $cc; $i++) {
			if ($bgcolors[$i][1] == 0) {
				$clr1 = $bgcolors[$i][0];
				$rgb1 = hex_color_2_rgb($clr1);
				$r1 = get_red_color($rgb1);
				$g1 = get_green_color($rgb1);
				$b1 = get_blue_color($rgb1);
				if (($g1 > $r1)&&($g1 > $b1)) {
					$fnd = 1;
					push(@newc,[$clr1, 0, $r1, $g1, $b1]);
					$bgcolors[$i][1] = 1;	# mark as DONE
				}
			}
		}
	}
	$ncnt = scalar @newc;
	prt( "Got $ncnt where RED and GREEN greater ...\n" );
	$fnd = 1;
	while ($fnd) {
		$fnd = 0;
		for ($i = 0; $i < $cc; $i++) {
			if ($bgcolors[$i][1] == 0) {
				$clr1 = $bgcolors[$i][0];
				$rgb1 = hex_color_2_rgb($clr1);
				$r1 = get_red_color($rgb1);
				$g1 = get_green_color($rgb1);
				$b1 = get_blue_color($rgb1);
				if (($b1 > $r1)&&($b1 > $g1)) {
					$fnd = 1;
					push(@newc,[$clr1, 0, $r1, $g1, $b1]);
					$bgcolors[$i][1] = 1;	# mark as DONE
				}
			}
		}
	}
	$ncnt = scalar @newc;
	prt( "Got $ncnt where RED and GREEN and BLUE greater ...\n" );
	return @newc;
}

sub gen_table_text {
	my ($i, $j, $k);
	my $tbl = '';
 	$tbl .= "  <a name=\"table1\"\n";
	$tbl .= "     id=\"table1\"></a>\n";
	$tbl .= "  <center>\n";
	for ($i = 0; $i < 8 ; $i++ ) {
		$tbl .= "  <table border=\"1\"\n";
		$tbl .= "         cellpadding=\"8\"\n";
		$tbl .= "         summary=\"table of colors $i\">\n";
		for ($j = 0; $j < 8; $j++ ) {
			$tbl .= "\n   <tr>\n";
			for ($k = 0; $k < 8; $k++ ) {
				my $btxt = $clr[$i].$clr[$j].$clr[$k];
				my $ftxt = $clr[7-$i].$clr[7-$j].$clr[7-$k];
				my $bval = hex($btxt);
				my $rgb3 = hex_color_2_rgb($btxt);
				my $r3 = get_red_color($rgb3);
				my $g3 = get_green_color($rgb3);
				my $b3 = get_blue_color($rgb3);
				my $lum = get_luminosity( $r3, $g3, $b3 );
				push(@bgcolors,[$btxt, 0]);	# keep the generated color
				push(@fgcolors,$ftxt);
				push(@tbl3colors, [$lum, $btxt, $r3, $g3, $b3]); 
				$tbl .= "    <td bgcolor=\"#".$btxt."\">\n";
				$tbl .= "     <a href=\"javascript:clk();\"\n";
				$tbl .= "         onmouseover=\"sbgc('#".$btxt."'); return true;\">";
				$tbl .= "<tt><font color=\n";
				$tbl .= '         "#'.$ftxt.'"> ';
				$tbl .= $btxt." </font></tt></a>\n";
				$tbl .= "    </td>\n";
			}
			$tbl .= "   </tr>\n";
		}
		$tbl .= "  </table>\n";
		###$tbl .= "<br>\n";
		if ($addlinks && (($i + 1) < 8)) {
			$tbl .= "  <p class=\"top\">\n";
			$tbl .= "   <span class=\"fnt70\">";
			$tbl .= "   ".get_menu_text();
			$tbl .= "   </span>\n";
			$tbl .= "  </p>\n";
		}
	}
	$tbl .= "  </center>\n";
	return $tbl;
}

sub gen_table5_text {
	my ($i, $j, $k);
	my $tbl = '';
 	$tbl .= "  <a name=\"table5\"\n";
	$tbl .= "     id=\"table5\"></a>\n";
	$tbl .= "  <center>\n";
	for ($i = 0; $i < 8 ; $i++ ) {
		$tbl .= "  <table border=\"1\"\n";
		$tbl .= "         cellpadding=\"0\"\n";
		$tbl .= "         cellspacing=\"0\"\n";
		$tbl .= "         summary=\"table of colors $i with rgb as floats\">\n";
		for ($j = 0; $j < 8; $j++ ) {
			$tbl .= "\n   <tr>\n";
			for ($k = 0; $k < 8; $k++ ) {
				my $btxt = $clr[$i].$clr[$j].$clr[$k];
				my $ftxt = $clr[7-$i].$clr[7-$j].$clr[7-$k];
				my $bval = hex($btxt);
				my $rgb3 = hex_color_2_rgb($btxt);
				my $r3 = get_red_color($rgb3);
				my $g3 = get_green_color($rgb3);
				my $b3 = get_blue_color($rgb3);
				#my $lum = get_luminosity( $r3, $g3, $b3 );
                my $flttxt = sprintf( "%0.3f,%0.3f,%0.3f",
                    ($r3 / 255) + 0.0005,
                    ($g3 / 255) + 0.0005,
                    ($b3 / 255) + 0.0005);
				#push(@bgcolors,[$btxt, 0]);	# keep the generated color
				#push(@fgcolors,$ftxt);
				#push(@tbl3colors, [$lum, $btxt, $r3, $g3, $b3]); 
				$tbl .= "    <td bgcolor=\"#".$btxt."\">\n";
				$tbl .= "     <a href=\"javascript:clk();\"\n";
				$tbl .= "         onmouseover=\"sbgc('#".$btxt."'); return true;\">";
                $tbl .= "<tt>";
				$tbl .= "<font color=\n";
				$tbl .= '         "#'.$ftxt.'"> ';
				$tbl .= "<span class=\"fnt50\">";
				$tbl .= $flttxt;
                $tbl .= "</span>";
                $tbl .= "</font>";
                $tbl .= "</tt>";
                $tbl .= "</a>\n";
				$tbl .= "    </td>\n";
			}
			$tbl .= "   </tr>\n";
		}
		$tbl .= "  </table>\n";
		###$tbl .= "<br>\n";
		if ($addlinks && (($i + 1) < 8)) {
			$tbl .= "  <p class=\"top\">\n";
			$tbl .= "   <span class=\"fnt70\">";
			$tbl .= "   ".get_menu_text();
			$tbl .= "   </span>\n";
			$tbl .= "  </p>\n";
		}
	}
	$tbl .= "  </center>\n";
	return $tbl;
}

sub get_menu_text {
	my $txt = '';
	$txt .= "   <a target=\"_self\" href=\"index.htm\">index</a> \n";
	$txt .= "   <a target=\"_self\" href=\"#top\">top</a> \n";
	$txt .= "   <a target=\"_self\" href=\"#table1\">table1</a> \n";
	$txt .= "   <a target=\"_self\" href=\"#table2\">table2</a> \n" if ($addtable2);
	$txt .= "   <a target=\"_self\" href=\"#table3\">table3</a> \n" if ($addtable3);
	$txt .= "   <a target=\"_self\" href=\"#table4\">table4</a> \n" if ($addtable4);
	$txt .= "   <a target=\"_self\" href=\"#table5\">table5</a> \n" if ($addtable5);
	$txt .= "   <a target=\"_self\" href=\"#atlas\">atlas</a> \n" if ($addatlas);
	$txt .= "   <a target=\"_self\" href=\"#end\">end</a> \n";
	return $txt;
}

sub out_html_head {
	my ($out) = shift;
	my $msg = '';
	my $head = <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
 <head>
  <title>
   Table of colors
  </title>
  <meta http-equiv="Content-Language"
        content="en-us">
  <meta http-equiv="Content-Type"
        content="text/html; charset=us-ascii">
  <meta name="keywords"
        content="web,html,html code,color chart,background colors,colorchart,charts,bgcolor,font colors,color numbers,hexidecimal,rgb,color code,colorcode,code">
  <meta name="description"
        content="geoffair.net color charts, a rainbow of 512 Colors for your web page.">
  <link rel="stylesheet"
        href="cxx_nbg.css"
        type="text/css">
  <script language="JavaScript"
        type="text/javascript">
<!-- Begin
  // *** CROSS-BROWSER COMPATIBILITY ***
  var isDOM = (document.getElementById ? true : false); 
  var isIE4 = ((document.all && !isDOM) ? true : false);
  var isNS4 = (document.layers ? true : false);
  var isDyn = (isDOM || isIE4 || isNS4);
  var winWidth;
  var winHeight;
  var dnclick = 0;

  // get a reference
  function getRef(id)
  {
  if (isDOM) return document.getElementById(id);
  if (isIE4) return document.all[id];
  if (isNS4) return document.layers[id];
  }
  // get style
  function getSty(id)
  {
  return (isNS4 ? getRef(id) : getRef(id).style);
  }
  // change background
  function sbgc(hex) {
  document.bgColor=hex;
  }

  function clk() {
  if(dnclick)
  dnclick = 0;
  else
  dnclick = 1;
  }

  //  End -->
  </script>
  <style type="text/css">
  <!--
  a:link{ color:#004080; text-decoration:none; }
  a:hover{ color:#FF0000; background-color:#ffff66; }
  a:visited{ color:#004080; text-decoration:none; }
  .fnt70{ font-size : 70% }
  .fnt50{ font-size : 50% }
  // -->
  </style>
 </head>
 <body>
  <a name="top"
        id="top"></a>
  <h1>
   Table of colors
  </h1>

EOF

	write2file($head, $out);

	$msg = "  <p class=\"ctr\">\n";
	$msg .= get_menu_text();
	$msg .= <<EOF;
  </p>

  <p>
   Perl generated 512 color tables ... This is generated from a Perl array, my
   \@clr = ('ff','c0','a0','80','60','40','20','00'); into an 8 x 8 x 8 table. With
   javascript enabled, the window background should be set to the particular color.
  </p>

EOF

	append2file($msg, $out);
}

sub out_html_divide {
	my ($out) = shift;
	my $div = "\n\n  <hr class=\"mini\">\n\n";
	$div .= "  <p class=\"top\">\n";
	$div .= "   ".get_menu_text()."\n";
	$div .= "  </p>\n\n";
	append2file($div,$out);
}

sub get_YYYYMMDD_hhmmss {
    my ($t) = shift;
    my @f = (localtime($t))[0..5];
    my $m = sprintf( "%04d/%02d/%02d %02d:%02d:%02d",
        $f[5] + 1900, $f[4] +1, $f[3], $f[2], $f[1], $f[0]);
    return $m;
}

sub get_atlas_table {
    my $atlas = <<EOF;
  <a name="atlas"
        id="atlas"></a>
  <h2 align="center">
   Table of Atlas Colors
  </h2>

  <p>
   Table of 22 colors from file C:\\FG\\27\\Atlas\\src\\AtlasPalette file.
  </p>

  <table align="center"
         border="1"
         cellpadding="2"
         cellspacing="2"
         summary="color table">
   <tr>
    <td bgcolor="#ABBCBE">
     <a href="javascript:clk();"
         onmouseover="sbgc('#ABBCBE'); return true;"><font color=
         "#544341">0.671,0.737,0.745</font></a>
    </td>
    <td bgcolor="#A5BAA5">
     <a href="javascript:clk();"
         onmouseover="sbgc('#A5BAA5'); return true;"><font color=
         "#5A455A">0.647,0.729,0.647</font></a>
    </td>
    <td bgcolor="#DBE7CD">
     <a href="javascript:clk();"
         onmouseover="sbgc('#DBE7CD'); return true;"><font color=
         "#241832">0.859,0.906,0.804</font></a>
    </td>
    <td bgcolor="#C0D4AE">
     <a href="javascript:clk();"
         onmouseover="sbgc('#C0D4AE'); return true;"><font color=
         "#3F2B51">0.753,0.831,0.682</font></a>
    </td>
   </tr>

   <tr>
    <td bgcolor="#F2EEC1">
     <a href="javascript:clk();"
         onmouseover="sbgc('#F2EEC1'); return true;"><font color=
         "#0D113E">0.949,0.933,0.757</font></a>
    </td>
    <td bgcolor="#F0DE9B">
     <a href="javascript:clk();"
         onmouseover="sbgc('#F0DE9B'); return true;"><font color=
         "#0F2164">0.941,0.871,0.608</font></a>
    </td>
    <td bgcolor="#E0B97C">
     <a href="javascript:clk();"
         onmouseover="sbgc('#E0B97C'); return true;"><font color=
         "#1F4683">0.878,0.725,0.486</font></a>
    </td>
    <td bgcolor="#D09D71">
     <a href="javascript:clk();"
         onmouseover="sbgc('#D09D71'); return true;"><font color=
         "#2F628E">0.816,0.616,0.443</font></a>
    </td>
   </tr>

   <tr>
    <td bgcolor="#C68757">
     <a href="javascript:clk();"
         onmouseover="sbgc('#C68757'); return true;"><font color=
         "#3978A8">0.776,0.529,0.341</font></a>
    </td>
    <td bgcolor="#D2DCD2">
     <a href="javascript:clk();"
         onmouseover="sbgc('#D2DCD2'); return true;"><font color=
         "#2D232D">0.824,0.863,0.824</font></a>
    </td>
    <td bgcolor="#AE925E">
     <a href="javascript:clk();"
         onmouseover="sbgc('#AE925E'); return true;"><font color=
         "#516DA1">0.682,0.573,0.369</font></a>
    </td>
    <td bgcolor="#464646">
     <a href="javascript:clk();"
         onmouseover="sbgc('#464646'); return true;"><font color=
         "#B9B9B9">0.275,0.275,0.275</font></a>
    </td>
   </tr>

   <tr>
    <td bgcolor="#C2D6D8">
     <a href="javascript:clk();"
         onmouseover="sbgc('#C2D6D8'); return true;"><font color=
         "#3D2927">0.761,0.839,0.847</font></a>
    </td>
    <td bgcolor="#C2D6D8">
     <a href="javascript:clk();"
         onmouseover="sbgc('#C2D6D8'); return true;"><font color=
         "#3D2927">0.761,0.839,0.847</font></a>
    </td>
    <td bgcolor="#70456B">
     <a href="javascript:clk();"
         onmouseover="sbgc('#70456B'); return true;"><font color=
         "#8FBA94">0.439,0.271,0.420</font></a>
    </td>
    <td bgcolor="#F9FA7B">
     <a href="javascript:clk();"
         onmouseover="sbgc('#F9FA7B'); return true;"><font color=
         "#060584">0.975,0.982,0.484</font></a>
    </td>
   </tr>

   <tr>
    <td bgcolor="#FF0000">
     <a href="javascript:clk();"
         onmouseover="sbgc('#FF0000'); return true;"><font color=
         "#00FFFF">1.000,0.000,0.000</font></a>
    </td>
    <td bgcolor="#DBD97A">
     <a href="javascript:clk();"
         onmouseover="sbgc('#DBD97A'); return true;"><font color=
         "#242685">0.859,0.851,0.478</font></a>
    </td>
    <td bgcolor="#CC3333">
     <a href="javascript:clk();"
         onmouseover="sbgc('#CC3333'); return true;"><font color=
         "#33CCCC">0.800,0.200,0.200</font></a>
    </td>
    <td bgcolor="#33CC33">
     <a href="javascript:clk();"
         onmouseover="sbgc('#33CC33'); return true;"><font color=
         "#CC33CC">0.200,0.800,0.200</font></a>
    </td>
   </tr>

   <tr>
    <td bgcolor="#404040">
     <a href="javascript:clk();"
         onmouseover="sbgc('#404040'); return true;"><font color=
         "#BFBFBF">0.250,0.250,0.250</font></a>
    </td>
    <td bgcolor="#FF0000">
     <a href="javascript:clk();"
         onmouseover="sbgc('#FF0000'); return true;"><font color=
         "#00FFFF">1.000,0.000,0.000</font></a>
    </td>
    <td>
     &nbsp;
    </td>
    <td>
     &nbsp;
    </td>
   </tr>
  </table>
  <!-- Generated 2009/01/22 16:49:24 by chkatlaspal.pl. -->

EOF

    return $atlas;
}

sub out_html_tail {
	my ($out) = shift;
	my $tail2 = <<EOF;

  <p>
   <a name="end"
      id="end"></a> <a target="_blank"
      href="http://tidy.sourceforge.net/"><img border="0"
        src="samples/checked_by_tidy.gif"
        alt="checked by tidy"
        width="32"
        height="32"></a>&nbsp; <a href="http://validator.w3.org/check?uri=referer"
      target="_blank"><img src="samples/valid-html401.gif"
        alt="Valid HTML 4.01 Transitional"
        width="88"
        height="31"></a>
  </p>
  <!-- 2008.01.14 - added some additional tables, generated by colortable.pl -->
  <!-- 2008.01.12 - initial page, generated by colortable.pl -->
 </body>
</html>
EOF
    
    my $tail = "<p>Generated ".get_YYYYMMDD_hhmmss(time())." by $pgmname.</p>\n";
    $tail .= $tail2;

	append2file($tail,$out);
}

sub mycmp_decend {
   if (${$a}[0] < ${$b}[0]) {
      #prt( "+[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return 1;
   }
   if (${$a}[0] > ${$b}[0]) {
      #prt( "-[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return -1;
   }
   #prt( "=[".${$a}[0]."] = [".${$b}[0]."]\n" ) if $verb3;
   return 0;
}

sub get_luminosity {
	my ($r, $g, $b) = @_;
	# .2126*R + .7152*G + .0722B using linearised R, G, and B values. 
	# my $l = (0.2126 * $r) + (0.7152 * $g) + (0.0722 * $b);
	# from : http://en.wikipedia.org/wiki/Luminosity
	# Luma (Y) = 0.299 R + 0.587 G + 0.114 B).
	my $l = (0.29 * $r) + (0.587 * $g) + (0.114 * $b);
	return $l;
}

sub get_name_color_table {
	my $cc = scalar @namedcolors;
	my ($i, $nam, $clr, $wrap, $menu);
	my $tbl = '';
	$tbl .= "  <p>\n";
	$tbl .= "   Named colors - count of $cc ...\n";
	$tbl .= "  </p>\n";
 	$tbl .= "  <a name=\"table4\"\n";
	$tbl .= "     id=\"table4\"></a>\n";
	$tbl .= "  <table border=\"1\"\n";
	$tbl .= "         cellpadding=\"8\"\n";
	$tbl .= "         summary=\"table of colors $cc\"\n";
	$tbl .= "         align=\"center\">\n";
	$wrap = 0;
	$menu = 0;
	for ($i = 0; $i < $cc; $i++) {
		$nam = $namedcolors[$i][0];
		$clr = $namedcolors[$i][1];
		$tbl .= "\n   <tr>\n" if ($wrap == 0);
		$tbl .= "    <td bgcolor=\"$nam\" align=\"center\">\n";
		$tbl .= "     <a href=\"javascript:clk();\"\n";
		$tbl .= "         onmouseover=\"sbgc('".$nam."'); return true;\">";
		$tbl .= "     $nam\n";
		$tbl .= "     <br>\n";
		$tbl .= "     $clr</a>\n";

		$tbl .= "    </td>\n";
		$wrap++;
		if ($wrap == $wraptbl4) {
			$tbl .= "   </tr>\n";
			$wrap = 0;
			$menu++;
			if ($menu == 8) {
				if (($i + 1) < $cc) {
					$tbl .= "\n   <tr>\n";
					$tbl .= "    <td colspan=\"$wraptbl4\">\n";
					$tbl .= "     <p class=\"top\">\n";
					$tbl .= "      <span class=\"fnt70\">";
					$tbl .= get_menu_text();
					$tbl .= "      </span>\n";
					$tbl .= "     </p>\n";
					$tbl .= "    </td>\n";
					$tbl .= "   </tr>\n";
				}
				$menu = 0;
			}
		}
	}
	if ($wrap) {
		while ($wrap < $wraptbl4) {
			$tbl .= "    <td>&nbsp;</td>\n";
			$wrap++;
		}
		$tbl .= "   </tr>\n";
	}
	$tbl .= "  </table>\n";
	return $tbl;
}


sub out_named_colors {
	my ($txt) = shift;
	$txt =~ s/\n/ /gm;
	$txt =~ s/\r//gm;
	$txt = trim_all($txt);
	my $tl = length($txt);
	my ($ntxt, $otxt, $i, $ch, $tag, $pch);
	$otxt = '';
	$ntxt = '';
	$tag = '';
	$pch = '';
	for ($i = 0; $i < $tl; $i++) {
		$ch = substr($txt,$i,1);
		if ($ch eq '<') {
			$tag = '';
			$i++;
			for ( ; $i < $tl; $i++) {
				$ch = substr($txt,$i,1);
				if ($ch eq '>') {
					last;
				}
			}
			$otxt .= ' ' if (length($otxt) && !($pch =~ /\s/));
			$pch = ' ';
			next;
		}
		if ($ch =~ /\s/) {
			$otxt .= $ch if !($pch =~ /\s/);
		} else {
			$otxt .= $ch;
		}
		$pch = $ch;
	}
	if (length($otxt)) {
		my @arr = split(/\s/,$otxt);
		my $ac = scalar @arr;
		$otxt = '';
		for ($i = 0; $i < $ac; $i += 2) {
			$otxt .= "['".$arr[$i]."','".$arr[$i+1]."'],\n";
		}
		write2file($otxt, 'tempnames.txt') if (length($otxt));
	}
}

sub is_in_list {
	my ($itm, @lst) = @_;
	foreach my $litm (@lst) {
		if ($itm eq $litm) {
			return 1;
		}
	}
	return 0;
}

sub	do_color_compare {
	my $ncc = scalar @namedcolors;
	my $tcc = scalar @tidycolors;
	prt( "Named count = $ncc, tidy count = $tcc ...\n" );
	my ($i, $j, $nm1, $hx1, $nm2, $hx2);
	prt( "Processing $ncc named colors ... comparing to $tcc Tidy colors ...\n" );
	my @diffhx = ();
	for ($i = 0; $i < $ncc; $i++) {
		$nm1 = $namedcolors[$i][0];
		$hx1 = $namedcolors[$i][1];
		for ($j = 0; $j < $tcc; $j++) {
			$nm2 = $tidycolors[$j][0];
			$hx2 = lc($tidycolors[$j][1]);
			if ($nm1 eq $nm2) {
				if ($hx1 ne $hx2) {
					if (!is_in_list($nm1, @diffhx)) {
						push(@diffhx,$nm1);
						prt( "Found $nm1, but different HEX $hx1 vs $hx2 ...\n" );
					}
				}
				last;
			}
		}
		if ($j == $tcc) {
			prt( "Not FOUND [$nm1] = [$hx1] ...\n" );
		}
	}
	prt( "Processing $tcc Tidy colors ... comparing to $ncc named colors ...\n" );
	for ($i = 0; $i < $tcc; $i++) {
		$nm1 = $tidycolors[$i][0];
		$hx1 = lc($tidycolors[$i][1]);
		for ($j = 0; $j < $ncc; $j++) {
			$nm2 = $namedcolors[$j][0];
			$hx2 = $namedcolors[$j][1];
			if ($nm1 eq $nm2) {
				if ($hx1 ne $hx2) {
					if (!is_in_list($nm1, @diffhx)) {
						push(@diffhx,$nm1);
						prt( "Found $nm1, but different HEX $hx1 vs $hx2 ...\n" );
					}
				}
				last;
			}
		}
		if ($j == $ncc) {
			prt( "Not FOUND [$nm1] = [$hx1] ...\n" );
		}
	}

	close_log($outfile,0);
	exit(0);
}

# eof - colortable.pl
