#!perl -w
use strict;
# module - convstr-refout.pl - include file only

our $ref_struct1 = <<EOF;
static const PixFmtInfo pix_fmt_info[PIX_FMT_NB] = { /* total blocks = 60 */
   { /* block = 1 */
       "yuv420p",       /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       1,               /* uint8_t x_chroma_shift */
       1,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 2 */   
       "yuyv422",       /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       1,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 3 */   
       "rgb24",         /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 4 */   
       "bgr24",         /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 5 */   
       "yuv422p",       /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       1,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 6 */   
       "yuv444p",       /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 7 */   
       "yuv410p",       /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       2,               /* uint8_t x_chroma_shift */
       2,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 8 */   
       "yuv411p",       /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       2,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 9 */   
       "gray",          /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_GRAY,   /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 10 */   
       "monow",         /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_GRAY,   /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       1                /* uint8_t depth          */
   },
   { /* block = 11 */   
       "monob",         /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_GRAY,   /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       1                /* uint8_t depth          */
   },
   { /* block = 12 */   
       "pal8",           /* const char * name      */
       4,                /* uint8_t nb_channels    */
       FF_COLOR_RGB,     /* uint8_t color_type     */
       FF_PIXEL_PALETTE, /* uint8_t pixel_type     */
       1,                /* uint8_t is_alpha       */
       0,                /* uint8_t is_hwaccel     */
       0,                /* uint8_t x_chroma_shift */
       0,                /* uint8_t y_chroma_shift */
       8                 /* uint8_t depth          */
   },
   { /* block = 13 */   
       "yuvj420p",        /* const char * name      */
       3,                 /* uint8_t nb_channels    */
       FF_COLOR_YUV_JPEG, /* uint8_t color_type     */
       FF_PIXEL_PLANAR,   /* uint8_t pixel_type     */
       0,                 /* uint8_t is_alpha       */
       0,                 /* uint8_t is_hwaccel     */
       1,                 /* uint8_t x_chroma_shift */
       1,                 /* uint8_t y_chroma_shift */
       8                  /* uint8_t depth          */
   },
   { /* block = 14 */   
       "yuvj422p",        /* const char * name      */
       3,                 /* uint8_t nb_channels    */
       FF_COLOR_YUV_JPEG, /* uint8_t color_type     */
       FF_PIXEL_PLANAR,   /* uint8_t pixel_type     */
       0,                 /* uint8_t is_alpha       */
       0,                 /* uint8_t is_hwaccel     */
       1,                 /* uint8_t x_chroma_shift */
       0,                 /* uint8_t y_chroma_shift */
       8                  /* uint8_t depth          */
   },
   { /* block = 15 */   
       "yuvj444p",        /* const char * name      */
       3,                 /* uint8_t nb_channels    */
       FF_COLOR_YUV_JPEG, /* uint8_t color_type     */
       FF_PIXEL_PLANAR,   /* uint8_t pixel_type     */
       0,                 /* uint8_t is_alpha       */
       0,                 /* uint8_t is_hwaccel     */
       0,                 /* uint8_t x_chroma_shift */
       0,                 /* uint8_t y_chroma_shift */
       8                  /* uint8_t depth          */
   },
   { /* block = 16 */   
       "xvmcmc", /* const char * name      */
       0,        /* uint8_t nb_channels    */
       0,        /* uint8_t color_type     */
       0,        /* uint8_t pixel_type     */
       0,        /* uint8_t is_alpha       */
       1,        /* uint8_t is_hwaccel     */
       0,        /* uint8_t x_chroma_shift */
       0,        /* uint8_t y_chroma_shift */
       0         /* uint8_t depth          */
   },
   { /* block = 17 */   
       "xvmcidct", /* const char * name      */
       0,          /* uint8_t nb_channels    */
       0,          /* uint8_t color_type     */
       0,          /* uint8_t pixel_type     */
       0,          /* uint8_t is_alpha       */
       1,          /* uint8_t is_hwaccel     */
       0,          /* uint8_t x_chroma_shift */
       0,          /* uint8_t y_chroma_shift */
       0           /* uint8_t depth          */
   },
   { /* block = 18 */   
       "uyvy422",       /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       1,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 19 */   
       "uyyvyy411",     /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       2,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 20 */   
       "bgr8",          /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 21 */   
       "bgr4",          /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       4                /* uint8_t depth          */
   },
   { /* block = 22 */   
       "bgr4_byte",     /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 23 */   
       "rgb8",          /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 24 */   
       "rgb4",          /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       4                /* uint8_t depth          */
   },
   { /* block = 25 */   
       "rgb4_byte",     /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 26 */   
       "nv12",          /* const char * name      */
       2,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       1,               /* uint8_t x_chroma_shift */
       1,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 27 */   
       "nv12",          /* const char * name      */
       2,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       1,               /* uint8_t x_chroma_shift */
       1,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 28 */   
       "argb",          /* const char * name      */
       4,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       1,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 29 */   
       "rgba",          /* const char * name      */
       4,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       1,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 30 */   
       "abgr",          /* const char * name      */
       4,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       1,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 31 */   
       "bgra",          /* const char * name      */
       4,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       1,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 32 */   
       "gray16be",      /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_GRAY,   /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       16               /* uint8_t depth          */
   },
   { /* block = 33 */   
       "gray16le",      /* const char * name      */
       1,               /* uint8_t nb_channels    */
       FF_COLOR_GRAY,   /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       16               /* uint8_t depth          */
   },
   { /* block = 34 */   
       "yuv440p",       /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       1,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 35 */   
       "yuvj440p",        /* const char * name      */
       3,                 /* uint8_t nb_channels    */
       FF_COLOR_YUV_JPEG, /* uint8_t color_type     */
       FF_PIXEL_PLANAR,   /* uint8_t pixel_type     */
       0,                 /* uint8_t is_alpha       */
       0,                 /* uint8_t is_hwaccel     */
       0,                 /* uint8_t x_chroma_shift */
       1,                 /* uint8_t y_chroma_shift */
       8                  /* uint8_t depth          */
   },
   { /* block = 36 */   
       "yuva420p",      /* const char * name      */
       4,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       1,               /* uint8_t x_chroma_shift */
       1,               /* uint8_t y_chroma_shift */
       8                /* uint8_t depth          */
   },
   { /* block = 37 */   
       "vdpau_h264", /* const char * name      */
       0,            /* uint8_t nb_channels    */
       0,            /* uint8_t color_type     */
       0,            /* uint8_t pixel_type     */
       0,            /* uint8_t is_alpha       */
       1,            /* uint8_t is_hwaccel     */
       1,            /* uint8_t x_chroma_shift */
       1,            /* uint8_t y_chroma_shift */
       0             /* uint8_t depth          */
   },
   { /* block = 38 */   
       "vdpau_mpeg1", /* const char * name      */
       0,             /* uint8_t nb_channels    */
       0,             /* uint8_t color_type     */
       0,             /* uint8_t pixel_type     */
       0,             /* uint8_t is_alpha       */
       1,             /* uint8_t is_hwaccel     */
       1,             /* uint8_t x_chroma_shift */
       1,             /* uint8_t y_chroma_shift */
       0              /* uint8_t depth          */
   },
   { /* block = 39 */   
       "vdpau_mpeg2", /* const char * name      */
       0,             /* uint8_t nb_channels    */
       0,             /* uint8_t color_type     */
       0,             /* uint8_t pixel_type     */
       0,             /* uint8_t is_alpha       */
       1,             /* uint8_t is_hwaccel     */
       1,             /* uint8_t x_chroma_shift */
       1,             /* uint8_t y_chroma_shift */
       0              /* uint8_t depth          */
   },
   { /* block = 40 */   
       "vdpau_wmv3", /* const char * name      */
       0,            /* uint8_t nb_channels    */
       0,            /* uint8_t color_type     */
       0,            /* uint8_t pixel_type     */
       0,            /* uint8_t is_alpha       */
       1,            /* uint8_t is_hwaccel     */
       1,            /* uint8_t x_chroma_shift */
       1,            /* uint8_t y_chroma_shift */
       0             /* uint8_t depth          */
   },
   { /* block = 41 */   
       "vdpau_vc1", /* const char * name      */
       0,           /* uint8_t nb_channels    */
       0,           /* uint8_t color_type     */
       0,           /* uint8_t pixel_type     */
       0,           /* uint8_t is_alpha       */
       1,           /* uint8_t is_hwaccel     */
       1,           /* uint8_t x_chroma_shift */
       1,           /* uint8_t y_chroma_shift */
       0            /* uint8_t depth          */
   },
   { /* block = 42 */   
       "rgb48be",       /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       16               /* uint8_t depth          */
   },
   { /* block = 43 */   
       "rgb48le",       /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       16               /* uint8_t depth          */
   },
   { /* block = 44 */   
       "rgb565be",      /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       5                /* uint8_t depth          */
   },
   { /* block = 45 */   
       "rgb565le",      /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       5                /* uint8_t depth          */
   },
   { /* block = 46 */   
       "rgb555be",      /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       5                /* uint8_t depth          */
   },
   { /* block = 47 */   
       "rgb555le",      /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       5                /* uint8_t depth          */
   },
   { /* block = 48 */   
       "bgr565be",      /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       5                /* uint8_t depth          */
   },
   { /* block = 49 */   
       "bgr565le",      /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       5                /* uint8_t depth          */
   },
   { /* block = 50 */   
       "bgr555be",      /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       5                /* uint8_t depth          */
   },
   { /* block = 51 */   
       "bgr555le",      /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_RGB,    /* uint8_t color_type     */
       FF_PIXEL_PACKED, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       5                /* uint8_t depth          */
   },
   { /* block = 52 */   
       "vaapi_moco", /* const char * name      */
       0,            /* uint8_t nb_channels    */
       0,            /* uint8_t color_type     */
       0,            /* uint8_t pixel_type     */
       0,            /* uint8_t is_alpha       */
       1,            /* uint8_t is_hwaccel     */
       1,            /* uint8_t x_chroma_shift */
       1,            /* uint8_t y_chroma_shift */
       0             /* uint8_t depth          */
   },
   { /* block = 53 */   
       "vaapi_idct", /* const char * name      */
       0,            /* uint8_t nb_channels    */
       0,            /* uint8_t color_type     */
       0,            /* uint8_t pixel_type     */
       0,            /* uint8_t is_alpha       */
       1,            /* uint8_t is_hwaccel     */
       1,            /* uint8_t x_chroma_shift */
       1,            /* uint8_t y_chroma_shift */
       0             /* uint8_t depth          */
   },
   { /* block = 54 */   
       "vaapi_vld", /* const char * name      */
       0,           /* uint8_t nb_channels    */
       0,           /* uint8_t color_type     */
       0,           /* uint8_t pixel_type     */
       0,           /* uint8_t is_alpha       */
       1,           /* uint8_t is_hwaccel     */
       1,           /* uint8_t x_chroma_shift */
       1,           /* uint8_t y_chroma_shift */
       0            /* uint8_t depth          */
   },
   { /* block = 55 */   
       "yuv420ple",     /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       1,               /* uint8_t x_chroma_shift */
       1,               /* uint8_t y_chroma_shift */
       16               /* uint8_t depth          */
   },
   { /* block = 56 */   
       "yuv420pbe",     /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       1,               /* uint8_t x_chroma_shift */
       1,               /* uint8_t y_chroma_shift */
       16               /* uint8_t depth          */
   },
   { /* block = 57 */   
       "yuv422ple",     /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       1,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       16               /* uint8_t depth          */
   },
   { /* block = 58 */   
       "yuv422pbe",     /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       1,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       16               /* uint8_t depth          */
   },
   { /* block = 59 */   
       "yuv444ple",     /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       16               /* uint8_t depth          */
   },
   { /* block = 60 */   
       "yuv444pbe",     /* const char * name      */
       3,               /* uint8_t nb_channels    */
       FF_COLOR_YUV,    /* uint8_t color_type     */
       FF_PIXEL_PLANAR, /* uint8_t pixel_type     */
       0,               /* uint8_t is_alpha       */
       0,               /* uint8_t is_hwaccel     */
       0,               /* uint8_t x_chroma_shift */
       0,               /* uint8_t y_chroma_shift */
       16               /* uint8_t depth          */
   }
};
EOF

our $ref_out2 = <<EOF;
static const DVprofile dv_profiles[] = {
   { /* block = 1 */
       0,                        /* int dsf                           */
       0x0,                      /* int video_stype                   */
       120000,                   /* int frame_size                    */
       10,                       /* int difseg_size                   */
       1,                        /* int n_difchan                     */
       { 1001, 30000 },          /* AVRational time_base              */
       30,                       /* int ltc_divisor                   */
       480,                      /* int height                        */
       720,                      /* int width                         */
       0,                        /* AVRational sar[2]                 */
       &work_chunks_dv25ntsc[0], /* DVwork_chunk * work_chunks        */
       &dv_idct_factor_sd[0],    /* uint32_t * idct_factor            */
       PIX_FMT_YUV411P,          /* enum PixelFormat pix_fmt          */
       6,                        /* int bpm                           */
       block_sizes_dv2550,       /* const uint8_t * block_sizes       */
       90,                       /* int audio_stride                  */
       0,                        /* int audio_min_samples[3]          */
       0,                        /* int audio_samples_dist[5]         */
       0                         /* const uint8_t (*audio_shuffle)[9] */
   },
   { /* block = 2 */   
       1,                       /* int dsf                           */
       0x0,                     /* int video_stype                   */
       144000,                  /* int frame_size                    */
       12,                      /* int difseg_size                   */
       1,                       /* int n_difchan                     */
       { 1, 25 },               /* AVRational time_base              */
       25,                      /* int ltc_divisor                   */
       576,                     /* int height                        */
       720,                     /* int width                         */
       0,                       /* AVRational sar[2]                 */
       &work_chunks_dv25pal[0], /* DVwork_chunk * work_chunks        */
       &dv_idct_factor_sd[0],   /* uint32_t * idct_factor            */
       PIX_FMT_YUV420P,         /* enum PixelFormat pix_fmt          */
       6,                       /* int bpm                           */
       block_sizes_dv2550,      /* const uint8_t * block_sizes       */
       108,                     /* int audio_stride                  */
       0,                       /* int audio_min_samples[3]          */
       0,                       /* int audio_samples_dist[5]         */
       0                        /* const uint8_t (*audio_shuffle)[9] */
   },
   { /* block = 3 */   
       1,                          /* int dsf                           */
       0x0,                        /* int video_stype                   */
       144000,                     /* int frame_size                    */
       12,                         /* int difseg_size                   */
       1,                          /* int n_difchan                     */
       { 1, 25 },                  /* AVRational time_base              */
       25,                         /* int ltc_divisor                   */
       576,                        /* int height                        */
       720,                        /* int width                         */
       0,                          /* AVRational sar[2]                 */
       &work_chunks_dv25pal411[0], /* DVwork_chunk * work_chunks        */
       &dv_idct_factor_sd[0],      /* uint32_t * idct_factor            */
       PIX_FMT_YUV411P,            /* enum PixelFormat pix_fmt          */
       6,                          /* int bpm                           */
       block_sizes_dv2550,         /* const uint8_t * block_sizes       */
       108,                        /* int audio_stride                  */
       0,                          /* int audio_min_samples[3]          */
       0,                          /* int audio_samples_dist[5]         */
       0                           /* const uint8_t (*audio_shuffle)[9] */
   },
   { /* block = 4 */   
       0,                        /* int dsf                           */
       0x4,                      /* int video_stype                   */
       240000,                   /* int frame_size                    */
       10,                       /* int difseg_size                   */
       2,                        /* int n_difchan                     */
       { 1001, 30000 },          /* AVRational time_base              */
       30,                       /* int ltc_divisor                   */
       480,                      /* int height                        */
       720,                      /* int width                         */
       0,                        /* AVRational sar[2]                 */
       &work_chunks_dv50ntsc[0], /* DVwork_chunk * work_chunks        */
       &dv_idct_factor_sd[0],    /* uint32_t * idct_factor            */
       PIX_FMT_YUV422P,          /* enum PixelFormat pix_fmt          */
       6,                        /* int bpm                           */
       block_sizes_dv2550,       /* const uint8_t * block_sizes       */
       90,                       /* int audio_stride                  */
       0,                        /* int audio_min_samples[3]          */
       0,                        /* int audio_samples_dist[5]         */
       0                         /* const uint8_t (*audio_shuffle)[9] */
   },
   { /* block = 5 */   
       1,                       /* int dsf                           */
       0x4,                     /* int video_stype                   */
       288000,                  /* int frame_size                    */
       12,                      /* int difseg_size                   */
       2,                       /* int n_difchan                     */
       { 1, 25 },               /* AVRational time_base              */
       25,                      /* int ltc_divisor                   */
       576,                     /* int height                        */
       720,                     /* int width                         */
       0,                       /* AVRational sar[2]                 */
       &work_chunks_dv50pal[0], /* DVwork_chunk * work_chunks        */
       &dv_idct_factor_sd[0],   /* uint32_t * idct_factor            */
       PIX_FMT_YUV422P,         /* enum PixelFormat pix_fmt          */
       6,                       /* int bpm                           */
       block_sizes_dv2550,      /* const uint8_t * block_sizes       */
       108,                     /* int audio_stride                  */
       0,                       /* int audio_min_samples[3]          */
       0,                       /* int audio_samples_dist[5]         */
       0                        /* const uint8_t (*audio_shuffle)[9] */
   },
   { /* block = 6 */   
       0,                          /* int dsf                           */
       0x14,                       /* int video_stype                   */
       480000,                     /* int frame_size                    */
       10,                         /* int difseg_size                   */
       4,                          /* int n_difchan                     */
       { 1001, 30000 },            /* AVRational time_base              */
       30,                         /* int ltc_divisor                   */
       1080,                       /* int height                        */
       1280,                       /* int width                         */
       0,                          /* AVRational sar[2]                 */
       &work_chunks_dv100ntsci[0], /* DVwork_chunk * work_chunks        */
       &dv_idct_factor_hd1080[0],  /* uint32_t * idct_factor            */
       PIX_FMT_YUV422P,            /* enum PixelFormat pix_fmt          */
       8,                          /* int bpm                           */
       block_sizes_dv100,          /* const uint8_t * block_sizes       */
       90,                         /* int audio_stride                  */
       0,                          /* int audio_min_samples[3]          */
       0,                          /* int audio_samples_dist[5]         */
       0                           /* const uint8_t (*audio_shuffle)[9] */
   },
   { /* block = 7 */   
       1,                         /* int dsf                           */
       0x14,                      /* int video_stype                   */
       576000,                    /* int frame_size                    */
       12,                        /* int difseg_size                   */
       4,                         /* int n_difchan                     */
       { 1, 25 },                 /* AVRational time_base              */
       25,                        /* int ltc_divisor                   */
       1080,                      /* int height                        */
       1440,                      /* int width                         */
       0,                         /* AVRational sar[2]                 */
       &work_chunks_dv100pali[0], /* DVwork_chunk * work_chunks        */
       &dv_idct_factor_hd1080[0], /* uint32_t * idct_factor            */
       PIX_FMT_YUV422P,           /* enum PixelFormat pix_fmt          */
       8,                         /* int bpm                           */
       block_sizes_dv100,         /* const uint8_t * block_sizes       */
       108,                       /* int audio_stride                  */
       0,                         /* int audio_min_samples[3]          */
       0,                         /* int audio_samples_dist[5]         */
       0                          /* const uint8_t (*audio_shuffle)[9] */
   },
   { /* block = 8 */   
       0,                          /* int dsf                           */
       0x18,                       /* int video_stype                   */
       240000,                     /* int frame_size                    */
       10,                         /* int difseg_size                   */
       2,                          /* int n_difchan                     */
       { 1001, 60000 },            /* AVRational time_base              */
       60,                         /* int ltc_divisor                   */
       720,                        /* int height                        */
       960,                        /* int width                         */
       0,                          /* AVRational sar[2]                 */
       &work_chunks_dv100ntscp[0], /* DVwork_chunk * work_chunks        */
       &dv_idct_factor_hd720[0],   /* uint32_t * idct_factor            */
       PIX_FMT_YUV422P,            /* enum PixelFormat pix_fmt          */
       8,                          /* int bpm                           */
       block_sizes_dv100,          /* const uint8_t * block_sizes       */
       90,                         /* int audio_stride                  */
       0,                          /* int audio_min_samples[3]          */
       0,                          /* int audio_samples_dist[5]         */
       0                           /* const uint8_t (*audio_shuffle)[9] */
   },
   { /* block = 9 */   
       1,                         /* int dsf                           */
       0x18,                      /* int video_stype                   */
       288000,                    /* int frame_size                    */
       12,                        /* int difseg_size                   */
       2,                         /* int n_difchan                     */
       { 1, 50 },                 /* AVRational time_base              */
       50,                        /* int ltc_divisor                   */
       720,                       /* int height                        */
       960,                       /* int width                         */
       0,                         /* AVRational sar[2]                 */
       &work_chunks_dv100palp[0], /* DVwork_chunk * work_chunks        */
       &dv_idct_factor_hd720[0],  /* uint32_t * idct_factor            */
       PIX_FMT_YUV422P,           /* enum PixelFormat pix_fmt          */
       8,                         /* int bpm                           */
       block_sizes_dv100,         /* const uint8_t * block_sizes       */
       90,                        /* int audio_stride                  */
       0,                         /* int audio_min_samples[3]          */
       0,                         /* int audio_samples_dist[5]         */
       0                          /* const uint8_t (*audio_shuffle)[9] */
   }
};
EOF

our $ref_out3 = <<EOF;
AVCodec libfaad2_decoder = {
    "AAC_LATM",           /* const char * name                                                                  */
    CODEC_TYPE_AUDIO,     /* enum CodecType type                                                                */
    CODEC_ID_AAC_LATM,    /* enum CodecID id                                                                    */
    sizeof (FAACContext), /* int priv_data_size                                                                 */
    faac_decode_init,     /* int (*init)(AVCodecContext *)                                                      */
    NULL,                 /* int (*encode)(AVCodecContext *, uint8_t *buf, int buf_size, void *data)            */
    faac_decode_end,      /* int (*close)(AVCodecContext *)                                                     */
    faac_decode_frame,    /* int (*decode)(AVCodecContext *, void *outdata, int *outdata_size, AVPacket *avpkt) */
    0,                    /* int capabilities                                                                   */
    NULL,                 /* struct AVCodec * next                                                              */
    NULL,                 /* void (*flush)(AVCodecContext *)                                                    */
    NULL,                 /* const AVRational * supported_framerates                                            */
    NULL,                 /* const enum PixelFormat * pix_fmts                                                  */
    "AAC over LATM",      /* const char * long_name                                                             */
    NULL,                 /* const int * supported_samplerates                                                  */
    NULL,                 /* const enum SampleFormat * sample_fmts                                              */
    NULL                  /* const int64_t * channel_layouts                                                    */
};
EOF

our $ref_out4 = <<EOF;
const AVPixFmtDescriptor av_pix_fmt_descriptors[PIX_FMT_NB] = { /* total blocks = 60 */
   { /* block = 1 */
       "yuv420p", /* const char * name             */
       3,         /* uint8_t nb_channels           */
       1,         /* uint8_t log2_chroma_w         */
       1,         /* uint8_t log2_chroma_h         */
       0,         /* uint8_t flags                 */
       0          /* AVComponentDescriptor comp[4] */
   },
   { /* block = 2 */   
       "yuyv422", /* const char * name             */
       3,         /* uint8_t nb_channels           */
       1,         /* uint8_t log2_chroma_w         */
       0,         /* uint8_t log2_chroma_h         */
       0,         /* uint8_t flags                 */
       0          /* AVComponentDescriptor comp[4] */
   },
   { /* block = 3 */   
       "rgb24", /* const char * name             */
       3,       /* uint8_t nb_channels           */
       0,       /* uint8_t log2_chroma_w         */
       0,       /* uint8_t log2_chroma_h         */
       0,       /* uint8_t flags                 */
       0        /* AVComponentDescriptor comp[4] */
   },
   { /* block = 4 */   
       "bgr24", /* const char * name             */
       3,       /* uint8_t nb_channels           */
       0,       /* uint8_t log2_chroma_w         */
       0,       /* uint8_t log2_chroma_h         */
       0,       /* uint8_t flags                 */
       0        /* AVComponentDescriptor comp[4] */
   },
   { /* block = 5 */   
       "yuv422p", /* const char * name             */
       3,         /* uint8_t nb_channels           */
       1,         /* uint8_t log2_chroma_w         */
       0,         /* uint8_t log2_chroma_h         */
       0,         /* uint8_t flags                 */
       0          /* AVComponentDescriptor comp[4] */
   },
   { /* block = 6 */   
       "yuv444p", /* const char * name             */
       3,         /* uint8_t nb_channels           */
       0,         /* uint8_t log2_chroma_w         */
       0,         /* uint8_t log2_chroma_h         */
       0,         /* uint8_t flags                 */
       0          /* AVComponentDescriptor comp[4] */
   },
   { /* block = 7 */   
       "yuv410p", /* const char * name             */
       3,         /* uint8_t nb_channels           */
       2,         /* uint8_t log2_chroma_w         */
       2,         /* uint8_t log2_chroma_h         */
       0,         /* uint8_t flags                 */
       0          /* AVComponentDescriptor comp[4] */
   },
   { /* block = 8 */   
       "yuv411p", /* const char * name             */
       3,         /* uint8_t nb_channels           */
       2,         /* uint8_t log2_chroma_w         */
       0,         /* uint8_t log2_chroma_h         */
       0,         /* uint8_t flags                 */
       0          /* AVComponentDescriptor comp[4] */
   },
   { /* block = 9 */   
       "gray8", /* const char * name             */
       1,       /* uint8_t nb_channels           */
       0,       /* uint8_t log2_chroma_w         */
       0,       /* uint8_t log2_chroma_h         */
       0,       /* uint8_t flags                 */
       0        /* AVComponentDescriptor comp[4] */
   },
   { /* block = 10 */   
       "monowhite",       /* const char * name             */
       1,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       PIX_FMT_BITSTREAM, /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 11 */   
       "monoblack",       /* const char * name             */
       1,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       PIX_FMT_BITSTREAM, /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 12 */   
       "pal8",      /* const char * name             */
       1,           /* uint8_t nb_channels           */
       0,           /* uint8_t log2_chroma_w         */
       0,           /* uint8_t log2_chroma_h         */
       PIX_FMT_PAL, /* uint8_t flags                 */
       0            /* AVComponentDescriptor comp[4] */
   },
   { /* block = 13 */   
       "yuvj420p", /* const char * name             */
       3,          /* uint8_t nb_channels           */
       1,          /* uint8_t log2_chroma_w         */
       1,          /* uint8_t log2_chroma_h         */
       0,          /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 14 */   
       "yuvj422p", /* const char * name             */
       3,          /* uint8_t nb_channels           */
       1,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       0,          /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 15 */   
       "yuvj444p", /* const char * name             */
       3,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       0,          /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 16 */   
       NULL,              /* const char * name             */
       0,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       0,                 /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 17 */   
       NULL,              /* const char * name             */
       0,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       0,                 /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 18 */   
       "uyvy422", /* const char * name             */
       3,         /* uint8_t nb_channels           */
       1,         /* uint8_t log2_chroma_w         */
       0,         /* uint8_t log2_chroma_h         */
       0,         /* uint8_t flags                 */
       0          /* AVComponentDescriptor comp[4] */
   },
   { /* block = 19 */   
       "uyyvyy411", /* const char * name             */
       3,           /* uint8_t nb_channels           */
       2,           /* uint8_t log2_chroma_w         */
       0,           /* uint8_t log2_chroma_h         */
       0,           /* uint8_t flags                 */
       0            /* AVComponentDescriptor comp[4] */
   },
   { /* block = 20 */   
       "bgr8", /* const char * name             */
       3,      /* uint8_t nb_channels           */
       0,      /* uint8_t log2_chroma_w         */
       0,      /* uint8_t log2_chroma_h         */
       0,      /* uint8_t flags                 */
       0       /* AVComponentDescriptor comp[4] */
   },
   { /* block = 21 */   
       "bgr4",            /* const char * name             */
       3,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       PIX_FMT_BITSTREAM, /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 22 */   
       "bgr4_byte", /* const char * name             */
       3,           /* uint8_t nb_channels           */
       0,           /* uint8_t log2_chroma_w         */
       0,           /* uint8_t log2_chroma_h         */
       0,           /* uint8_t flags                 */
       0            /* AVComponentDescriptor comp[4] */
   },
   { /* block = 23 */   
       "rgb8", /* const char * name             */
       3,      /* uint8_t nb_channels           */
       0,      /* uint8_t log2_chroma_w         */
       0,      /* uint8_t log2_chroma_h         */
       0,      /* uint8_t flags                 */
       0       /* AVComponentDescriptor comp[4] */
   },
   { /* block = 24 */   
       "rgb4",            /* const char * name             */
       3,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       PIX_FMT_BITSTREAM, /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 25 */   
       "rgb4_byte", /* const char * name             */
       3,           /* uint8_t nb_channels           */
       0,           /* uint8_t log2_chroma_w         */
       0,           /* uint8_t log2_chroma_h         */
       0,           /* uint8_t flags                 */
       0            /* AVComponentDescriptor comp[4] */
   },
   { /* block = 26 */   
       "nv12", /* const char * name             */
       3,      /* uint8_t nb_channels           */
       1,      /* uint8_t log2_chroma_w         */
       1,      /* uint8_t log2_chroma_h         */
       0,      /* uint8_t flags                 */
       0       /* AVComponentDescriptor comp[4] */
   },
   { /* block = 27 */   
       "nv21", /* const char * name             */
       3,      /* uint8_t nb_channels           */
       1,      /* uint8_t log2_chroma_w         */
       1,      /* uint8_t log2_chroma_h         */
       0,      /* uint8_t flags                 */
       0       /* AVComponentDescriptor comp[4] */
   },
   { /* block = 28 */   
       "argb", /* const char * name             */
       4,      /* uint8_t nb_channels           */
       0,      /* uint8_t log2_chroma_w         */
       0,      /* uint8_t log2_chroma_h         */
       0,      /* uint8_t flags                 */
       0       /* AVComponentDescriptor comp[4] */
   },
   { /* block = 29 */   
       "rgba", /* const char * name             */
       4,      /* uint8_t nb_channels           */
       0,      /* uint8_t log2_chroma_w         */
       0,      /* uint8_t log2_chroma_h         */
       0,      /* uint8_t flags                 */
       0       /* AVComponentDescriptor comp[4] */
   },
   { /* block = 30 */   
       "abgr", /* const char * name             */
       4,      /* uint8_t nb_channels           */
       0,      /* uint8_t log2_chroma_w         */
       0,      /* uint8_t log2_chroma_h         */
       0,      /* uint8_t flags                 */
       0       /* AVComponentDescriptor comp[4] */
   },
   { /* block = 31 */   
       "bgra", /* const char * name             */
       4,      /* uint8_t nb_channels           */
       0,      /* uint8_t log2_chroma_w         */
       0,      /* uint8_t log2_chroma_h         */
       0,      /* uint8_t flags                 */
       0       /* AVComponentDescriptor comp[4] */
   },
   { /* block = 32 */   
       "gray16be", /* const char * name             */
       1,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       PIX_FMT_BE, /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 33 */   
       "gray16le", /* const char * name             */
       1,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       0,          /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 34 */   
       "yuv440p", /* const char * name             */
       3,         /* uint8_t nb_channels           */
       0,         /* uint8_t log2_chroma_w         */
       1,         /* uint8_t log2_chroma_h         */
       0,         /* uint8_t flags                 */
       0          /* AVComponentDescriptor comp[4] */
   },
   { /* block = 35 */   
       "yuvj440p", /* const char * name             */
       3,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       1,          /* uint8_t log2_chroma_h         */
       0,          /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 36 */   
       "yuva420p", /* const char * name             */
       4,          /* uint8_t nb_channels           */
       1,          /* uint8_t log2_chroma_w         */
       1,          /* uint8_t log2_chroma_h         */
       0,          /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 37 */   
       NULL,              /* const char * name             */
       0,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       0,                 /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 38 */   
       NULL,              /* const char * name             */
       0,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       0,                 /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 39 */   
       NULL,              /* const char * name             */
       0,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       0,                 /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 40 */   
       NULL,              /* const char * name             */
       0,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       0,                 /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 41 */   
       NULL,              /* const char * name             */
       0,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       0,                 /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 42 */   
       "rgb48be",  /* const char * name             */
       3,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       PIX_FMT_BE, /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 43 */   
       "rgb48le", /* const char * name             */
       3,         /* uint8_t nb_channels           */
       0,         /* uint8_t log2_chroma_w         */
       0,         /* uint8_t log2_chroma_h         */
       0,         /* uint8_t flags                 */
       0          /* AVComponentDescriptor comp[4] */
   },
   { /* block = 44 */   
       "rgb565be", /* const char * name             */
       3,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       PIX_FMT_BE, /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 45 */   
       "rgb565le", /* const char * name             */
       3,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       0,          /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 46 */   
       "rgb555be", /* const char * name             */
       3,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       PIX_FMT_BE, /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 47 */   
       "rgb555le", /* const char * name             */
       3,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       0,          /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 48 */   
       "bgr565be", /* const char * name             */
       3,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       PIX_FMT_BE, /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 49 */   
       "bgr565le", /* const char * name             */
       3,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       0,          /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 50 */   
       "bgr555be", /* const char * name             */
       3,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       PIX_FMT_BE, /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 51 */   
       "bgr555le", /* const char * name             */
       3,          /* uint8_t nb_channels           */
       0,          /* uint8_t log2_chroma_w         */
       0,          /* uint8_t log2_chroma_h         */
       0,          /* uint8_t flags                 */
       0           /* AVComponentDescriptor comp[4] */
   },
   { /* block = 52 */   
       NULL,              /* const char * name             */
       0,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       0,                 /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 53 */   
       NULL,              /* const char * name             */
       0,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       0,                 /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 54 */   
       NULL,              /* const char * name             */
       0,                 /* uint8_t nb_channels           */
       0,                 /* uint8_t log2_chroma_w         */
       0,                 /* uint8_t log2_chroma_h         */
       0,                 /* uint8_t flags                 */
       0                  /* AVComponentDescriptor comp[4] */
   },
   { /* block = 55 */   
       "yuv420ple", /* const char * name             */
       3,           /* uint8_t nb_channels           */
       1,           /* uint8_t log2_chroma_w         */
       1,           /* uint8_t log2_chroma_h         */
       0,           /* uint8_t flags                 */
       0            /* AVComponentDescriptor comp[4] */
   },
   { /* block = 56 */   
       "yuv420pbe", /* const char * name             */
       3,           /* uint8_t nb_channels           */
       1,           /* uint8_t log2_chroma_w         */
       1,           /* uint8_t log2_chroma_h         */
       PIX_FMT_BE,  /* uint8_t flags                 */
       0            /* AVComponentDescriptor comp[4] */
   },
   { /* block = 57 */   
       "yuv422ple", /* const char * name             */
       3,           /* uint8_t nb_channels           */
       1,           /* uint8_t log2_chroma_w         */
       0,           /* uint8_t log2_chroma_h         */
       0,           /* uint8_t flags                 */
       0            /* AVComponentDescriptor comp[4] */
   },
   { /* block = 58 */   
       "yuv422pbe", /* const char * name             */
       3,           /* uint8_t nb_channels           */
       1,           /* uint8_t log2_chroma_w         */
       0,           /* uint8_t log2_chroma_h         */
       PIX_FMT_BE,  /* uint8_t flags                 */
       0            /* AVComponentDescriptor comp[4] */
   },
   { /* block = 59 */   
       "yuv444ple", /* const char * name             */
       3,           /* uint8_t nb_channels           */
       0,           /* uint8_t log2_chroma_w         */
       0,           /* uint8_t log2_chroma_h         */
       0,           /* uint8_t flags                 */
       0            /* AVComponentDescriptor comp[4] */
   },
   { /* block = 60 */   
       "yuv444pbe", /* const char * name             */
       3,           /* uint8_t nb_channels           */
       0,           /* uint8_t log2_chroma_w         */
       0,           /* uint8_t log2_chroma_h         */
       PIX_FMT_BE,  /* uint8_t flags                 */
       0            /* AVComponentDescriptor comp[4] */
   }
};
EOF

our $ref_out5 = <<EOF;
static const BlockNode null_block= {
    0, /* int16_t mx       */
    0, /* int16_t my       */
    0, /* uint8_t ref      */
    0, /* uint8_t color[3] */
    0, /* uint8_t type     */
    0  /* uint8_t level    */
};
EOF

our $ref_out6 = <<EOF;
AVHWAccel vc1_vaapi_hwaccel = {
    "vc1_vaapi",            /* const char * name                                                                 */
    CODEC_TYPE_VIDEO,       /* enum CodecType type                                                               */
    CODEC_ID_VC1,           /* enum CodecID id                                                                   */
    PIX_FMT_VAAPI_VLD,      /* enum PixelFormat pix_fmt                                                          */
    0,                      /* int capabilities                                                                  */
    NULL,                   /* struct AVHWAccel * next                                                           */
    vaapi_vc1_start_frame,  /* int (*start_frame)(AVCodecContext *avctx, const uint8_t *buf, uint32_t buf_size)  */
    vaapi_vc1_decode_slice, /* int (*decode_slice)(AVCodecContext *avctx, const uint8_t *buf, uint32_t buf_size) */
    vaapi_vc1_end_frame,    /* int (*end_frame)(AVCodecContext *avctx)                                           */
    0                       /* int priv_data_size                                                                */
};
EOF

our $ref_out7 = <<EOF;
AVInputFormat asf_demuxer = {
    "asf",                              /* const char * name                                                                                                     */
    NULL_IF_CONFIG_SMALL("ASF format"), /* const char * long_name                                                                                                */
    sizeof(ASFContext),                 /* int priv_data_size                                                                                                    */
    asf_probe,                          /* int (*read_probe)(AVProbeData *)                                                                                      */
    asf_read_header,                    /* int (*read_header)(struct AVFormatContext *,                                                                          */
    asf_read_packet,                    /* AVFormatParameters * ap)                                                                                              */
    asf_read_close,                     /* int (*read_packet)(struct AVFormatContext *, AVPacket *pkt)                                                           */
    asf_read_seek,                      /* int (*read_close)(struct AVFormatContext *)                                                                           */
    asf_read_pts,                       /* int (*read_seek)(struct AVFormatContext *,                                                                            */
    0,                                  /* int stream_index, int64_t timestamp, int flags)                                                                       */
    0,                                  /* int64_t (*read_timestamp)(struct AVFormatContext *s, int stream_index,                                                */
    NULL,                               /* int64_t * pos, int64_t pos_limit)                                                                                     */
    0,                                  /* int flags                                                                                                             */
    NULL,                               /* const char * extensions                                                                                               */
    0,                                  /* int value                                                                                                             */
    NULL,                               /* int (*read_play)(struct AVFormatContext *)                                                                            */
    NULL,                               /* int (*read_pause)(struct AVFormatContext *)                                                                           */
    NULL,                               /* const struct AVCodecTag * const * codec_tag                                                                           */
    NULL,                               /* int (*read_seek2)(struct AVFormatContext *s, int stream_index, int64_t min_ts, int64_t ts, int64_t max_ts, int flags) */
    ff_asf_metadata_conv,               /* const AVMetadataConv * metadata_conv                                                                                  */
    NULL                                /* struct AVInputFormat * next                                                                                           */
};
EOF

our $ref_out8 = <<EOF;
AVOutputFormat aiff_muxer = {
    "aiff",                                           /* const char * name                                                     */
    NULL_IF_CONFIG_SMALL("Audio IFF"),                /* const char * long_name                                                */
    "audio/aiff",                                     /* const char * mime_type                                                */
    "aif,aiff,afc,aifc",                              /* const char * extensions                                               */
    sizeof(AIFFOutputContext),                        /* int priv_data_size                                                    */
    CODEC_ID_PCM_S16BE,                               /* enum CodecID audio_codec                                              */
    CODEC_ID_NONE,                                    /* enum CodecID video_codec                                              */
    aiff_write_header,                                /* int (*write_header)(struct AVFormatContext *)                         */
    aiff_write_packet,                                /* int (*write_packet)(struct AVFormatContext *, AVPacket *pkt)          */
    aiff_write_trailer,                               /* int (*write_trailer)(struct AVFormatContext *)                        */
    0,                                                /* int flags                                                             */
    NULL,                                             /* int (*set_parameters)(struct AVFormatContext *, AVFormatParameters *) */
    0,                                                /* int (*interleave_packet)(struct AVFormatContext *, AVPacket *out,     */
    NULL,                                             /* AVPacket * in, int flush)                                             */
    (const AVCodecTag* const []){codec_aiff_tags, 0}, /* const struct AVCodecTag * const * codec_tag                           */
    0,                                                /* enum CodecID subtitle_codec                                           */
    NULL,                                             /* const AVMetadataConv * metadata_conv                                  */
    NULL                                              /* struct AVOutputFormat * next                                          */
};
EOF

our $ref_out14 = <<EOF;
nut_input_stream_tt input = {
    NULL,    /* void *  priv                                           */
    av_read, /* size_t (*read)(void * priv, size_t len, uint8_t * buf) */
    av_seek, /* off_t (*seek)(void * priv, long long pos, int whence)  */
    NULL,    /* int (*eof)(void * priv)                                */
    0        /* off_t file_pos                                         */
};
EOF

1;
# eof convstr-refout.pl
