#!/perl -w
# NAME: delsame.pl
# AIM: Given an input file, scan deleting blank and same lines
use strict;
use warnings;
use File::Basename;
use Cwd;
unshift(@INC, 'C:\GTools\perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:\GTools\perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 1;
my $inp_file = 'tempf4';
### program variables
my @warnings = ();
my $cwd = cwd();

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub process_file($) {
    my ($fil) = @_;
    my @nlines = ();
    if (!open INF, "<$fil") {
        prt("Error: Can NOT open file [$fil]!\n");
        return \@nlines;
    }
    my @lines = <INF>;
    my %hash = ();
    close INF;
    my $lnn = scalar @lines;
    prt("Processing $lnn lines, from [$fil]...\n");
    $lnn = 0;
    foreach my $line (@lines) {
        $lnn++;
        $line = trim_all($line);
        next if (length($line) == 0);
        next if (defined $hash{$line});
        $hash{$line} = $lnn;
        push(@nlines,$line);
    }
    return \@nlines;
}

sub show_ref_arr($) {
    my ($ra) = @_;
    my $cnt = scalar @{$ra};
    prt("Showing $cnt different lines...\n");
    foreach my $line (@{$ra}) {
        prt("$line\n");
    }
    prt("Done $cnt different lines...\n");
}

#########################################
### MAIN ###
prt( "$pgmname: in [$cwd]: Hello, World...\n" );
my $ref_arr = process_file($inp_file);
show_ref_arr($ref_arr);
pgm_exit(0,"Normal exit(0)");
########################################
# eof - template.pl
