#!/perl -w
# NAME: dsp2cfg.pl
# AIM: Read a specific DSP file, and build an am2dsp CONFIG file
# 21/04/2007 - geoff mclane - http:\\geoffmclane.com
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $in_file = "G:\\FG\\13-MSVC6\\SimGear\\source\\SimGear.dsp";
my $is_static = 0;

if (! -f $in_file) {
	nydie( "ERROR: Unable to find $in_file ... $! ...\n" );
}

open INF, "<$in_file" or mydie( "ERROR: Unable to OPEN $in_file ...\n" );
my @lines = <INF>;
close INF;
my $cnt = scalar @lines;
prt( "Processing $cnt lines of $in_file ...\n" );
foreach my $line (@lines) {
	chomp $line;
	$line = trim_all($line);
	if (substr($line,0,1) eq '#') {
		$line = trim_all(substr($line,1));
		if ($line =~ /^TARGTYPE\s+(.*)/) {
			$line = strip_dquotes($1);
			if ($line =~ /Static/) {
				$is_static = 1;
			} else {
				$is_static = 0;
			}

			prt( "Got TARGTYPE [$line] ..." );
			if ($is_static) {
				prt( " static library\n" );
			} else {
				prt( " is application\n" );
			}
		} elsif ($line =~ /ADD CPP(.*)/) {
			prt( "CPP OPTS: $1 ...\n" );
		}
	} elsif (substr($line,0,1) eq '!') {
		$line = trim_all(substr($line,1));
		if ($line =~ /^IF\s+(.*)/i) {
			prt( "Entering IF - $1 ...\n" );
		} elsif ($line =~ /^ELSE\s*/i) {
			prt( "Entering ELSE ...\n" );
		} elsif ($line =~ /^ELSEIF\s+(.*)/i) {
			prt( "Entering ELSEIF - $1 ...\n" );
		} elsif ($line =~ /^ENDIF\s*/i) {
			prt( "Entering ENDIF ...\n" );
		} elsif ($line =~ /^MESSAGE\s*/i) {
			#prt( "Just a MESSAGE ...\n" );
		} else {
			prt( "WHAT IS THIS - $line ...\n" );
		}

	}

}
close_log($outfile,1);
exit(0);

sub strip_dquotes {
	my ($ln) = shift;
	$ln =~ s/\"//g;
	return $ln;
}

# eof
