#!/perl -w
# NAME: fgvc2dsp.pl
# AIM: Process a VCPROJ file, extract SOURCES and information, and write DSP file
# 28/10/2008 - Rewrite of fgsln2dsp.pl, processing just ONE VCPROJ file,
# and writting a (temporary) DSP file ...
use strict;
use warnings;
use File::Basename;
use Cwd;
require 'fgutils.pl' or die "Unable to load fgutils.pl ...\n";
require 'fgdsphdrs.pl' or die "Unable to load fgdsphdrs.pl ...\n";
require 'fgscanvc.pl' or die "Unable to load fgscanvc.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

use constant {
    TT_UNK => 0,
    TT_BGN => 1,
    TT_END => 2,
    TT_BE  => 3,
    TT_DEC => 4
};

my $TYP_OPEN = 1;
my $TYP_CLOSE = 2;
my $TYP_OPENCLOSE = 3;
my $TYP_VERSION = 4;

my %v6_all = ();
my %v6_refall = ();

my $act_disp = '';
my $act_file = '';
my $act_vcproj = '';

my $dbg11 = 0;
my $dbg_src1 = 0;
my $dbg_src10 = 0;
my $dbg_src11 = 0;
my $dbg_src12 = 0;
my $dbg_src12a = 0;
my $dbg_src12b = 0;
my $dbg_src14 = 0;
my $dbg_src15 = 0;
my $dbg_src16 = 0;
my $dbg_src2 = 0;
my $dbg_src3 = 0;
my $dbg_src4 = 0;
my $dbg_src5 = 0;
my $dbg_src6 = 0;
my $dbg_src7 = 0;
my $dbg_src8 = 0;
my $dbg_src9 = 0;
my $dbg_srcc = 0;
my $dbg_srcv = 0;
my $dbg_x01 = 0;
my $dbg_x02 = 0;
my $dbg_x03 = 0;
my $dbg_x04 = 0;
my $dgb_x05 = 0;
my $dbg_x06 = 0;
my $dbg_x07 = 0;
my $dbg_x08 = 0;
my $dbg_x11 = 0;
my $dbg_x12 = 0;
my $dbg_x13 = 0;
my $dbg_x14 = 0;
my $dbg_x15 = 0;
my $dbg_x16 = 0;
my $dbg_x17 = 0;
my $dbg_x20 = 0;
my $dbg_x21 = 0;
my $dbg_x22 = 0;
my $dgb_src17 = 0;
my $dbg_src18 = 0;

my $dsp_runtime_dbg = '';
my $dsp_runtime_rel = '';
my $dsp_includes_dbg = '';
my $dsp_includes_rel = '';
my $dsp_defines_dbg = '';
my $dsp_defines_rel = '';
my $dsp_libs_dbg = '';
my $dsp_libs_rel = '';
my $dsp_output_dbg = '';
my $dsp_output_rel = '';
my $dsp_inter_dbg = '';
my $dsp_inter_rel = '';
my $dsp_post_dbg = '';
my $dsp_post_rel = '';

my $def_include_dirs_dbg = '';
my $def_include_dirs_rel = '';
my $def_runtime_dbg = '';
my $def_runtime_rel = '';
my $def_defines_dbg = '';
my $def_defines_rel = '';
my $def_libs_rel = '';
my $def_libs_dbg = '';
my $def_post_dbg = '';
my $def_post_rel = '';
my $def_output_dbg = '';
my $def_output_rel = '';
my $def_inter_dbg = '';
my $def_inter_rel = '';

my @v6_srcs = ();
my %v6_defs = ();
my %v6_conf = ();

my $excl_mark = '';
my $tot_vclines = 0;

##############################################################
# common 'reserved' words for config files
# for neatness only, make them all equal length
my $prjname   = 'projname';
my $ap_type   = 'app_type';
my $runtime   = 'runtime_';
my $platform  = 'platform';
my $linkout   = 'link_out';
my $includes  = 'inc_path';
my $libraries = 'add_libs';
my $libpath   = 'lib_path';
my $defines   = 'defines_';
my $outputs   = 'outputs_';
my $out_dir   = 'out__dir';
my $int_dir   = 'interout';
my $depends   = 'depends_';
my $filter    = 'filter__';
my $srcfiles  = 'src_file';
my $excfiles  = 'exc_file';
# 27/09/2008
my $postevt   = 'postbld_';
my $postdesc  = 'postdesc';
my $postcmds  = 'postcmds';
##############################################################

my %v8_apptypes = ();
my %v8_aptype = ();
my %v8_config = ();
my %v8_depend = ();
my %v8_filter = ();
my %v8_includ = ();
my %v8_libdep = ();
my %v8_link = ();
my %v8_linkout = ();
my %v8_postbuild = ();
my %v8_runtim = ();
my @v8_srcs = ();
my @xml_tag_map = ();
my @xml_lines = ();
my @xml_line_map = ();
my $xml_last_line = '';

my $app_console = 'Console Application';
my $app_windows = 'Application';
my $app_dynalib = 'Dynamic-Link Library';
my $app_statlib = 'Static Library';
my $app_utility  = 'Utility';

# per <Configuration ... ConfigurationType="4" ...
my %v8_conftypes = (
    1  => $app_windows,
    2  => $app_dynalib,
    4  => $app_statlib,
    10 => $app_utility );
# and if 1 ($app_windows), then per SubSystem
# <Tool Name="VCLinkerTool" ... SubSystem="2"
# SubSystem="1" = :console or "2" = :window
my %v8_subsystems = (
    1 => $app_console,
    2 => $app_windows );

# and if that FAILS, then try to decode PreprocessorDefintiions
# maybe _WINDOWS => 'Application'
# but then Alu.vcproj only has -
# PreprocessorDefinitions="NDEBUG;WIN32;AL_BUILD_LIBRARY"
# so this is NOT sure ...
my %v8_defines = (
    '_CONSOLE' => $app_console,
    '_USRDLL'  => $app_dynalib,
    '_LIB'     => $app_statlib );
my $typelse = $app_windows;
my @special_typing = qw( libpng zlib visualc6 );	# make these STATIC LIBRARIES

my %dsp_appheader = (
    $app_console => \&get_dsp_head_console,  # = 'Console Application';
    $app_windows => \&get_dsp_head_app,      # = 'Application';
    $app_dynalib => \&get_dsp_head_dynalib,  # = 'Dynamic-Link Library';
    $app_statlib => \&get_dsp_head_slib      # = 'Static Library';
);

use constant {
    RT_NAM => 0,
    RT_LTS => 1,
    RT_STG => 2,
    RT_VAL => 3,
    RT_RES => 4
};

my $def_runtime_lts = "MD";
my $def_runtime_stg = "Multithreaded DLL";
my $def_runtime_val = 2;
#    0                  1     2                         3  4
my @runtimes_array = (
    ["RuntimeLibrary", "MT",  "Multithreaded",           0, 0],
    ["RuntimeLibrary", "MTd", "Multithreaded Debug",     1, 0],
    ["RuntimeLibrary", $def_runtime_lts, $def_runtime_stg, $def_runtime_val, 0],
    ["RuntimeLibrary", "MDd", "Multithreaded DLL Debug", 3, 0],
    ["RuntimeLibrary", "ML",  "Single Thread",           4, 0],
    ["RuntimeLibrary", "MLd", "Single Thread Debug",     5, 0]
);

my $v8_cfgexp = '<Configuration\\s+.*Name=\\"(\\S+)\\"\\s';
my $v8_toolexp = '<Tool\\s+.?\\s*Name=\\"(\\S+)\\"\\s';
my $v8_prepexp = '\\s+PreprocessorDefinitions=\\"(\\S+)\\"';

use constant {
    GRP_UNK => 0,
    GRP_SRC => 1,
    GRP_HDR => 2,    # also include extensionless files, maybe ...
    GRP_RCS => 3,
    GRP_SPL => 4    # special items
};
my $def_src_g = "cpp;c;cxx;rc;def;r;odl;idl;hpj;bat;for;f90";
my $def_hdr_g = "h;hpp;hxx;hm;inl;fi;fd";
my $def_rcs_g = "ico;cur;bmp;dlg;rc2;rct;bin;cnt;rtf;gif;jpg;jpeg;jpe";
my $def_spl_g = "txt;vc5;h-msvc8;asm";

my $def_src_nm = "Source Files";    # Begin Group "Source Files"
my $def_hdr_nm = "Header Files";	# Begin Group "Header Files"
my $def_rcs_nm = "Resource Files";	# Begin Group "Resource Files"
my $def_spl_nm = "Special Files";
my $def_unknown = "Unknown";

my @dsp_base_defs_rel = qw( WIN32 NDEBUG _WINDOWS _MBCS );
my @dsp_base_defs_dbg = qw( WIN32 _DEBUG _WINDOWS _MBCS );
my @dsp_base_libs_rel = qw( kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib 
advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib );
my @dsp_base_libs_dbg = qw( kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib 
advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib );

##########################################
### for generate_DSP()
##                  [0]   [1]   [2]       [3]       [4] [5]  [6]        [7]
##                  relnm full  group      filter   cmp done project    grp
##	push(@v8_srcs, [$src, $ff, $filtname, $filttype, 0,  0,  $projname, shr] );
use constant {
    V8_SRC => 0,
    V8_FUL => 1,
    V8_GRP => 2,
    V8_FIL => 3,
    V8_CMP => 4,
    V8_DON => 5,
    V8_PRJ => 6,
    V8_SHR => 7,
    V8_EXC => 8
};

my $act_key = '';
my $write_real_files = 0;
my @dsp_written = ();
my @dsp_list = ();
my $use_std_groups = 0;
my $add_blank_groups = 0;

my $dsp_out_dbg = '';
my $dsp_out_rel = '';

my $def_out_dbg = 'Debug';
my $def_out_rel = 'Release';

my %dsp_substitions = (
    "-NEW_PROJECT_NAME-" => \$act_key,
    "-NEW_RT_REL-"       => \$dsp_runtime_rel,
    "-NEW_RT_DBG-"       => \$dsp_runtime_dbg,
    "-NEW_DEFS_REL-"     => \$dsp_defines_rel,
    "-NEW_DEFS_DBG-"     => \$dsp_defines_dbg,
    "-NEW_LIBS_DBG-"     => \$dsp_libs_dbg,
    "-NEW_LIBS_REL-"     => \$dsp_libs_rel,
    "-NEW_POST_DBG-"     => \$dsp_post_dbg,
    "-NEW_POST_REL-"     => \$dsp_post_rel,
    "-NEW_INCS_DBG-"     => \$dsp_includes_dbg,
    "-NEW_INCS_REL-"     => \$dsp_includes_rel,
    "-NEW_OUTD_DBG-"     => \$dsp_output_dbg,
    "-NEW_OUTD_REL-"     => \$dsp_output_rel,
    "-NEW_INTER_DBG-"    => \$dsp_inter_dbg,
    "-NEW_INTER_REL-"    => \$dsp_inter_rel,
    "-NEW_OUT_DBG-"      => \$dsp_out_dbg,
    "-NEW_OUT_REL-"      => \$dsp_out_rel
);

my $dbg_d10 = 0;
my $dbg_d11 = 0;
my $dbg_d11a = 0;
my $dbg_d11b = 0;
my $dbg_d12 = 0;
my $dbg_d13 = 0;
my $dbg_d14 = 0;
my $dbg_d15 = 0;

my $in_file = 'FlightGear\FlightGear.vcproj';
my $out_file = 'tempdsp.dsp';

my @warnings = ();

### *** OLD way *** ###

fg_clear_proj_files();
get_xml_sources($in_file);
generate_DSP("FlightGear", $out_file, $out_file, $out_file ); 

### *** OR NEW WAY *** ###

my %h = process_VCPROJ( $in_file );
###show_hash_results(0,\%h);
write_hash_to_DSP('tempvcscan.dsp', \%h, 8);

show_warnings();

close_log($outfile,1);
exit(0);


######################################

sub get_group_type {
    my ($src) = shift;
    my ($n,$d,$s) = fileparse($src, qr/\.[^.]*/ );
    my (@arr, $ext, $ex);
    $ex = substr($s,1) if ($s =~ /^\./);
    $ex = lc($ex);
    if (length($ex) == 0) {
        return GRP_HDR; # default to header is NO EXT
    }

    @arr = split(';', $def_src_g);
    foreach $ext (@arr) {
        if ($ext eq $ex) {
            return GRP_SRC;
        }
    }

    @arr = split(';', $def_hdr_g);
    foreach $ext (@arr) {
        if ($ext eq $ex) {
            return GRP_HDR;
        }
    }

    @arr = split(';', $def_rcs_g);
    foreach $ext (@arr) {
        if ($ext eq $ex) {
            return GRP_RCS;
        }
    }

    @arr = split(';', $def_spl_g);
    foreach $ext (@arr) {
        if ($ext eq $ex) {
            return GRP_SPL;
        }
    }

    prt( "CHECK EXTENSION: What group [$src], with ext [$s] or [$ex] ...\n" );
    return GRP_UNK; # not found, so UNKNOWN
}

# @arr = split_conf( $dsp_defines_dbg );
sub split_conf {
	my ($cc) = shift;
	my $ln = length($cc);
	my @ar = ();
	my $itm = '';
	for (my $p = 0; $p < $ln; $p++) {
		my $ch = substr($cc,$p,1);
		if ($ch eq '"') {
			$p++;
			$itm = '';
			for (; $p < $ln; $p++) {
				$ch = substr($cc,$p,1);
				if ($ch eq '"') {
					last;
				}
				$itm .= $ch;
			}
			push(@ar,$itm) if length($itm);
		}
	}
	return @ar;
}

sub is_in_skip_conf_rel {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_defs_rel) {
		if ($itm eq $tst) {
			return 1;
		}
	}
	return 0;
}
sub is_in_skip_conf_dbg {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_defs_dbg) {
		if ($itm eq $tst) {
			return 1;
		}
	}
	return 0;
}

sub is_in_skip_lib_rel {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_libs_rel) {
		if ($itm =~ /$tst/i) {
			return 1;
		}
	}
	return 0;
}
sub is_in_skip_lib_dbg {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_libs_dbg) {
		if ($itm =~ /$tst/i) {
			return 1;
		}
	}
	return 0;
}

sub set_runtime_dbg { $dsp_runtime_dbg = shift; }
sub set_runtime_rel { $dsp_runtime_rel = shift; }
# new 21/09/2008
sub set_includes {
    my ($txt, $ref) = @_;
    my @av = split(/[,;]/, $txt);
    foreach my $tx (@av) {
        if (length($tx)) {
            $$ref .= ' ' if length($$ref);
            # remove any existing quotes, but add quotes for sure
            $$ref .= '/I '.add_quotes(strip_quotes($tx));
        }
    }
}
sub set_includes_dbg {
    my ($txt) = shift;
    set_includes( $txt, \$dsp_includes_dbg );
}
sub set_includes_rel {
    my ($txt) = shift;
    set_includes( $txt, \$dsp_includes_rel );
}

# RUNTIME conversions
# #################################################
sub fg_get_runtime_val_2_lts_COPY {
	my ($rtn) = shift;
    my $len = scalar @runtimes_array;
    for (my $i = 0; $i < $len; $i++) {
        my $itm = $runtimes_array[$i][RT_VAL];  # [3];
        if ($itm == $rtn) {
            return "/" . $runtimes_array[$i][RT_LTS];   # [1];
        }
    }
    prtw( "WARNING: $rtn not found in runtimes_array! Using default '/$def_runtime_lts'!!\n" );
	return "/$def_runtime_lts";
}

# 24/09/2008 - convert letters to human string
sub fg_get_runtime_lts_2_stg {
	my ($rtn) = shift;
    my $len = scalar @runtimes_array;
    $rtn =~ s/^\///;    # remove any leading '/' ...
    for (my $i = 0; $i < $len; $i++) {
        my $itm = $runtimes_array[$i][RT_LTS];  # [1];
        if ($itm eq $rtn) {
            return $runtimes_array[$i][RT_STG]; # [2];
        }
    }
    prtw( "WARNING: [$rtn] not found in runtimes_array! Using default '$def_runtime_stg'!!\n" );
	return $def_runtime_stg;
}

sub fg_get_runtime_stg_2_val {
	my ($rtn) = shift;
    my $len = scalar @runtimes_array;
    for (my $i = 0; $i < $len; $i++) {
        my $itm = $runtimes_array[$i][RT_STG];
        if ($itm eq $rtn) {
            return $runtimes_array[$i][RT_VAL];
        }
    }
    prtw( "WARNING: [$rtn] not found in runtimes_array! Using default $def_runtime_val\n" );
	return $def_runtime_val;
}

sub fg_get_runtime_stg_2_lts {
	my ($rtn) = shift;
    my $len = scalar @runtimes_array;
    for (my $i = 0; $i < $len; $i++) {
        my $itm = $runtimes_array[$i][RT_STG];
        if ($itm eq $rtn) {
            return '/'.$runtimes_array[$i][RT_LTS];
        }
    }
    prtw( "WARNING: [$rtn] not found in runtimes_array! Using default /$def_runtime_lts\n" );
	return "/$def_runtime_lts";
}
# #################################################


# get application type
# one of Console Application, Application, static library, dynamic library
# get application type
# one of Console Application, Application, static library, dynamic library
sub fg_get_app_type {
	my ($defs, $ln) = @_;
	my ($def, $key);
	my @arr = split(';',$defs);
	foreach $def (@arr) {
		foreach $key (keys %v8_defines) {
			if ($def eq $key) {
				return $v8_defines{$key};
			}
		}
	}
	# ok, nothing found - TRY HARDER
	foreach $def (@arr) {
		if ($def =~ /BUILD_LIBRARY/) {
			return $v8_defines{'_LIB'};
		} elsif ($def =~ /STATIC/) {
			return $v8_defines{'_LIB'};
		}
	}
	# UGH - still NOT FOUND - provide overrides for
	foreach $def (@special_typing) {
		if ($act_vcproj =~ /$def/) {
            if ($dbg_x02) {
                prtw( "WARNING: String [$defs] no clue to TYPE!!!\n".
                    "Typed from special_typing list!\n".
                    "$ln: $act_vcproj - return static library ??? CHECK ME\n" );
            }
			return $v8_defines{'_LIB'};
		}
	}
	prtw( "WARNING: String [$defs] does not give clue to TYPE!!!\n$ln: $act_vcproj - return def $typelse ??? CHECK ME\n" );
	return $typelse;
}


sub get_tag_typ {
	my ($xt) = shift;
	my $typ = $TYP_OPEN;
	if ($xt =~ /^\//) {
		$typ = $TYP_CLOSE;
	} elsif ($xt =~ /\/$/) {
		$typ = $TYP_OPENCLOSE;
	} elsif ($xt eq '?xml') {
		$typ = $TYP_VERSION;
	}
	###prt( "For [$xt] returning [$typ] ...\n" );
	return $typ;
}

sub get_xml_tag {
	my ($lin) = shift;
	my $len = length($lin);
	my $tag = '';
	my $pch = '';
	for (my $t = 0; $t < $len; $t++) {
		my $ch = substr($lin,$t,1);
		if ($ch eq '<') {
			prtw( "WARNING: Second TAG in line! ($lin)\n" ) if (length($tag));
			$tag = '';
			$t++;
			for ( ; $t < $len; $t++) {
				$ch = substr($lin,$t,1);
				if ($ch =~ /\s/) {
					# end of tag
					$t++;
					for ( ; $t < $len; $t++) {
						$ch = substr($lin,$t,1);
						if ($ch eq '>') {
							$tag .= $pch if ($pch eq '/');
							prtw( "WARNING: Premature CLOSE! ($lin)(1)\n" ) if (($t +1) < $len);
							last;	# end of TAG
						}
						$pch = $ch;	# keep last
					}
					last;
				} elsif ($ch eq '>') {
					prtw( "WARNING: Premature CLOSE! ($lin)(2)\n" ) if (($t +1) < $len);
					last;
				}
				$tag .= $ch;
			}
		}
	}
	return $tag;
}

sub get_mapped_lines {
    my ($nln) = shift;
    my $max = scalar @xml_line_map;
    my $n = $xml_last_line;
    my $nn;
    for (; $n < $max; $n++) {
        $nn = $xml_line_map[$n][0]; # extract new line number
        if ($nln == $nn) {
            $xml_last_line = $n;
            my $res = "$nln:".$xml_line_map[$n][1].":".$xml_line_map[$n][2];
            ### prt( "Found [$nln] == [$nn] - return $res\n" );
            return $res;
        } elsif ($nn > $nln) {
            $xml_last_line = $n;
            my $res = "$nln:".$xml_line_map[$n][1].":".$xml_line_map[$n][2];
            ### prt( "Found [$nln] > [$nn] - return $res\n" );
            return $res;
        }
    }
    return "$nln:?:?";
}

sub fg_reline_xml {
    my (@lns) = @_;
    my $intag = 0;
    my $text = '';
    my @nlines = ();
    my @tagmap = ();
    my @xlnmap = ();
    my ($fln, $ln, $ch, $pch, $nch, $len, $i, $i2, $tag, $xml, $dnx);
    my ($lnnm, $lnb, $nlnm);
    $pch = '';
    $nch = '';
    $tag = '';
    $xml = '';
    $dnx = 0;
    $lnnm = 0;
    $nlnm = 0;
    $lnb = 0;
    foreach $fln (@lns) {
        chomp $fln;
        $ln = trim_all($fln);
        $len = length($ln);
        $lnnm++;    # count another xml line
        for ($i = 0; $i < $len; $i++) {
            $i2 = $i + 1;
            $ch = substr($ln,$i,1);
            $nch = (($i2 < $len) ? substr($ln,$i2,1) : ' ');
            if ($intag) {
                # on first SPACE
                if ( !$dnx && (($ch eq ' ')||($ch eq "\t")||($ch =~ /\s/)) ) {
                    $dnx = 1;
                    $xml = substr($tag,1);
                    if ($xml =~ /^\?/) {
                        push(@tagmap, [$xml, TT_DEC, 1]);
                    } elsif ($xml =~ /^\//) {
                        $xml = substr($xml,1);
                        push(@tagmap, [$xml, TT_END, 1]);
                    } else {
                        push(@tagmap, [$xml, TT_BGN, 1]);
                    }
                }
                $tag .= $ch;
                if ($ch eq '>') {
                    # end of XML tag
                    if (!$dnx) {
                        $xml = substr($tag,1,length($tag)-2);
                        if ($xml =~ /^\?/) {
                            push(@tagmap, [$xml, TT_DEC, 2]);
                        } elsif ($xml =~ /^\//) {
                            $xml = substr($xml,1);
                            push(@tagmap, [$xml, TT_END, 2]);
                        } elsif ($pch eq '/') {
                            push(@tagmap, [$xml, TT_BE, 2]);
                        } else {
                            push(@tagmap, [$xml, TT_BGN, 2]);
                        }
                    } else {
                        if ($pch eq '/') {
                            $tagmap[-1][1] = TT_BE;
                        }
                    }
                    $nlnm++;
                    push(@nlines,$tag);
                    ### prt( "push(\@xlnmap, [ $nlnm, $lnb, $lnnm ]); # each NEW line has BEGIN and END\n" );
                    push(@xlnmap, [ $nlnm, $lnb, $lnnm ]); # each NEW line has BEGIN and END
                    $tag = '';
                    $intag = 0;
                    $xml = '';
                }
            } else {
                if ($ch eq '<') {
                    $tag = $ch; # start a tag line
                    $intag = 1; # signal in a tag
                    $xml = '';
                    $dnx = 0;
                    $lnb = $lnnm;    # set the BEGIN xml line
                }
            }
            $pch = $ch;
        }
        # done a line - this is like a SPACE
        if ($intag && length($tag)) {
            if ( !$dnx ) {
                $dnx = 1;
                $xml = substr($tag,1);
                if ($xml =~ /^\?/) {
                    push(@tagmap, [$xml, TT_DEC, 3]);
                } elsif ($xml =~ /^\//) {
                    $xml = substr($xml,1);
                    push(@tagmap, [$xml, TT_END, 3]);
                } else {
                    push(@tagmap, [$xml, TT_BGN, 3]);
                }
            }
            $tag .= ' ' if !($tag =~ /\s$/);
        }
    }
    if (length($tag)) {
        prtw("WARNING: xml re-lining error! Left pending tag [$tag]\nin $act_vcproj file ...\n");
    }

    # store global tag map, lines, and a line map
    @xml_tag_map = @tagmap;
    @xml_lines = @nlines;
    @xml_line_map = @xlnmap;
    $xml_last_line = 0;
    if ($dbg_x01) {
        $ln = 0;
        $tag = '';
        foreach $xml (@nlines) {
            $ln++;
            $tag .= "$ln: $xml\n";
        }
        write2file( $tag, 'tempxml.txt');
        #write2file( join("\n",@nlines), 'tempxml.txt');
        $len = scalar @tagmap;
        $ln = '';
        for ($i = 0; $i < $len; $i++) {
            $tag = $tagmap[$i][0];
            $ch = $tagmap[$i][1];
            $nch = $tagmap[$i][2];
            $pch = get_tt_string($ch);
            $ln .= "$tag $pch ($ch) [$nch]\n";
        }
        write2file( $ln, 'tempxml2.txt' );
    }
    return @nlines;
}

# search forward in the XML line array
# assumed to be already arranged in neat XML lines
# and if 'ExcludedFromBuild' found in FileConfiguration
sub exclude_from_build {
    my ($j) = shift;
    my $max = scalar @xml_lines;
    for ( ; $j < $max; $j++) {
        my $ln = trim_all( $xml_lines[$j] );
		my $xt = get_xml_tag($ln);
        prt( "DEBUG:$j: line=[$ln], tag=[$xt]\n" ) if ($dgb_x05);
        my %ah = array_2_hash_on_equals(space_split($ln));
        if (($xt eq 'File') && ( defined $ah{'RelativePath'} ) ) {
            # good START
            $j++;   # got to NEXT line, and go until </File>
            $ln = trim_all( $xml_lines[$j] );
    		$xt = get_xml_tag($ln);
            if ($ln =~ /<\/File>/) {
                prt( "DEBUG:$j:LAST: line=[$ln], tag=[$xt]\n" ) if ($dgb_x05);
                last;
            }
            %ah = array_2_hash_on_equals(space_split($ln));
            if ($ln =~ /<FileConfiguration/) {
                my $cfg = "unknown";
                if (defined $ah{'Name'}) {
                    $cfg = $ah{'Name'};
                }
                if (defined $ah{'ExcludedFromBuild'}) {
                    my $res = strip_quotes(trim_all($ah{'ExcludedFromBuild'}));
                    if ($res eq 'true') {
                        prt( "DEBUG:$j:true: cfg=$cfg, line=[$ln], tag=[$xt]\n" ) if ($dgb_x05);
                        return 1;
                    } else {
                        prt( "DEBUG:$j:false: cfg=$cfg, line=[$ln], tag=[$xt]\n" ) if ($dgb_x05);
                        return 0;
                    }
                }
            }
            prt( "DEBUG:$j: line=[$ln], tag=[$xt]\n" ) if ($dgb_x05);
        } else {
            last;
            prtw( "WARNING: Failed to get <File RelativePath>\n" );
            mydie( "FIX ME FIRST!\n" );
        }
    }
    return 0;
}

# get_xml_source
# process the XML project file (*.vcproj) and
# extract the SOURCE file list,
# but do lots MORE than that ...
sub get_xml_sources {
	my ($in) = shift;
	my ($in_name,$in_fd,$in_suffix) = fileparse($in);
	my ($src, $ff, $pline);
	my $stf = '<File\\s+RelativePath=\\"([\\.\\\\\\w-]+)+\\"+(.)+';
	#my $filt = '^<Filter\\s+Name=\\"([\\w\\s]+)\\"\\s+Filter=\\"([\\w;]+)\\"';
	my @lines = ();
	my $line = '';
	my $filtname = '';
	my $filttype = '';
	my $conf = '';
	my $tname = '';
	my $version = 'Unknown';
	my $projname = '';
	my $srccount = 0;
	my @xmltags = ();
	my $xmltag = '';
	my $tagtyp = 0;
	my $lnnum = 0;
	my $nlnnum = 0;
	my $bgn = 0;
	my $end = 0;
	my $ll = 0;
	my $ch = '';
	my $bgnend = '';
	my $inconfigs = 0;
	my $ppdefs = '';
	my $apptype = '';   # one of the various types
	my $adddeps = '';
	my @attribs = ();
	my %atthash = ();
	my $ctype = 0;
	my $def = '';
	my ($func, $itm, $ffnr, $shr, $tmpsrc);
    my $dnaptype = 0;
    my $gottoolname = 0;
    my ($funcinc, $pname, $ProjectGUID, $ckey);
    my ($i, $j, $msg, $tmpdbg);
    my $infiles = 0;    # in the <Files> section of the XML
    my $cfgcount = 0;   # each file will have multiple 'configurations', and some things are global
    ### SET ACTIVE PROJECT FILE ###
    $act_vcproj = $in;
	prt( "\nLoading [$in] file in directory [$in_fd] ...\n" ) if ($dbg_x17);
	open FH, "<$in" or mydie( "ERROR: Can not open [$in] ... aborting ...\n" );
	@lines = <FH>; # slurp the whole file
	close( FH );
	my $fline = '';
    my $lncnt = scalar @lines;
	prt( "Processing VCPROJ $lncnt lines in $in ...\n" );
    $tot_vclines += $lncnt;
	my $hadver = 0;
    my $hadlibtool = 0;
    @lines = fg_reline_xml(@lines);
    $lncnt = scalar @lines;
    if ($lncnt != scalar @xml_tag_map) {
        prtw( "WARNING: xml lines $lncnt NOT SAME AS xml_tag_map ".scalar @xml_tag_map." CHECK THIS!\n" );
    }
	###foreach $line (@lines) {
    for ($i = 0; $i < $lncnt; $i++) {
        $line = $lines[$i];
        $nlnnum++;  # bump the array line number
		$lnnum = get_mapped_lines($nlnnum);
		$line = trim_all($line);
		$ll = length($line);
		if ($ll) {
			if (length($fline)) {
				$fline .= ' '.$line;
			} else {
				$ch = substr($line,0,1);
				$fline .= $line;
				if ($ch eq '<') {
					$bgn = $lnnum;  # set the BEGIN line number
				}
			}
		} else {
			next;   # skip BLANK lines
		}
        # only get interested when the XML closes ...
		if ($fline =~ />/) {
			$bgnend = "$bgn-$lnnum";
			$bgn = -1;
			$xmltag = get_xml_tag($fline);
			$tagtyp = get_tag_typ($xmltag);
			prt( "$bgnend: $xmltag ".tag_typ_2_stg($tagtyp). " ($tagtyp)\n" ) if ($dbg_src9);
			@attribs = space_split($fline);
			%atthash = array_2_hash_on_equals(@attribs);
            if ($dbg_x08) {
                $ll = 0;
                prt( "dbg_x08: Showing _ALL_ for tag=[$xmltag], line=[$fline]\n" );
                foreach $ppdefs (sort @attribs) {
                    $ll++;
                    prt( "dbg_x08:ats:$ll: [$ppdefs]\n" );
                }
                $ctype = 0;
                foreach $ppdefs (sort keys %atthash) {
                    $ctype++;
                    prt( "dbg_x08:key:$ctype: [$ppdefs] = [".$atthash{$ppdefs}."]\n" );
                }
                if ($ll != $ctype) {
                    mydir( "DEAD IN THE WATER! Array size $ll not same as hash $ctype!!!\n" );
                }
            }

            $pname = '';
            if (defined $atthash{'Name'}) {
                $pname = strip_quotes(trim_all($atthash{'Name'}));
                prt( "tag=$xmltag, Name=$pname (ln=$lnnum)\n" ) if ($dbg_x04);
            }
			if ((defined $atthash{'<VisualStudioProject'}) || ($fline =~ /<VisualStudioProject\s+/)) {
                $version = '';
                $ProjectGUID = '';
                if (defined $atthash{'Version'}) {
                    $version = strip_quotes(trim_all($atthash{'Version'}));
                    $hadver = 1;
				}
                if (defined $atthash{'ProjectGUID'}) {
                    $ProjectGUID = strip_quotes(trim_all($atthash{'ProjectGUID'}));
                }
				$projname = $pname;
				##prt( "$fline\n" );
				prt( "Project=$projname, v=$version GUID=$ProjectGUID\n" ) if ($dbg_src11);
                mydie( "BIG PROBLEM! project name is blank!!\n" ) if (length($projname) == 0);
			} elsif ($fline =~ /$stf/) {
				# <File RelativePath="src\FDM\SP\ACMS.cxx" >
				$src = $1;
                $act_file = $src;
				$ff = $in_fd . $src;
				$ffnr = fix_rel_path($ff);
				$itm = "MISSING";
                if (exclude_from_build($i)) {
                    $itm = $excl_mark; # "EXCLUDED";
                } elsif (-f $ffnr) {
					$itm = "ok";
					prt( "SRC: [$ffnr] $itm\n" ) if ($dbg_src16);
				} else {
                    if (is_c_source($src) || $dbg_src16) {
        				prt( "SRC: [$ffnr] $itm [$src][$ff] CHECKME!\n" );	# always SHOW MISSING if ($dbg_src16);
                    }
				}
                $act_disp = $itm;   # can be 'MISSED', 'EXCLUDED', or 'ok'
                if (is_c_source($src)) {
					prt("SOURCE=[$src]\n") if ($dbg_src1);
				} elsif (is_h_source($src)) {
					prt("HEADER=[$src]\n") if ($dbg_src2);
				} elsif (is_h_special($src)) {
					prt("HEADER=[$src]\n") if ($dbg_src2);
				} else {
					prt("OTHER=[$src]\n") if ($dbg_src3);
				}
				$srccount++;
                $shr = get_group_type($src);
				prt( "$srccount v8_srcs: $src, $ffnr, $filtname, $filttype, 0, 0, $projname);\n" ) if ($dbg11);
				#                0    1      2          3          4  5  6          7     8
				push(@v8_srcs, [$src, $ffnr, $filtname, $filttype, 0, 0, $projname, $shr, $itm] );
			} elsif ((defined $atthash{'<Filter'})||($fline =~ /<Filter\s+/)) {
				# <Filter Name="Source Files" Filter="cpp;c;cxx;rc;def;r;odl;idl;hpj;bat">
				$filtname = ''; # = NO FILTER NAME, like Source Files
				$filttype = ''; # = NOR FILTER TYPE, like cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
                if (defined $atthash{'Name'} ) {
                    $filtname = strip_quotes(trim_all($atthash{'Name'}));
                } elsif ($fline =~ /\s+Name=\"([\w\s]+)\"[\s>]+/) {
					$filtname = $1; # = Source Files
				}
                if (defined $atthash{'Filter'} ) {
                    $filttype = strip_quotes(trim_all($atthash{'Filter'}));
                } elsif ($fline =~ /\s+Filter=\"([\w;,]+)\"[\s>]+/) {
					$filttype = $1; # = cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
				}
                if ( length($filtname) && length($filttype) ) {
                    if ( defined $v8_filter{$filtname} ) {
                        $v8_filter{$filtname} = merge_filters($v8_filter{$filtname}, $filttype); 
                    } else {
                        $v8_filter{$filtname} = $filttype;
                    }
                }
				prt("FILTNAME=[$filtname] [$filttype]\n") if ($dbg_src4);
			###} elsif ($fline =~ /$v8_cfgexp/ ) {
            } elsif ($fline =~ /<Configuration\s+(.+)$/) {
				##if ($fline =~ /<Configuration\s+.*Name=\"(\S+)\"\s/ )
                # <Configuration
                #  Name="LIB Release|Win32"
                #  OutputDirectory=".\Win32_LIB_Release"
                #  IntermediateDirectory=".\Win32_LIB_Release"
                #  ConfigurationType="4"
                #  InheritedPropertySheets="$(VCInstallDir)VCProjectDefaults\UpgradeFromVC60.vsprops"
                #  UseOfMFC="0"
                #  ATLMinimizesCRunTimeLibraryUsage="false">
				#@attribs = space_split($fline);
				#%atthash = array_2_hash_on_equals(@attribs);
                if (length($pname)) {
                    $conf = $pname;
                } elsif (defined $atthash{'Name'} ) {
                    $adddeps = strip_quotes(trim_all($atthash{'Name'}));
                    $conf = $adddeps;
                } else {
                    mydie("ERROR: No 'Name' found in [$fline] - def to [$conf] CHECK THIS! In $act_vcproj!\n");
                }
                $ctype = 0;
                $def = '<UNKNOWN-CHECK-ME>';
                # the name can be 'Name="LIB Release|Win32"', as in libpng ...
                ###if ($conf =~ /^Debug\|/) { this is TOO restrictive, try
                # -NEW_INCS_[REL|DBG]-
                if ($conf =~ /Debug/i) {
                    $ctype = 1;
                    $def = $dsp_runtime_dbg;
                    $func = \&set_runtime_dbg;
                    $funcinc = \&set_includes_dbg;  # { $dsp_includes_dbg = shift; }
                } elsif ($conf =~ /Release/i) {
                    ###} elsif ($conf =~ /^Release\|/) { too restrictive
                    $ctype = 2;
                    $def = $dsp_runtime_rel;
                    $func = \&set_runtime_rel;
                    $funcinc = \&set_includes_rel;  # { $dsp_includes_rel = shift; }
                } else {
                    prtw( "WARNING: CHECK ME CONF: Not Debug or Release ... WHAT IS IT? [$conf] ASSUME RELEASE,\n".
                        "line=[$fline] ... \n".
                        "(ln=$lnnum) $act_vcproj!\n" );
                    $ctype = 2;
                    $def = $dsp_runtime_rel;
                    $func = \&set_runtime_rel;
                    $funcinc = \&set_includes_rel;  # { $dsp_includes_rel = shift; }
                }
                # my %v8_config = ();  #  by configuration, OutputDirectory=".\Release", IntermediateDirectory="Release",
                # and zlib = ConfigurationType="4", alut = ConfigurationType="2", fg = ConfigurationType="1"
                #  // This is an internal type to Visual Studio, it seems that:
                #  // 4 == static library
                #  // 2 == dll
                #  // 1 == executable
                #  // 10 == utility
                if (defined $atthash{'ConfigurationType'}) {
                    $adddeps = strip_quotes(trim_all($atthash{'ConfigurationType'}));
                    if (defined $v8_conftypes{$adddeps}) {
                        $apptype = $v8_conftypes{$adddeps};
                        $dnaptype = 1;  # signal, no need to try to parse defines
                    }
                }

                # 28/09/2008 - note, has quotes added
                # $dsp_output_dbg = $def_output_dbg;    # "-NEW_OUTD_DBG-" $out_dir
                # $dsp_output_rel = $def_output_rel;    # "-NEW_OUTD_REL-" $out_dir
                # $dsp_inter_dbg  = $def_inter_dbg;    # "-NEW_INTER_DBG-" $int_dir
                # $dsp_inter_rel  = $def_inter_rel;    # "-NEW_INTER_REL-" $int_dir
                $adddeps = '';
                if (defined $atthash{'OutputDirectory'}) {
                    $adddeps .= "$out_dir=".add_quotes(strip_dotrel(strip_quotes(trim_all($atthash{'OutputDirectory'}))));
                }
                if (defined $atthash{'IntermediateDirectory'}) {
                    $adddeps .= ' ' if length($adddeps);
                    $adddeps .= "$int_dir=".add_quotes(strip_dotrel(strip_quotes(trim_all($atthash{'IntermediateDirectory'}))));
                }
                if (defined $v8_config{$conf}) {
                    if (length($adddeps)) {
                        if ($v8_config{$conf} ne $adddeps) {
                            prtw("WARNING: conf $conf ALREADY in v8_config as ".$v8_config{$conf}."! Adding $adddeps!! (ln=$lnnum)\n" );
                        }
                    }
                } else {
                    $v8_config{$conf} = $adddeps;
                }
                $cfgcount++;
				prt( "Got configuration [$conf] [$projname] [$apptype] (ln=$lnnum, cnt=$cfgcount)\n" ) if ($dbg_src6);
			} elsif ($fline =~ /<Tool\s+(.*)$/ ) {
				#} elsif ($fline =~ /$v8_toolexp/ ) {
				$pline = $1;
				#@attribs = space_split($fline);
				#%atthash = array_2_hash_on_equals(@attribs);
                $gottoolname = 0;
                if (length($pname)) {
                    $tname = $pname;
                    $gottoolname = 1;
                } elsif (defined $atthash{'Name'}) {
                    $tname = strip_quotes(trim_all($atthash{'Name'}));
                    $gottoolname = 1;
                }
				#prt( "Got Tool $pline\n" ) if ($dbg_src7);
				if ($gottoolname || ($pline =~ /\s*Name=\"*(\w+)\"*/)) {
                    if (!$gottoolname) {
    					$tname = $1;
                    }
					prt( "Got Tool name $tname ...\n" ) if ($dbg_src7);
					if ($tname eq 'VCCLCompilerTool') {
						# <Tool
						# Name="VCCLCompilerTool"
						# Optimization="0"
						# AdditionalIncludeDirectories="../lib,../lib/curl_transport,...
						# PreprocessorDefinitions="_DEBUG;WIN32;_LIB;ABYSS_WIN32;CURL_STATICLIB" 
						# MinimalRebuild="true" 
						# BasicRuntimeChecks="3" 
						# RuntimeLibrary="1" 
						# PrecompiledHeaderFile=".\Debug\xmlrpccpp/xmlrpccpp.pch" 
						# AssemblerListingLocation=".\Debug\xmlrpccpp/" 
						# ObjectFile=".\Debug\xmlrpccpp/" 
						# ProgramDataBaseFileName=".\Debug\xmlrpccpp/" 
						# WarningLevel="3" 
						# SuppressStartupBanner="true" 
						# DebugInformationFormat="4" />]
						prt( "Is compiler tool ...[$fline] ... $conf ($ctype)\n" ) if ($dbg_src14);
						## @attribs = space_split($fline);
						## %atthash = array_2_hash_on_equals(@attribs);
                        # set the PREPROCESSOR defines
                        ###########################################################
                        $ppdefs = "";   # maybe NONE
                        if ( defined $atthash{'PreprocessorDefinitions'} ) {
                            $ppdefs = strip_quotes(trim_all($atthash{'PreprocessorDefinitions'}));
                            if ($inconfigs) {
                                # try to GUESS application type from this string - UGH
                                $adddeps = fg_get_app_type($ppdefs, $lnnum);
                                if (! $dnaptype || (length($apptype) == 0)) {
                                    prt( "Set APPTYPE:$conf: [$apptype] to [$adddeps] (ln=$lnnum)\n" ) if ($dbg_src8);
                                    $apptype = $adddeps;
                                }
                                prt( "Set DEFINES:$conf: [$ppdefs] $apptype ($ctype) (ln=$lnnum)\n" ) if ($dbg_src8);
                                ###$v8_link{$conf} = $ppdefs;
                                if (defined $v8_aptype{$conf}) {
                                    if ($v8_aptype{$conf} ne $apptype) {
                                        prtw( "WARNING: ALREADY HAVE [$conf] in v8_aptype, with [".$v8_aptype{$conf}."] which is NOT [$apptype]!!! (ln=$lnnum) $act_vcproj\n" );
                                    }
                                } else {
                                    prt( "Set APPTYPE:$conf: v8_aptype[$apptype] (ln=$lnnum)\n" ) if ($dbg_x15);
                                    $v8_aptype{$conf} = $apptype;
                                }

                                if (defined $v8_apptypes{$projname}) {
                                    if ($v8_apptypes{$projname} ne $apptype) {
                                        if ($cfgcount < 2) {
                                            # unexpected ...
                                            prtw( "WARNING: ALREADY HAVE [$projname]  in v8_apptypes with [".$v8_apptypes{$projname}."] which is NOT [$apptype]!!! (ln=$lnnum) $act_vcproj\n" );
                                            # but is expected if running 2nd or subsequent configurations
                                            # so no warning ...
                                        }
                                    }
                                } else {
                                    prt( "Set APPTYPE: in v8_apptypes[$projname] to [$apptype] (ln=$lnnum)\n" ) if ($dbg_src8);
                                    $v8_apptypes{$projname} = $apptype;
                                }
                                $v8_link{$conf} = $ppdefs;  # set it PREPROCESSOR DEFINES ...
                            } elsif (length($ppdefs)) {
                                prtw( "WARNING: Got DEFS: $conf [$1] OUTSIDE Configurations! (ln=$lnnum) $act_vcproj\n" ); # if ($dbg_src10);
                            }
                        } else {
                            if ($inconfigs) {
                                prtw( "WARNING: Got NO 'PreprocessorDefinitions' for $conf - $act_vcproj!\n" );
                            }
                        }
                        ############################################################

						if ( defined $atthash{'RuntimeLibrary'} ) {
                            if ($inconfigs) {
                                $ppdefs = strip_quotes(trim_all($atthash{'RuntimeLibrary'}));
                                ###$itm = get_runtime_stg($ppdefs);
                                $itm = fg_get_runtime_val_2_lts($ppdefs);
                                if (($ctype == 1)||($ctype == 2)) {
                                    if ($itm eq $def) {
                                        prt( "Got RUNTIME:$conf: value [$ppdefs] ($ctype) $itm (= $def)\n" ) if ($dgb_src17);
                                    } else {
                                        $func->($itm);
                                        prt( "Set RUNTIME:$conf: value [$ppdefs] ($ctype) $itm (was $def)\n" ) if ($dgb_src17);
                                    }
                                } else {
                                    prtw( "WARNING:CHECKME:$conf: RUNTIME value [$ppdefs] ($ctype) $itm ($def) in $act_vcproj\n" );
                                }
                                if (defined $v8_runtim{$conf}) {
                                    if ($v8_runtim{$conf} ne $itm) {
                                        prtw( "WARNING: AREADY HAVE RUNTIME $conf of ".$v8_runtim{$conf}." versus $itm!! $act_vcproj\n" );
                                    }
                                } else {
                                    $v8_runtim{$conf} = $itm; # RUNTIME /MT or /MD, by configuration
                                }
                            } else {
                                prtw( "WARNING: Unhandled 'RuntimeLibrary' for $conf, $act_vcproj\n$lnnum: $fline\n$lnnum: $pline!\n" );
                            }
						} else {
                            if ($inconfigs) {
                                prtw( "WARNING: Did NOT find 'RuntimeLibrary' for $conf in configs, $act_vcproj\n$lnnum: $fline\n$lnnum: $pline!\n" );
                            }
                        }

                        ##################################################################
                        ### set AdditionalIncludeDirectories - VERY IMPORTANT
                        ### push(@allarr, "$includes=[$cincs]"); -NEW_INCS_[DBG|REL]-
                        $ppdefs = '';
						if ( defined $atthash{'AdditionalIncludeDirectories'} ) {
                            $ppdefs = strip_quotes(trim_all($atthash{'AdditionalIncludeDirectories'}));
                            $ppdefs =~ s/&quot;/"/g;
                            if ($inconfigs) {
                                $funcinc->($ppdefs);
                                prt("Set INCLUDES:$conf: to [$ppdefs]\n" ) if ($dbg_x14);
                                $v8_includ{$conf} = $ppdefs;
                            } else {
                                if (length($ppdefs)) {
                                    if (($act_disp ne 'EXCLUDED')||($dbg_x07)) {
                                        prtw("WARNING: Got 'AdditionalIncludeDirectories' = $ppdefs, outside configs unhandled!\n".
                                            "$conf $act_file $act_disp $act_vcproj [$fline]!!\n" );
                                    }
                                }
                            }
                        } else {
                            if ($inconfigs) {
                                $v8_includ{$conf} = $ppdefs;    # set NONE
                            }
                        }
                        ##################################################################
						prt( "Done VCCLCompilerTool atthash for $conf ...\n" )  if ($dbg_src15);
					} elsif ($tname eq 'VCLinkerTool') {
                        # this SUGGESTS an application or DLL, per ??? value
                        # SubSystem="1" - :console or "2" :window
						# <Tool
						# Name="VCLinkerTool"
						# AdditionalDependencies="comctl32.lib Msimg32.lib Winmm.lib"
						# LinkIncremental="1"
						# GenerateDebugInformation="true"
						# SubSystem="2"
						# OptimizeReferences="2"
						# EnableCOMDATFolding="2"
						# TargetMachine="1"
						# />
						prt( "Is linker tool ...[$fline]\n" ) if ($dbg_src7);
						## @attribs = space_split($fline);
						## %atthash = array_2_hash_on_equals(@attribs);
						if ($dbg_src12a) {	# DEBUG ONLY
							prt( "Split of attribs [$fline] ...\n" );
							foreach $adddeps (@attribs) {
								prt( " $adddeps\n" );
							}
							prt( "Show of HASH ...\n" );
							foreach $adddeps (keys %atthash) {
								prt( " $adddeps = ".$atthash{$adddeps}."\n" );
							}
						}
                        ##################################################################
                        $adddeps = '';
						if (defined $atthash{'AdditionalDependencies'} ) {
							$adddeps = strip_quotes(trim_all($atthash{'AdditionalDependencies'}));
							prt( "Set LINKLIB:$conf: [$adddeps]\n" ) if ($dbg_src12);
						}
						$v8_depend{$conf} = $adddeps;
                        ##################################################################
                        $adddeps = '';  # see also $dbg_d15
                        if (defined $atthash{'AdditionalLibraryDirectories'}) {
							$adddeps = strip_quotes(trim_all($atthash{'AdditionalLibraryDirectories'}));
							prt( "Set LNKDIRS:$conf: [$adddeps]\n" ) if ($dbg_src12b);
                        } else {
							prt( "Set LNKDIRS:$conf: [<NULL>]\n" ) if ($dbg_src12b);
                        }
						$v8_libdep{$conf} = $adddeps;
                        ##################################################################
                        # my %v8_linkout = (); # Name="VCLinkerTool" OutputFile=".\Release\FlightGear.exe", by configuration
                        # $dsp_out_[dbg|rel} = $def_out_[dbg|rel] = "-NEW_OUT_[DBG|REL]"
                        # = $outputs = $v8_linkout{$conf} = push(@allarr, "$linkout=[$lout]");
                        $adddeps = '';
                        if (defined $atthash{'OutputFile'}) {
							$adddeps = strip_quotes(trim_all($atthash{'OutputFile'}));
                        }
                        $v8_linkout{$conf} = $adddeps;
                        ##################################################################
                        $adddeps = '';
                        if (defined $atthash{'SubSystem'}) {
							$adddeps = strip_quotes(trim_all($atthash{'SubSystem'}));
                            # this should decide the $apptype
                            # $v8_aptype{$conf} = $apptype;
                            # $v8_apptypes{$projname} = $apptype;
                            if (defined $v8_subsystems{$adddeps}) {
                                $ppdefs = $v8_subsystems{$adddeps};
                                if ($apptype eq $ppdefs) {
                                    prt("Got APPTYPE:$conf: NO CHANGE [$apptype] equals SubSystem ($adddeps) [".$v8_subsystems{$adddeps}."] ...(ln=$lnnum)\n" ) if ($dbg_x16);
                                } else {
                                    if ($apptype eq $app_dynalib) {
                                        if ($ppdefs eq $app_windows) {
                                            # these are NOT incompatible, so NO CHANGE
                                            prt("Got APPTYPE:$conf: NO CHANGE [$apptype] EQUIVALENT to $ppdefs ($adddeps) ...(ln=$lnnum)\n" ) if ($dbg_x16);
                                        } else {
                                            prtw("WARNING: NO CHANGE :$conf: but [$apptype] NOT EQUIVALENT to $ppdefs ($adddeps) ...(ln=$lnnum)\n" );
                                        }
                                    } else {
                                        prt("Set APPTYPE:$conf: from $apptype, to $ppdefs - CHECK! (ln=$lnnum)\n" ) if ($dbg_x15);
                                        $apptype = $ppdefs;
                                    }
                                    if (! defined $v8_aptype{$conf}) {
                                        prtw("HEY! $conf NOT already set in v8_aptype - CHECK ORDER OF DECODE! (ln=$lnnum) $act_vcproj\n" );
                                    }
                                    $v8_aptype{$conf} = $apptype;
                                    if (! defined $v8_apptypes{$projname}) {
                                        prtw("HEY! $projname NOT already set in v8_apptypes - CHECK ORDER OF DECODE! (ln=$lnnum) $act_vcproj\n" );
                                    } else {
                                        prt( "Set APPTYPE: in v8_apptypes[$projname] to [$apptype] (ln=$lnnum)\n" ) if ($dbg_x15);
                                    }
                                    $v8_apptypes{$projname} = $apptype;
                                }
                            } else {
                                prtw( "WARNING: Got SubSystem='$adddeps', NOT in v8_subsystems! CHECK IT OUT!!! (ln=$lnnum) $act_vcproj: $fline\n" );
                                ### $tmpdbg = $dbg_x10;
                                ### $dbg_x10 = 1;
                                ### @attribs = space_split($fline);
                                ### %atthash = array_2_hash_on_equals(@attribs);
                                ### $adddeps = $atthash{'SubSystem'};
                                ### prt( "2nd run got $adddeps ...\n");
                                ### $dbg_x10 = $tmpdbg;
                            }
                        }
                        ##################################################################
                    } elsif ($tname eq 'VCLibrarianTool') {
                        # <Tool
                        #  Name="VCLibrarianTool"
                        #  OutputFile="Win32_LIB_Debug\libpngd.lib"
                        #  SuppressStartupBanner="true" />
                        $hadlibtool = 1;
                        $ppdefs = '';
						if ( defined $atthash{'OutputFile'} ) {
							$ppdefs = strip_quotes(trim_all($atthash{'OutputFile'}));
                        }
                        $v8_linkout{$conf} = $ppdefs;
                        prt( "Set 'VCLibrarianTool' v8_linkout[$conf] to [$ppdefs] $act_vcproj\n" ) if ($dbg_x20);
                        ######################################################################
                        $adddeps = '';
                        if (defined $v8_aptype{$conf}) {
                            $adddeps = $v8_aptype{$conf};
                        }
                        if ($adddeps ne $app_statlib) {
                            prtw( "VCLibrarianTool:$conf: This suggests a STATIC LIBRARY ...out=$ppdefs\n".
                                "but v8_aptype[$conf] HAS [".$v8_aptype{$conf}."] CHECK FOR CHANGE!! (ln=$lnnum) $act_vcproj\n" );
                        } else {
                            prt( "VCLibrarianTool:$conf Suggests STATIC LIBRARY - out=$ppdefs".
                                " - and that is what we have in v8_aptype...\n" ) if ($dbg_x11);
                        }
                        if (! defined $v8_depend{$conf} ) {
    						$v8_depend{$conf} = "";
                        }
                        if (! defined $v8_libdep{$conf} ) {
    						$v8_libdep{$conf} = "";
                        }
                    } elsif ($tname eq 'VCPostBuildEventTool') {
                        # <Tool
                        #  Name="VCPostBuildEventTool"
                        #  Description="Copy Library to plib directory"
                        #  CommandLine="copy debug\*.lib ..\..\*.*&#x0D;&#x0A;copy ul.h ..\..\ul.h&#x0D;&#x0A;copy ulRTTI.h ..\..\ulRTTI.h&#x0D;&#x0A;"
                        #  />
                        # this will be output to the DSP, under the paticular, config, something like
                        # # Begin Special Build Tool
                        # SOURCE="$(InputPath)"
                        # PostBuild_Desc=Copy to bin
                        # PostBuild_Cmds=copy Release\*exe bin\.	copy test.h bin\.
                        # # End Special Build Tool
                        $ppdefs = '';
                        if (( defined $atthash{'Description'} ) || ( defined $atthash{'CommandLine'} ) ) {
                            $ppdefs = "$postdesc="; # to 'PostBuild_Desc=';
                            if ( defined $atthash{'Description'} ) {
                                $ppdefs .= add_quotes(strip_quotes(trim_all($atthash{'Description'})));
                            }
                            $ppdefs .= " $postcmds="; # to ' PostBuild_Cmds=';
                            if ( defined $atthash{'CommandLine'} ) {
                                $adddeps = strip_quotes(trim_all($atthash{'CommandLine'}));
                                $adddeps =~ s/&#x0D;&#x0A;/\t/g;
                                $adddeps =~ s/\t$//;
                                $ppdefs .= add_quotes($adddeps);
                            }
                        }
                        $v8_postbuild{$conf} = $ppdefs; # later, added under $postevt
					}
				} else {
					prtw( "WARNING: FAILED Name [$fline] in $act_vcproj!\n" );
				}
			} elsif ($fline =~ /<\/Filter>/) {
				$filtname = ''; # = NO FILTER NAME, like Source Files
				$filttype = ''; # = NOR FILTER TYPE, like cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
			} elsif ($fline =~ /<Platforms/) {
				# 8-8: LINE=[<Platforms>]
			} elsif ($fline =~ /<Platform/) {
				# 9-11: LINE=[<Platform Name="Win32" />]
			} elsif ($fline =~ /<ToolFiles/) {
				# 13-13: LINE=[<ToolFiles>]
			} elsif ($fline =~ /<Configurations>/) {
				# 15-15: LINE=[<Configurations>]
				$inconfigs = 1;
				prt( "$lnnum: Enter Configurations ... ($fline)\n" ) if ($dbg_src10);
			} elsif ($fline =~ /<\/Configurations>/) {
				# LINE=[</Configurations>]
				$inconfigs = 0;
				prt( "$lnnum: Exit Configurations ... ($fline)\n" ) if ($dbg_src10);
            } elsif ($fline =~ /<\/Configuration>/) {
                $dnaptype = 0;
			} elsif ($fline =~ /<References/) {
				# 167-167: LINE=[<References>]
			} elsif ($fline =~ /<Files/) {
				# 169-169: LINE=[<Files>]
                $infiles = 1;
				prt( "$lnnum: Enter Files ... ($fline)\n" ) if ($dbg_x06);
			} elsif ($fline =~ /<\/Files/) {
				# 169-169: LINE=[<Files>]
                $infiles = 0;
				prt( "$lnnum: Exit Files ... ($fline)\n" ) if ($dbg_x06);
                $act_file = '';
                $act_disp = '';
			} elsif ($fline =~ /<FileConfiguration/) {
				# 177-179: LINE=[<FileConfiguration Name="Debug|Win32" >]
			} elsif ($fline =~ /<Globals/) {
				# 591-591: LINE=[<Globals>]
			} else {
				if ($tagtyp == $TYP_VERSION) {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_srcv);
				} elsif ($tagtyp == $TYP_CLOSE) {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_srcc);
				} else {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_src5);
				}
			}
			if ($tagtyp == $TYP_OPEN) {
				push(@xmltags,$xmltag);
			} elsif ($tagtyp == $TYP_CLOSE) {
				if (@xmltags) {
					my $tmptag = pop @xmltags;
					$xmltag = substr($xmltag,1);
					if ($tmptag ne $xmltag) {
						prtw( "WARNING: Closing TAG [$xmltag] not last [$tmptag]! $bgnend\n" );
					}
					if ($xmltag eq 'Configurations') {
						$inconfigs = 0;
						prt( "$lnnum: Exit Configurations ... ($fline)\n" ) if ($dbg_src10);
					}
				} else {
					prtw( "WARNING: CLOSE TAG NOT OPEN! [$fline]\n" );
				}
			}
			$fline = '';
		}
	}

    ###sub post_get_xml_lines {

	###prt( "Project: $projname, as $apptype\n" ); # eg 'Project: gshhs, as Console Application'
	my (@att2, @disc, @arr, $mask, $cdefs, $rtime, $cincs, $libdirs, @allarr);
    # COLLECT the information obtained
    # collect andd add to %v6_all under key $mask
    # The $mask is "$projname|$conf|$rtime"
    # $projname from XML line =~ /<VisualStudioProject\s+/ Name=
    # $conf is the key to each of the hashes
    # $rtime from $v8_runtim{$conf}
    # %v8_depend - gives $libraries=[$cdefs]
    # %v8_link - gives $defines=[$cdefs] (poorly names hash!)
    # %v8_includ - gives $includes=[$cincs]
    # %v8_libdep - gives $libpath=[$libdirs]
	foreach $conf (keys %v8_depend) {
		$ctype = 0;
		if ($conf =~ /Debug/i) {
			$ctype = 1;
			$func = \&is_in_skip_lib_dbg;
		} elsif ($conf =~ /Release/i) {
			$ctype = 2;
			$func = \&is_in_skip_lib_rel;
		} else {
			$func = \&is_in_skip_lib_rel;
            $ctype = 2;
            prtw( "WARNING: NOT Debug or Release - WHAT IS IT? [$conf]! Using Release\n" );
		}

        if (defined $v8_aptype{$conf}) {
            $apptype = $v8_aptype{$conf};
        } else {
            $apptype = $typelse;
            prtw( "WARNING: No application type in v8_aptype for $conf! Using default $apptype!!\n" );
        }
        if (defined $v8_runtim{$conf}) {
            $rtime = $v8_runtim{$conf};
        } else {
            if ($ctype == 1) {
                $rtime = $def_runtime_dbg;
            } else {
                $rtime = $def_runtime_rel;
            }
            prtw( "WARNING: No RUNTIME in v8_runtim for $conf! Using default $rtime!!\n" );
        }
        $rtime =~ s/^\///;
        $mask = "$projname|$conf|$rtime";  # start with project name and configuration
        # my %v6_all = ();    # all projects in this solution
        # key = projname|$conf eg FlightGear|Debug|Win32
        # value = string '$defines=[ list of defines ] $libraries=[ list of libraries ]

		$ppdefs = $v8_depend{$conf};
		@attribs = split(/ /,$ppdefs);
		@att2 = ();
		@disc = ();
		foreach $itm (@attribs) {
			if ( ! $func->($itm) ) {
				push(@att2,$itm);
			} else {
				push(@disc,$itm);
			}
		}

		prt( "\nLINK:Config: $conf=$ppdefs ... ".scalar @attribs." items\n" ) if ($dbg_src18);
		prt( "Reduced to ".scalar @att2." items ...Discarding [ @disc ], as already there...\n" ) if ($dbg_src18);
		if ($ctype == 1) {	# ($conf =~ /Debug/i)
			$def = $dsp_libs_dbg;
			@arr = split(/ /,$dsp_libs_dbg);
			@disc = ();
			prt( "Debug VERSION ... $conf ... [ @arr ]\n" ) if ($dbg_src18);
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_libs_dbg .= ' '.$itm;
				}
			}
			prt( "Changed $def (\$dsp_libs_dbg) ...\n") if ($dbg_src18);
			prt( "To      $dsp_libs_dbg, discarding [ @disc ], as already there ...\n" ) if ($dbg_src18);
            $cdefs = $dsp_libs_dbg;
		} elsif ($ctype == 2) {	# $conf =~ /Release/)
			$def = $dsp_libs_rel;
			@arr = split(/ /, $dsp_libs_rel );
			prt( "Release VERSION ... $conf ... @arr\n" ) if ($dbg_src18);
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_libs_rel .= ' '.$itm;
				}
			}
			prt( "Changed $def (\$dsp_libs_rel) ...\n" ) if ($dbg_src18);
			prt( "To      $dsp_libs_rel, discarding [ @disc ], as already there ...\n" ) if ($dbg_src18);
            $cdefs = $dsp_libs_rel;
		} else {
			prtw( "WARNING: CHECKME: VERSION NOT DEBUG OR RELEASE??? ... $conf ...\n" );
		}
        
        if ($ctype > 0) {
            if (defined $v6_all{$mask}) {
                prtw( "WARNING: $mask ALREADY IN v6_all!!! value=".$v6_all{$mask}."\n" );
            } else {
                $v6_all{$mask} = "$libraries=[$cdefs] ";
                prt( "v6_all: Adding [$mask] with $libraries=[$cdefs] ...\n" ) if ($dbg_x03);
            }
        }

        # add to v6_refall, as scalar for now
        $v6_refall{$mask} = "$libraries=[$cdefs]";
	}

	foreach $conf (keys %v8_link) {
		$ctype = 0;
		if ($conf =~ /Debug/i) {
			$ctype = 1;
			$func = \&is_in_skip_conf_dbg;
		} elsif ($conf =~ /Release/i) {
			$ctype = 2;
			$func = \&is_in_skip_conf_rel;
		} else {
            # default to RELEASE
			$func = \&is_in_skip_conf_rel;
            $ctype = 2;
			prtw( "WARNING: CHECKME: VERSION NOT DEBUG NOR RELEASE??? ... Got [$conf]! ASSUME RELEASE\n" );
		}
        if (defined $v8_aptype{$conf}) {
            $apptype = $v8_aptype{$conf};
        } else {
            $apptype = $typelse;
            prtw( "WARNING:$projname: No APPTYPE in v8_aptype for $conf! Using default [$apptype]!! $act_vcproj\n" );
        }
        if (defined $v8_runtim{$conf}) {
            $rtime = $v8_runtim{$conf};
        } else {
            if ($ctype == 1) {
                $rtime = $def_runtime_dbg;
            } else {
                $rtime = $def_runtime_rel;
            }
            prtw( "WARNING:$projname: No RUNTIME in v8_runtim for $conf! Using default [$rtime]!! $act_vcproj\n" );
        }

        # push(@allarr, "$includes=[$cincs]");
        if (defined $v8_includ{$conf}) {
            $cincs = $v8_includ{$conf};
        } else {
            if ($ctype == 1) {
                $cincs = $def_include_dirs_dbg;
            } else {
                $cincs = $def_include_dirs_rel;
            }
            prtw( "WARNING:$projname: No INCLUDES in v8_includ for $conf! Using default [$cincs]!! $act_vcproj\n" );
        }
        # could massage these $cincs, to REMOVE the MEANINGLESS (in windows) '.\', or do it later

        $rtime =~ s/^\///;
        $mask = "$projname|$conf|$rtime";  # start with project name and configuration

		$ppdefs = $v8_link{$conf};
		@attribs = split(/;/,$ppdefs);
		@att2 = ();
		@disc = ();
		foreach $itm (@attribs) {
			if ( ! $func->($itm) ) {
				push(@att2,$itm);
			} else {
				push(@disc,$itm);
			}
		}
		@arr = ();
		prt( "\nDEFS:Config: $conf=$ppdefs ... ".scalar @attribs." items\n" ) if ($dbg_src18);
		prt( "Reduced to ".scalar @att2." items ...Discarding [ @disc ], as already there...\n" ) if ($dbg_src18);
		if ($ctype == 1) {	# ($conf =~ /Debug/i)
			$def = $dsp_defines_dbg;
			@arr = split_conf( $dsp_defines_dbg );
			@disc = ();
			prt( "Debug VERSION ... $conf ... @arr\n" ) if ($dbg_src18);
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_defines_dbg .= ' /D "'.$itm.'"';
				}
			}
			prt( "Changed $def (\$dsp_defines_dbg) ...\n" ) if ($dbg_src18);
			prt( "To      $dsp_defines_dbg, discarding [ @disc ], as already there ...\n" ) if ($dbg_src18);
            $cdefs = $dsp_defines_dbg;
		} elsif ($ctype == 2) {	# $conf =~ /Release/i)
			$def = $dsp_defines_rel;
			@arr = split_conf( $dsp_defines_rel );
			prt( "Release VERSION ... $conf ... @arr\n" ) if ($dbg_src18);
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_defines_rel .= ' /D "'.$itm.'"';
				}
			}
			prt( "Changed $def (\$dsp_defines_rel) ...\n") if ($dbg_src18);
			prt( "To      $dsp_defines_rel, discarding [ @disc ], as already there ...\n" ) if ($dbg_src18);
            $cdefs = $dsp_defines_rel;
		}

        # vcproj = AdditionalLibraryDirectories
        $libdirs = '';
        if (defined $v8_libdep{$conf} ) {
            $libdirs = $v8_libdep{$conf};
        } else {
            prtw( "WARNING:$mask: v8_libdep does not contain conf $conf ...\n" );
        }


        # my %v8_config = ();  #  by configuration, OutputDirectory=".\Release", IntermediateDirectory="Release",
        # 28/09/2008 - note, has quotes added push(@allarr, "$outputs=[$outs]");
        # $dsp_output_dbg = $def_output_dbg;    # "-NEW_OUTD_DBG-" $out_dir
        # $dsp_output_rel = $def_output_rel;    # "-NEW_OUTD_REL-" $out_dir
        # $dsp_inter_dbg  = $def_inter_dbg;    # "-NEW_INTER_DBG-" $int_dir
        # $dsp_inter_rel  = $def_inter_rel;    # "-NEW_INTER_REL-" $int_dir
        my $outs = '';
        if (defined $v8_config{$conf}) {
            $outs = $v8_config{$conf};
            ###prtw( "SHOW OUTS = [$outs]\n" );
        }

        # $dsp_out_[dbg|rel} = $def_out_[dbg|rel] = "-NEW_OUT_[DBG|REL]"
        # = $outputs = $v8_linkout{$conf} = push(@allarr, "$linkout=[$lout]");
        my $lout = '';
        if (defined $v8_linkout{$conf}) {
            $lout = strip_dotrel($v8_linkout{$conf});
        }
        $msg = "$defines=[$cdefs] $includes=[$cincs] $libpath=[$libdirs] $outputs=[$outs] $linkout=[$lout]";

        if ($ctype > 0) {
            if (! defined $v6_all{$mask}) {
                prtw( "WARNING: $mask NOT already defined!!!\n" );
                $v6_all{$mask} = $msg;
            } else {
                $v6_all{$mask} .= $msg;
            }
        }
        my $post = '';
        if (defined $v8_postbuild{$conf}) {
            $post = $v8_postbuild{$conf};
        }

        @allarr = ();   # clear the array
        push(@allarr, $v6_refall{$mask});
        push(@allarr, "$defines=[$cdefs]");
        push(@allarr, "$includes=[$cincs]");
        push(@allarr, "$libpath=[$libdirs]");
        push(@allarr, "$outputs=[$outs]");
        push(@allarr, "$linkout=[$lout]");
        push(@allarr, "$postevt=[$post]");
        prt( "For mask [$mask], set linkout $linkout = [$lout] ...\n" ) if ($dbg_x21);
        prt( "For mask [$mask], set libpath $libpath = [$libdirs] ...\n" ) if ($dbg_x22);
        $v6_refall{$mask} = [@allarr];  # COPY the ARRAY to the HASH
	}

	my $new_srcs = scalar @v8_srcs;
	prt( "VCPROJ Project: $projname, as $apptype, version=$version\n" ) if ($dbg_x12); # eg 'Project: gshhs, as Console Application'
	prt( "Got new $new_srcs C/C++ files, header files, and others \n" ) if ($dbg_x12);
	prt( "Defined Debug = $dsp_defines_dbg, Release = $dsp_defines_rel\n" ) if ($dbg_x13);
	prt( "Library Debug = $dsp_libs_dbg, Release = $dsp_libs_rel\n" ) if ($dbg_x13);
}


sub fg_clear_proj_files {
	@v8_srcs = ();	    # start with NONE
	%v8_link = ();	    # PREPROCESSOR compiler definitions, by configuration
	%v8_depend = ();	# linker addtional dependencies, by configuration
    %v8_aptype = ();    # application type - console, static library, DLL, ...

	@v6_srcs = ();  # relnm full group filter
	%v6_defs = ();
	%v6_conf = ();

	# establish DEFAULT items for DSP generation
	# these can be altered by the XML decode
	$dsp_runtime_rel = $def_runtime_rel;
	$dsp_runtime_dbg = $def_runtime_dbg;
	$dsp_defines_dbg = $def_defines_dbg;
	$dsp_defines_rel = $def_defines_rel;
	$dsp_libs_rel = $def_libs_rel;
	$dsp_libs_dbg = $def_libs_dbg;

    # new items
    %v8_runtim = ();    # RUNTIME /MT /MD ...
    %v8_includ = ();    # INCLUDE DIRECTORIES for compiler
    ###%v8_filter = ();    # NO single list for whole solution - <Files><Filter Name="Source Files" ...
    %v8_libdep = (); # ADDITIONAL LIB DIRS, by configuration
    # new 22/09/2008
    %v8_config = ();  #  by configuration, OutputDirectory=".\Release", IntermediateDirectory="Release",
    # and zlib = ConfigurationType="4", alut = ConfigurationType="2", fg = ConfigurationType="1"
    %v8_linkout = (); # Name="VCLinkerTool" OutputFile=".\Release\FlightGear.exe", by configuration
    %v8_postbuild = (); # Name="VCPostBuildEventTool", with
    # Description="Copy Library to plib directory"
    # CommandLine="copy debug\*.lib ..\..\*.*&#x0D;&#x0A;copy ul.h ..\..\ul.h&#x0D;&#x0A;copy ulRTTI.h ..\..\ulRTTI.h&#x0D;&#x0A;"
    # the &#x0D;&#x0A; is replaced with a TAB (\t) in the DSP file
    @xml_tag_map = ();  # clear the xml_tag_map
    @xml_lines = ();    # neat xml lines from VCPRJ file
    $dsp_includes_dbg = $def_include_dirs_dbg;
    $dsp_includes_rel = $def_include_dirs_rel;
    $dsp_post_dbg = $def_post_dbg;
    $dsp_post_rel = $def_post_rel;
    # 28/09/2008
    $dsp_output_dbg = $def_output_dbg;    # "-NEW_OUTD_DBG-"
    $dsp_output_rel = $def_output_rel;    # "-NEW_OUTD_REL-"
    $dsp_inter_dbg  = $def_inter_dbg;    # "-NEW_INTER_DBG-"
    $dsp_inter_rel  = $def_inter_rel;    # "-NEW_INTER_REL-"
}


#########################################################################
### for writting DSP file

sub array_ref_2_array {
    my ($ref) = shift;
    my @narr = ();
    foreach (@{$ref}) {
        push(@narr,$_);
    }
    return @narr;
}

sub get_refall_groups {
    my @groups = ();
    my (@keys, $kcnt, $gnum);
    my ($k, $key, @ar, $pname, $cond, $pform, $rtim);
    my ($j, $ky, $pname2, $cond2);
    @keys = sort keys(%v6_refall);
    $kcnt = scalar @keys;
    $gnum = 0;
    for ($k = 0; $k < $kcnt; $k++) {
        $key = $keys[$k];
        @ar = split(/\|/,$key);
        $pname = $ar[0];
        $cond  = $ar[1];
        $pform = $ar[2];
        $rtim  = $ar[3];
        #              0      1       2     3      4       5
        push(@groups, [$gnum, $pname, $key, $cond, $pform, $rtim]);
        for ($j = $k + 1; $j < $kcnt; $j++) {
            $ky = $keys[$j];
            @ar = split(/\|/,$ky);
            $pname2 = $ar[0];
            $cond2  = $ar[1];
            if ($pname eq $pname2) {
                $k++;
                #              0      1       2    3       4       5
                push(@groups, [$gnum, $pname, $ky, $cond2, $ar[2], $ar[3]]);
            } else {
                last;
            }
        }
        $gnum++;
    }
    return $gnum,@groups;
}

sub get_refs_for_pname {
    my ($pn) = shift;
    my @refs = ();
    my ($key, $val, $cond, $pform, $rtim);
    my ($gnum, @groups);
    ($gnum, @groups) = get_refall_groups();
    my $kcnt = scalar @groups;
    for (my $k = 0; $k < $kcnt; $k++) {
        if ($pn eq $groups[$k][1]) {
            $gnum  = $groups[$k][0];
            $key   = $groups[$k][2];
            $cond  = $groups[$k][3];
            $pform = $groups[$k][4];
            $rtim  = $groups[$k][5];
            $val   = $v6_refall{$key};
            push(@refs, [$val, $cond, $pform, $rtim]);
        }
    }
    return @refs;
}

sub get_header {
    my ($apt) = shift;
    my $hdr = '';
    if (defined $dsp_appheader{$apt}) {
        my $func = $dsp_appheader{$apt};
        $hdr = $func->();
    } else {
        prtw( "WARNING: [$apt] NOT found in dsp_appheader! FOUND ONLY ...\n" );
        foreach $hdr (keys %dsp_appheader) {
            prt( "[$hdr] " );
        }
        prt("\n");
        mydie( "Aborting in disgust ;=))\n" );
    }
    return $hdr;
}


sub v8_aptype_consistent {
    my ($val, @keys, $ky, $cnt, $i, $apt);
    @keys = keys(%v8_aptype);
    $cnt = scalar @keys;
    $ky = $keys[0];
    $apt = $v8_aptype{$ky};
    for ($i = 1; $i < $cnt; $i++) {
        $ky = $keys[$i];
        $val = $v8_aptype{$ky};
        if ($val ne $apt) {
            prtw("WARNING: For $ky, application type [$val] NOT SAME as [$apt]!\n".
                "Aborting generation of this DSP file!!!\n" );
            return "";
        }
    }
    return $apt;
}

sub out_src {
	my ($sc,$of) = @_;
	print $of "# Begin Source File\n";
	print $of "\n";
	print $of "SOURCE=$sc\n";
	print $of "# End Source File\n";
}

sub fg_out_src {
	my ($sc,$of,$ex) = @_;
	print $of "# Begin Source File\n";
	print $of "\n";
	print $of "SOURCE=$sc\n";
    print $of "# PROP Exclude_From_Build 1\n" if ($ex eq $excl_mark);
	print $of "# End Source File\n";
}


sub generate_DSP {
	my ($key, $tof, $reald, $ffrdsp) = @_;
	my ($DSP, $cnt, $i, $src, $fnm, $ftyp, $rpt, $apt, $dmsg);
	my ($got_src, $got_hdr, $got_rc, $src_cnt, $non_cnt, $shr);
    my ($def_grp);
    my ($got_other, $msg, $tmp, $dspmsg);
    my (@groups, $gnum, $kcnt, $rcnt);
	my @fltnms = ();
    my @refs = ();    
	$got_src = 0;
	$got_hdr = 0;
	$got_rc = 0;
    $got_other = 0;
	$src_cnt = 0;
	$non_cnt = 0;
    $act_key = $key;

    $tof = $ffrdsp if ($write_real_files);
	$dspmsg = "Generate DSP file [$tof], for $key ...\n";
    $dspmsg .= "Real rel=[$reald] ... absolute=[$ffrdsp] ";
    if (-f $ffrdsp) {
        $dspmsg .= "REPLACE";
    } else {
        $dspmsg .= "NEW";
    }
    prt("$dspmsg\n");
    # it can be ONE OF
    # 'Console Application', 'Dynamic-Link Library', 'Static Library', or 'Application'
    $apt = 'Application';
    $dmsg = "DSP app type = ";
    $apt = v8_aptype_consistent();
    if (length($apt) == 0) {
        prtw("WARNING: Failed to get consistent app type ...\n" );
        return;
    }
    $dmsg .= $apt;
    $msg = get_header($apt);
    if ( !($msg =~ /^# Microsoft Developer Studio Project File/) ) {
        ptrw( "WARNING: $dmsg - FAILED TO GET DSP HEADER???\n".
            "No $tof generated!\n");
        return;
    }
    $kcnt = scalar keys(%v6_refall);
    ($gnum, @groups) = get_refall_groups();
    @refs = get_refs_for_pname( $key );
    $rcnt = scalar @refs;
    prt( "$dmsg\n" ); ### if ($dbg_d11 || $dbg_d10);
    prt( "For [$key], got $rcnt reference keys!\n" ) if ($dbg_d11 || $dbg_d11a);
    my ($val, $cond, $pform, $rtim, @arr, %hash, $ky, $cont, %h2, $sep);
    my ($ref1, $ref2, @ar2, $j);
    $sep = "\t=\t";
    # clear current post events, outputs, etc ... that are setup here
    $dsp_post_rel = $def_post_rel;  # $msg =~ s/-NEW_POST_REL-/$dsp_post_rel/gm;
    $dsp_post_dbg = $def_post_dbg;  # $msg =~ s/-NEW_POST_DBG-/$dsp_post_dbg/gm;
    $dsp_output_dbg = $def_output_dbg;    # "-NEW_OUTD_DBG-" $out_dir
    $dsp_output_rel = $def_output_rel;    # "-NEW_OUTD_REL-" $out_dir
    $dsp_inter_dbg  = $def_inter_dbg;    # "-NEW_INTER_DBG-" $int_dir
    $dsp_inter_rel  = $def_inter_rel;    # "-NEW_INTER_REL-" $int_dir
    $dsp_out_dbg = $def_out_dbg;    # "-NEW_OUT_DBG-"
    $dsp_out_rel = $def_out_rel;    # "-NEW_OUT_REL-"
    if ($dbg_d11a || $dbg_d11b) {
        for ($i = 0; $i < $rcnt; $i++) {
            $val   = $refs[$i][0];
            $cond  = $refs[$i][1];
            $pform = $refs[$i][2];
            $rtim  = $refs[$i][3];
            prt( "$i: $key|$pform|$cond|$rtim\n" );
        }
    }
    # my %v8_linkout = (); # Name="VCLinkerTool" OutputFile=".\Release\FlightGear.exe", by configuration
    # $dsp_out_[dbg|rel} = $def_out_[dbg|rel] = "-NEW_OUT_[DBG|REL]"
    # = $outputs = $v8_linkout{$conf} = push(@allarr, "$linkout=[$lout]");
    for ($i = 0; $i < $rcnt; $i++) {
        $val   = $refs[$i][0];
        $cond  = $refs[$i][1];
        $pform = $refs[$i][2];
        $rtim  = $refs[$i][3];
        prt( "$key|$pform|$cond|$rtim\n" ) if ($dbg_d11 || $dbg_d11a);
        @arr = array_ref_2_array($val);
        %hash = array_2_hash_on_equals(@arr);
        foreach $ky (keys %hash) {
            $cont = $hash{$ky};
            $cont =~ s/^\[//;
            $cont =~ s/\]$//;
            prt( "$ky=[$cont]\n" ) if ($dbg_d11);
            if ($ky eq $postevt) {
                if (length($cont)) {
                    # PostBuild_Desc=Copy to bin
                    # PostBuild_Cmds=copy Release\*exe bin\.	copy test.h bin\.
                    %h2 = array_2_hash_on_equals(space_split($cont));
                    $dmsg = '';
                    $dmsg .= "# Begin Special Build Tool\n";
                    $dmsg .= "SOURCE=\"\$(InputPath)\"\n";
                    $dmsg .= "PostBuild_Desc=";
                    if (defined $h2{$postdesc}) {
                       $dmsg .= strip_quotes($h2{$postdesc});
                    }
                    $dmsg .= "\n";
                    $dmsg .= "PostBuild_Cmds=";
                    if (defined $h2{$postcmds}) {
                        $tmp = strip_quotes($h2{$postcmds});
                        $tmp = massage_command($tmp);
                        $dmsg .= $tmp;
                    }
                    $dmsg .= "\n";
                    $dmsg .= "# End Special Build Tool\n";
                    $dmsg =~ s/&quot;/"/g;
                    if ($cond =~ /Debug/i) {
                        $dsp_post_dbg = $dmsg;  # $msg =~ s/-NEW_POST_DBG-/$dsp_post_dbg/gm;
                    } else {
                        $dsp_post_rel = $dmsg;  # $msg =~ s/-NEW_POST_REL-/$dsp_post_rel/gm;
                    }
                }
            } elsif ($ky eq $outputs) {
                # my %v8_config = ();  #  by configuration, OutputDirectory=".\Release", IntermediateDirectory="Release",
                # 28/09/2008 - note, has quotes added push(@allarr, "$outputs=[$outs]");
                # $dsp_output_dbg = $def_output_dbg;    # "-NEW_OUTD_DBG-" $out_dir
                # $dsp_output_rel = $def_output_rel;    # "-NEW_OUTD_REL-" $out_dir
                # $dsp_inter_dbg  = $def_inter_dbg;    # "-NEW_INTER_DBG-" $int_dir
                # $dsp_inter_rel  = $def_inter_rel;    # "-NEW_INTER_REL-" $int_dir
                if (length($cont)) {
                    %h2 = array_2_hash_on_equals(space_split($cont));
                    $dmsg = "Object OUPUT: $outputs]=[$cont]";
                    $ref1 = \$dsp_output_rel;
                    $ref2 = \$dsp_inter_rel;
                    if ($cond =~ /Debug/i) {
                        $ref1 = \$dsp_output_dbg;
                        $ref2 = \$dsp_inter_dbg;
                        $dmsg .= ' (DEBUG)';
                    }
                    if (defined $h2{$out_dir}) {
                        $$ref1 = $h2{$out_dir};
                        $dmsg .= ' ['.$$ref1.']';
                    }
                    if (defined $h2{$int_dir}) {
                        $$ref2 = $h2{$int_dir};
                        $dmsg .= ' ['.$$ref2.']';
                    }
                    prt( "$dmsg\n" ) if ($dbg_d14);
                }
            } elsif ($ky eq $linkout) {
                # my %v8_linkout = (); # Name="VCLinkerTool" OutputFile=".\Release\FlightGear.exe", by configuration
                # $dsp_out_[dbg|rel} = $def_out_[dbg|rel] = "-NEW_OUT_[DBG|REL]"
                # $v8_linkout{$conf} = push(@allarr, "$linkout=[$lout]");
                if (length($cont)) {
                    $dmsg = "Link OUPUT: $linkout=[$cont]";
                    $ref1 = \$dsp_out_rel;
                    if ($cond =~ /Debug/i) {
                        $ref1 = \$dsp_out_dbg;
                        $dmsg .= ' (DEBUG)';
                    }
                    $$ref1 .= ' ' if length($$ref1);
                    $$ref1 .= '/out:'.add_quotes($cont);
                    $dmsg .= ' '.$$ref1;
                    prt( "$dmsg\n" ) if ($dbg_d13);;
                }
            } elsif ($ky eq $libpath) {
                if (length($cont)) {
                    # AdditionalLibraryDirectories
                    # add like  /libpath:"testdll___Win32_Release" /libpath:"libs"
                    $dmsg = "Link LIBPATH: $cond libpaths=[$cont]";
                    $ref1 = \$dsp_out_rel;
                    if ($cond =~ /Debug/i) {
                        $ref1 = \$dsp_out_dbg;
                        $dmsg .= ' (DEBUG)';
                    }
                    @ar2 = split(/[;,]/,$cont);
                    $cnt = scalar @ar2;
                    for ($j = 0; $j < $cnt; $j++) {
                        $tmp = '/libpath:'.add_quotes(strip_quotes(trim_all($ar2[$j])));
                        $$ref1 .= ' ' if length($$ref1);
                        $$ref1 .= $tmp;
                        $dmsg .= ' '.$tmp;
                    }
                    prt( "$dmsg\n" ) if ($dbg_d15);
                } else {
                    prt( "Link LIBPATH: $cond libpaths=[<NULL>]\n" ) if ($dbg_d15);
                }
            }
        }   # foreach $key in the HASH
    }   # for EACH reference, per $i

    if ($dbg_d12 || $dbg_d10) {
        foreach $ky (keys %dsp_substitions) {
            $val = $dsp_substitions{$ky};
            $cont = $$val;
            prt( "s/$ky/[$cont]/gm\n" );
        }
        prt( "CHECK OUT THE REPLACEMENTS!\n" );
        ###close_log($outfile,1);
        ###exit(0);
    }
    rename_2_old_bak($tof);
	if (open $DSP, ">$tof") {
		push(@dsp_written, $dspmsg);
        push(@dsp_list, $ffrdsp);
		# perform SUBSTITUTIONS
        # ###############################################################################################
        foreach $ky (keys %dsp_substitions) {
            $val = $dsp_substitions{$ky};
            $cont = $$val;
            if ($msg =~ /$ky/) {
                # DO THE SUBSTITUTION(S)
                $msg =~ s/$ky/$cont/gm;
            } else {
                if (($ky =~ /-NEW_LIBS_(DBG|REL)-/)&&($apt eq 'Static Library')) {
                    # NO SUB REQUIRED, for this case
                } else {
                    prtw( "WARNING: Current template (for $apt) does NOT contain [$ky],\n so substitution of [$cont] FAILED!\n");
                }
            }
        }
        # ###############################################################################################
		print $DSP $msg;
		#                 0     1    2          3          4  5  6
		# push(@v8_srcs, [$src, $ff, $filtname, $filttype, 0, 0, $projname, 7] );
		$cnt = scalar @v8_srcs;
		for ($i = 0; $i < $cnt; $i++) {
			$v8_srcs[$i][V8_DON] = 0;   # [5] clear the DONE FLAG

            if ($use_std_groups) {  # subsequent thought that this is BAD IDEA!!!
                $src = $v8_srcs[$i][0];         # source file
                $fnm = $v8_srcs[$i][V8_GRP];    # [2] # GROUP NAME 'Source Files', etc ...
                $ftyp = $v8_srcs[$i][3];        # group filter, if any
                $shr = $v8_srcs[$i][V8_SHR];    # [7] get GROUP by extension
                $def_grp = get_def_group_name($shr);
                if ($def_grp =~ /^$def_unknown/) {
                    prt( "CHECK UNKNOWN: $shr for $src WHAT IS THIS???\n" );
                } else {
                    if (length($fnm) ) {
                        if ($fnm ne $def_grp) {
                            if (!is_rc_file($src)) {
                                prt( "CHECK CHANGE: Change from '$fnm' to '$def_grp' for $src ... [$ftyp] \n" );
                            }
                            $v8_srcs[$i][V8_GRP] = $def_grp;
                        }
                    } else {
                        $v8_srcs[$i][V8_GRP] = $def_grp;
                    }
                }
            }
		}

		$rpt = 1;	# set to BEGIN LOOP
		while ($rpt) {
			$rpt = 0;	# assume NO MORE
			for ($i = 0; $i < $cnt; $i++) {
				if ($v8_srcs[$i][V8_DON] == 0) {    # [5]
					$src = $v8_srcs[$i][0];
					$fnm = $v8_srcs[$i][V8_GRP];	# [2] GROUP NAME 'Source Files', etc ...
					$ftyp = $v8_srcs[$i][3];
					if ( length($fnm) && !is_in_array($fnm,@fltnms) ) {
						if ($fnm =~ /Source/i) {
							prt( "Outing GROUP $fnm ...\n" ) if (!$got_src);
							$got_src = 1;
						} elsif ($fnm =~ /Header/i) {
							prt( "Outing GROUP $fnm ...\n" ) if (!$got_hdr);
							$got_hdr = 1;
						} elsif ($fnm =~ /Resource/i) {
							prt( "Outing GROUP $fnm ...\n" ) if (!$got_rc);
							$got_rc = 1;
						} else {
							prt( "Outing GROUP $fnm ...\n" ) if (!$got_other);
							$got_other = 1;
                        }
						push(@fltnms,$fnm);	# add it to the DONE GROUP
						$v8_srcs[$i][V8_DON] = 1; # [5] SET AS DONE
						print $DSP '# Begin Group "'.$fnm."\"\n";
						print $DSP "\n";
						if (length$ftyp) {
							print $DSP '# PROP Default_Filter "'.$ftyp."\"\n";
						}

						fg_out_src($src,$DSP,$v8_srcs[$i][V8_EXC]);
						$src_cnt++;
						$i++;	# move to NEXT
						for (; $i < $cnt; $i++) {
							$src = $v8_srcs[$i][0];
							if ($v8_srcs[$i][V8_DON] == 0) {
								if ($fnm eq $v8_srcs[$i][2]) {
									fg_out_src($src,$DSP,$v8_srcs[$i][V8_EXC]);
									$src_cnt++;
									$v8_srcs[$i][V8_DON] = 1; # SET AS DONE
								}
							}
						}
						print $DSP "# End Group\n";
						$rpt = 1;	# try for some more
					}
				}
			}
		}

		# add any GROUPS not already DONE
        if ($add_blank_groups) {    # NOT A GOOD IDEA!!!
            if (!$got_src) {
                $fnm = "Source Files";
                $ftyp = $def_src_g; # = "cpp;c;cxx;rc;def;r;odl;idl;hpj;bat;for;f90"
                prt( "Outing GROUP $fnm ... BLANK\n" );
                print $DSP '# Begin Group "'.$fnm."\"\n";
                print $DSP "\n";
                print $DSP '# PROP Default_Filter "'.$ftyp."\"\n";
                print $DSP "# End Group\n";
            }
            if (!$got_hdr) {
                $fnm = "Header Files";
                $ftyp = $def_hdr_g; # = "h;hpp;hxx;hm;inl;fi;fd"
                prt( "Outing GROUP $fnm ... BLANK\n" );
                print $DSP '# Begin Group "'.$fnm."\"\n";
                print $DSP "\n";
                print $DSP '# PROP Default_Filter "'.$ftyp."\"\n";
                print $DSP "# End Group\n";
            }
            if (!$got_rc) {
                $fnm = "Resource Files";
                prt( "Outing GROUP $fnm ... BLANK\n" );
                $ftyp = $def_rcs_g; # = "ico;cur;bmp;dlg;rc2;rct;bin;cnt;rtf;gif;jpg;jpeg;jpe"
                print $DSP '# Begin Group "'.$fnm."\"\n";
                print $DSP "\n";
                print $DSP '# PROP Default_Filter "'.$ftyp."\"\n";
                print $DSP "# End Group\n";
            }
        }
		###################################
		# any NOT in a GROUP
		for ($i = 0; $i < $cnt; $i++) {
			if ($v8_srcs[$i][V8_DON] == 0) {
				$non_cnt++
			}
		}
		prt( "Outing any NOT IN GROUP, count $non_cnt ... $act_vcproj\n" ) if ($non_cnt);
		for ($i = 0; $i < $cnt; $i++) {
			if ($v8_srcs[$i][V8_DON] == 0) {
				$src = $v8_srcs[$i][0];
				out_src($src,$DSP,$v8_srcs[$i][V8_EXC]);
				$src_cnt++;
			}
		}

		$msg = get_dsp_tail();
		print $DSP $msg;
		close $DSP;
		prt( "Written temp [$tof] DSP file, with $src_cnt sources - (real=$reald)\n" );
	} else {
		prtw( "WARNING: Failed to create [$tof] ... $! ...\n" );
	}
}

#####################################
sub prtw {
    my ($tx) = shift;
    if ($tx =~ /\n$/) {
        prt($tx);
        $tx =~ s/\n$//;
    } else {
        prt("$tx\n");
    }
    push(@warnings,$tx);
}

sub show_warnings {
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS ...\n" );
        foreach my $line (@warnings) {
            prt("$line\n" );
        }
        prt("\n");
    } else {
        prt("\nNo warnings issued.\n\n");
    }
}

# eof - fgvc2dsp.pl

