#!/perl -w
# NAME: findnumber.pl
# AIM: Given a file to search, an da number to search for, see if the number exists on
# and line
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[.]*/] )
use Cwd;
unshift(@INC, 'C:\GTools\perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:\GTools\perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 1;
my $in_file = 'C:\Program Files\Microsoft SDKs\Windows\v6.1\include';
#my $in_file = 'C:\Program Files\Microsoft SDKs\Windows\v6.1\include\WinUser.h';
my $recursive = 0;

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;
my @found_lines = ();

# debug
my $dbg01 = 0;
my $dbg02 = 0;

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub num_in_range($) {
    my ($num) = @_;
    if (($num >= 147)&&($num <= 150)) {
        return 1;
    }
    return 0;
}

sub process_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Can NOT open file [$inf]!\n");
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    my ($line,$lnn,$num,$hex);
    $lnn = 0;
    prt("Processing $lncnt lines, from [$inf]...\n") if ($dbg02);
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        next if ($line =~ /^\s*#\s*if\s+/);
        next if ($line =~ /^\s*#\s*else\s+/);
        next if ($line =~ /^\s*#\s*endif\s+/);
        if ($line =~ /\s*0x([A-F\d]+)\s*/i) {
            $hex = $1;
            $num = hex($hex);
            if (num_in_range($num)) {
                prt("$lnn: Hex 0x[$hex] $num [$line]\n") if ($dbg01);
                push(@found_lines, [$inf,$line,$lnn]);
            }
        } elsif ($line =~ /\s+(\d+)\s*/) {
            $num = $1;
            $hex = sprintf("%x",$num);
            if (num_in_range($num)) {
                prt("$lnn: Number [$num] 0x[$hex] [$line]\n") if ($dbg01);
                push(@found_lines, [$inf,$line,$lnn]);
            }
        }
    }
}

sub process_dir($);
 
sub process_dir($) {
    my ($dir) = @_;
    if (! opendir(DIR,$dir)) {
        pgm_exit(1,"ERROR: Can NOT open directory [$dir]!\n");
    }
    my @files = readdir(DIR);
    closedir DIR;
    my $fcnt = scalar @files;
    prt("Got $fcnt items, from folder [$dir]...\n");
    my ($file,$ff);
    my @dirs = ();
    foreach $file (@files) {
        next if (($file eq '.')||($file eq '..'));
        $ff = $dir."\\".$file;
        if (-d $ff) {
            push(@dirs,$ff);
        } else {
            process_file($ff);
        }
    }
    if ($recursive) {
        foreach $file (@dirs) {
            process_dir($file);
        }
    }
}

sub show_found_lines($) {
    my ($ra) = @_;
    my $fcnt = scalar @{$ra};
    prt("\nGot $fcnt finds...\n");
    my ($i,$file,$line,$nfile,$lnn);
    $nfile = '';
    for ($i = 0; $i < $fcnt; $i++) {
        $file = ${$ra}[$i][0];
        $line = trim_all(${$ra}[$i][1]);
        $lnn = ${$ra}[$i][2];
        if ($file ne $nfile) {
            prt("File: $file\n");
            $nfile = $file;
        }
        prt("$lnn: [$line]\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
#prt( "$pgmname: in [$cwd]: Hello, World...\n" );
if (-f $in_file) {
    process_file($in_file);
} elsif (-d $in_file) {
    process_dir($in_file);
}
show_found_lines(\@found_lines);
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-05-05\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have follwoing argument!\n")
        if (!@av);
}
sub parse_args {
    my (@av) = @_;
    while (@av) {
        my $arg = $av[0];
        if ($arg =~ /-/) {
            my $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /-/);
            if (($sarg =~ /h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }
}

# eof - template.pl
