#!/usr/bin/perl -w
# NAME: fixfile.pl
# AIM: VERY SPECIFIC - Fix a file
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# fix
# %EXE% +units=us-ft +init=%INIT_FILE%:4902 -E -f '%%.3f' %INP% >>%OUT% <<EOF
# -108d01'56.720  41d51'57.518    309581.204    437731.262 WYEC GP2
#EOF
# to
# @echo -108d01'56.720  41d51'57.518    309581.204    437731.262 WYEC GP2 >%INP%
# %EXE% +units=us-ft +init=%INIT_FILE%:4902 -E -f '%%.3f' %INP% >>%OUT%
#

# user variables
my $load_log = 0;
my $in_file = "C:\\Projects\\proj.4\\proj-svn\\contrib\\msvc\\testIGNF.bat";
my $out_file = "C:\\Projects\\proj.4\\proj-svn\\contrib\\msvc\\tempIGNF.bat";
#my $in_file = "C:\\Projects\\proj.4\\proj-svn\\contrib\\msvc\\test83.bat";
#my $out_file = "C:\\Projects\\proj.4\\proj-svn\\contrib\\msvc\\temp83.bat";

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub trim_tail($) {
	my ($ln) = shift;
	$ln = substr($ln,0, length($ln) - 1) while ($ln =~ /\s$/); # remove all TRAILING space
	return $ln;
}


my $eol = 'EOF';
sub process_file($) {
    my ($inf) = @_;
    pgm_exit(1,"ERROR: Unable to OPEN [$inf]!\n") if (!open INF, "<$inf");
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($i,$line1,$line2,$line3,$i2,$i3,$chg);
    $chg = 0;
    for ($i = 0; $i < $lncnt; $i++) {
        $i2 = $i + 1;
        $i3 = $i + 2;
        $line1 = $lines[$i];
        chomp $line1;
        $lines[$i] = $line1;
        if ($i3 < $lncnt) {
            $line2 = $lines[$i2];
            $line3 = $lines[$i3];
            chomp $line2;
            chomp $line3;
            if (($line1 =~ /<<${eol}$/) && ($line3 =~ /^${eol}/)) {
                $chg++;
                prt("$chg:$i2: Found it...\n");
                $line3 = '';
                $line2 = "\@echo $line2 >\%INP\%";
                $line1 =~ s/<<${eol}$//;
                $lines[$i] = trim_tail($line2);
                $lines[$i2] = trim_tail($line1);
                $lines[$i3] = trim_tail($line3);
                $i += 2;
            }
        }
    }
    if ($chg) {
        write2file(join("\n",@lines)."\n",$out_file);
        prt( "Results of $chg changes written to $out_file...\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_file($in_file);
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-08-14\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}
sub parse_args {
    my (@av) = @_;
    while (@av) {
        my $arg = $av[0];
        if ($arg =~ /^-/) {
            my $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }

    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }

}

# eof - template.pl
