#!/perl -w
# NAME: gendotlist.pl
# AIM: Given an input folder, scan it recursively, listing all the files
# that beign with a DOT ...
# 15/07/2007 - geoff mclane
use strict;
use warnings;
use File::Basename;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $in_folder = "C:\\HOMEPAGE\\Nigel\\public_html";
my @fpfolders = qw( _vti_cnf _vti_pvt _private _derived );
# features
my $recurse = 1;	# process recursivly
my $ignfpd = 1;		# ignore FRONTPAGE folder

# debug
my $dbg1 = 0;	# show folders as scanned

################################################
# ignore FRONTPAGE folders
################################################
sub is_fp_folder {
	my ($inf) = shift;
	foreach my $fil (@fpfolders) {
		if (lc($inf) eq lc($fil)) {
			return 1;
		}
	}
	return 0;
}

sub process_folder {
	my ($inf) = shift;
	my $fcnt = 0;
	prt( "Processing $inf folder ...\n" ) if ($dbg1);
	if ( opendir( DIR, $inf ) ) {
		my @files = readdir(DIR);
		closedir DIR;
		foreach my $fil (@files) {
			if (($fil eq ".")||($fil eq "..")) {
				next;
			}
			my $ff = $inf."\\".$fil;
			if ( -d $ff ) {
				if ($recurse) {
					if ($ignfpd && is_fp_folder($fil)) {	# ignore FRONTPAGE folders
						next;
					}
					##if ($inf =~ /^archive2004/ ) {
						process_folder( $ff );
					##}
				}
			} else {
				my ($nm,$dir,$ext) = fileparse( $ff, qr/\.[^.]*/ );
				if ($fil =~ /^\./) {
					prt( "$ff\n" );
				}
			}
		}
	} else {
		prt( "WARNING: Failed to open [$inf] ... $! ...\n" );
	}
	return $fcnt;
}

process_folder( $in_folder );

close_log($outfile,1);
exit(0);

# eof - gendotlist.pl
