#!/perl -w
# NAME: gendowntable.pl
# AIM: Given a set of file, generate a table for download
# 24/04/2010 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;
use Cwd;
use File::stat;
use Digest::MD5;
unshift(@INC, 'C:\GTools\perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:\GTools\perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my @in_files = qw( atlas-07-src.zip atlas-07-sln.zip atlas-07-exe.zip atlas-07-all.zip atlas-0.4.7.zip );
my $dst_dir = 'C:\HOMEPAGE\GA\fg';
my $src_dir = $dst_dir.'\zips';
my $out_htm = $perl_dir.'\temptab.htm';

### program variables
my @warnings = ();
my $cwd = cwd();

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub get_html_head() {
    my $head = <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml"
      lang="en"
      xml:lang="en">
 <head>
  <meta http-equiv="Content-Type"
        content="text/html; charset=us-ascii" />
  <meta name="Keywords"
        content=
        "free,gpl,flightgear,simgear,terragear,flight,simulator,simulation,world,scenery" />
<title>Test HTML</title>
  <style type="text/css">
/*<![CDATA[*/
/* page specific style */
.nob { text-decoration:none; margin:0px; padding:0px; border:0px; }
  /*]]*/
  </style>
</head>
<body>
<h1 align="center">Download Table</h1>
EOF
    return $head;
}

sub get_table_head() {
   my $th = <<EOF;
   <table border="1" cellpadding="2" cellspacing="2" align="center" summary="Download table">
EOF
   return $th;
}

sub get_nn($) { # perl nice number nicenum add commas
	my ($n) = shift;
	if (length($n) > 3) {
		my $mod = length($n) % 3;
		my $ret = (($mod > 0) ? substr( $n, 0, $mod ) : '');
		my $mx = int( length($n) / 3 );
		for (my $i = 0; $i < $mx; $i++ ) {
			if (($mod == 0) && ($i == 0)) {
				$ret .= substr( $n, ($mod+(3*$i)), 3 );
			} else {
				$ret .= ',' . substr( $n, ($mod+(3*$i)), 3 );
			}
		}
		return $ret;
	}
	return $n;
}

sub get_YYYYMMDD($) {
    my ($t) = shift;
    my @f = (localtime($t))[0..5];
    my $m = sprintf( "%04d/%02d/%02d",
        $f[5] + 1900, $f[4] +1, $f[3]);
    return $m;
}

sub get_hex_digest($) {
   my ($fil) = shift;
   if (open FILE, "<$fil") {
      binmode FILE;
      my $md5 = Digest::MD5->new;
      while (<FILE>) {
         $md5->add($_);
      }
      close FILE;
      return $md5->hexdigest;
   } else {
      print "Error: Unable to open file [$fil]\n";
      exit(1);
   }
}

sub process_file_list($$$$) {
   my ($ra,$dst,$src,$out) = @_;
   my $rp = get_rel_dos_path($src,$dst);
   my $fcnt = scalar @{$ra};
   prt("Got $fcnt files, relative path is [$rp]\n");
   my ($file,$ff,$ok,$sb,$hfil,$cnt,$html);
   $src .= "\\" if (!($src =~ /(\\|\/)$/));
   $cnt = 0;
   foreach $file (@{$ra}) {
      $ff = $src.$file;
      $hfil = path_d2u($rp.$file);
      $ok = 'NF';
      if ((-f $ff)&&($sb = stat($ff))) {
         $ok = 'ok';
         $cnt++;
      }
      prt("$ff ($hfil) $ok\n");
   }
   prtw("WARNING: Only $cnt of $fcnt, are valid!\n") if ($cnt != $fcnt);

   $html = get_html_head();
   $html .= get_table_head();
   $html .= "<tr>\n";
   $html .= "<th>Date</th>\n";
   $html .= "<th>Link</th>\n";
   $html .= "<th>Size</th>\n";
   $html .= "<th>MD5</th>\n";
   $html .= "</tr>\n";
   foreach $file (@{$ra}) {
      $ff = $src.$file;
      $hfil = path_d2u($rp.$file);
      $ok = 'NF';
      if ((-f $ff)&&($sb = stat($ff))) {
         $ok = 'ok';
         $html .= "<tr>\n";
         $html .= "<td>".get_YYYYMMDD($sb->mtime)."</td>\n";
         $html .= "<td><a href=\"$hfil\">$file</a></td>\n";
         $html .= "<td align=\"right\">".get_nn($sb->size)."</td>\n";
         $html .= "<td><tt>".get_hex_digest($ff)."</tt></td>\n";
         $html .= "</tr>\n";
      }
   }
   $html .= "</table>\n";


   $html .= "</body>\n";
   $html .= "</html>\n";

   write2file($html,$out);
   prt("Written to $out...\n");
   system($out);

}

#########################################
### MAIN ###
#prt( "$pgmname: in [$cwd]: Hello, World...\n" );
process_file_list(\@in_files,$dst_dir,$src_dir,$out_htm);
pgm_exit(0,"Normal exit(0)");
########################################
# eof - template.pl
