#!/perl -w
# NAME: gethost.pl
# AIM:
use strict;
use warnings;
use Socket;
use Data::Dumper;

require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
my @names = qw( nowhere.com geoffmclane.com home.exetel.com.au yahoo.com google.com macpcfirstaid.com
  adsl-1-169.lo1.lns1.server-access.com);
my $name = '';
foreach $name (@names) {
	showIPAddress($name);
}
close_log($outfile,1);
exit(0);

sub showIPAddress {
	my ($nm) = shift;
	my @addr = gethostbyname($nm);
	my $cnt = 0;
	if( !@addr ) {
		prt( "Can't resolve $nm: $!\n" );
		return;
	}
	@addr = map { inet_ntoa($_) } @addr[4 .. $#addr];
	foreach my $k (@addr) {
		$cnt++;
		prt( "$cnt: $nm resolves to IP [$k]\n" );
	}
}

# eof
