#!/perl -w
# NAME: getifarray.pl
# AIM: Read a Perl script, and output an 'if' array
# 2009/10/24  - geoff mclane - http://geoffair.net/mperl/
use strict;
use warnings;
use File::Basename;
use Cwd;
unshift(@INC, 'C:\GTools\perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:\GTools\perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 1;
my $in_file = 'getifarray.txt';

### program variables
my @warnings = ();
my $cwd = cwd();

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub process_file($) {
    my ($fil) = @_;
    if (! open INF, "<$fil") {
        prtw("ERROR: Unable to open file [$fil]... $!...\n");
        return 1;
    }
    my @lines = <INF>;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$fil]\n");
    my ($line);
    foreach $line (@lines) {
        chomp $line;
        next if ($line =~ /^\s*#/);
        if ($line =~ /(\{|\})/) {
            prt( "$line\n" );
        } elsif ($line =~ /^\s*\$seek\s*=(.+)$/) {
            prt( "$line\n" );
        } elsif ($line =~ /^\s*\$var(\d+)\s*=(.+)$/) {
            prt( "$line\n" );
        } elsif ($line =~ /^\s*prtw(s*)\((.+)$/) {
            prt( "$line\n" );
        }
#        if ($line =~ /^\s*if(\s|\()/) {
#            prt("$line\n");
#        } elsif ($line =~ /^\s*\}*\s*else(\s|\()/) {
#            prt("$line\n");
#        } elsif ($line =~ /^\s*\}*\s*elsif(\s|\()/) {
#            prt("$line\n");
#        }
    }
    return 0;
}

#########################################
### MAIN ###
prt( "$pgmname: in [$cwd]: Hello, World...\n" );
process_file($in_file);
pgm_exit(0,"Normal exit(0)");
########################################
# eof - template.pl
