#!/perl -w
# NAME: installed.pl
# AIM: To enumerate the installed modules ...

use strict;
use warnings;
use ExtUtils::Installed;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

# FEATURES
my $show_files = 0;
my $show_version = 1;
my $min_width = 32;
my ($inst) = ExtUtils::Installed->new();
my (@modules) = $inst->modules();
my (@missing) = (); # $inst->validate("DBI");
my ($all_files, $files_below_usr_local, $all_dirs, $dirs_below_usr_local, $packlist);

# eg
#$all_files = $inst->files("DBI");
#$files_below_usr_local = $inst->files("DBI", "all", "/usr/local");
#$all_dirs = $inst->directories("DBI");
#$dirs_below_usr_local = $inst->directory_tree("DBI", "prog");
#$packlist = $inst->packlist("DBI");

#my $mscnt = scalar @missing;
#prt( "Got $mscnt missing??? ...\n" );
#foreach my $mis (@missing) {
#    prt( "$mis\n" );
#}
#prt( "Done $mscnt missing ...\n" );

my $mcnt = scalar @modules;
prt( "Got $mcnt modules ...\n" );
my $pmod1 = '';
my $pmod2 = '';
my $pmod3 = '';
my $dcnt = 0;
foreach my $mod (@modules) {
    my @arr = split('::', $mod);
    my $msg = "\n";
    if ($arr[0] ne $pmod1) {
        $pmod1 = $arr[0];
        $dcnt++;
        $msg .= "$mod";
    } else {
        # same module
        my $len = length($pmod1);
        my $smod = substr($mod, $len);
        $msg .= ( ' ' x $len );
        $msg .= "$smod";
    }
    if ($show_version) {
        $msg .= ' ' while (length($msg) < $min_width);
        eval "require $mod";
        $msg .= (": vers ".$mod->VERSION) unless ( $@ );
    }
    prt($msg);
    if ($show_files) {
        $all_files = $inst->files($mod);
        $all_dirs = $inst->directories($mod);
        $packlist = $inst->packlist($mod);
        foreach my $key (keys %$packlist) {
            if ($key) {
                my $val = $$packlist{$key};
                if ($val) {
                    if (ref($val) eq 'HASH') {
                        prt( "\n   $key => HASH" );
                    } else {
                        prt( "\n   $key => $val" );
                    }
                } else {
                     prt( "\n   $key" );
                }
            }
        }
    }
}
prt( "\nDone $dcnt modules ...\n" );

close_log($outfile,1);
exit(0);

# eof - installed.pl
