#!/perl -w
# NAME: km2miles.pl
# AIM: Take kilometer input, and display statute miles,
# using 1 Kilometer = 0.62137 Miles
# 27/06/2008 geoff mclane - http://geoffair.net/mperl
use strict;
use warnings;
my $kilometers = 1;
parse_args(@ARGV);
prt( "$kilometers Kilometers equals ". $kilometers * 0.62137 . " Miles (statute)\n" );
exit(0);

##########################################################
sub parse_args {
	my (@av) = @_;	# = (@ARGV);
	my $argcnt = 0;
	while (@av) {
		$argcnt++;
		my $arg = $av[0];
		$kilometers = $arg;
		prt( "Setting kilometers to [$kilometers] ...\n" );
		shift @av;
	}
	if ($argcnt == 0) {
		prt( "Enter kilometers to convert to statute miles,\n" );
		mydie( "using 1 Kilometer = 0.62137 Miles ...\n" );
	}
}

sub prt {
	my ($txt) = shift;
	print $txt;
}

sub mydie {
	my ($txt) = shift;
	die $txt;
}

# eof - km2miles.pl

