#!/usr/bin/perl -w
# NAME: morse.pl
# AIM: A perl representation of morse
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 1;
my $in_file = '';

my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

# CHARACTER MORSECODE TELEPHONY PHONIC
my @morse = qw( A
.-
Alfa
AL-FAH
B
-...
Bravo
BRAH-VOH
C
-.-.
Charlie
CHAR-LEE
D
-..
Delta
DELL-TAH
E
.
Echo
ECK-OH
F
..-.
Foxtrot
FOKS-TROT
G
--.
Golf
GOLF
H
....
Hotel
HOH-TEL
I
..
India
IN-DEE-AH
J
.---
Juliet
JEW-LEE-ETT
K
-.-
Kilo
KEY-LOH
L
.-..
Lima
LEE-MAH
M
--
Mike
MIKE
N
-.
November
NO-VEM-BER
O
---
Oscar
OSS-CAH
P
.--.
Papa
PAH-PAH
Q
--.-
Quebec
KEH-BECK
R
.-.
Romeo
ROW-ME-OH
S
...
Sierra
SEE-AIR-RAH
T
-
Tango
TANG-GO
U
..-
Uniform
YOU-NEE-FORM
V
...-
Victor
VIK-TAH
W
.--
Whiskey
WISS-KEY
X
-..-
Xray
ECKS-RAY
Y
-..-
Yankee
YANG-KEY
Z
--..
Zulu
ZOO-LOO
1
.----
One
WUN
2
..---
Two
TOO
3
...--
Three
TREE
4
....-
Four
FOW-ER
5
.....
Five
FIFE
6
-....
Six
SIX
7
--...
Seven
SEV-EN
8
---..
Eight
AIT
9
----.
Nine
NIN-ER
0
-----
Zero
ZEE-RO
);

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        ###prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub gen_table() {
    my ($cnt,$item,$line);
    $cnt = 0;
    $line = "ABC abc[] = {";
    prt("$line\n");
    $line = '';
    foreach $item (@morse) {
        if ($cnt == 0) {
            $line .= "  { ";
            $line .= "'$item'";
        } else {
            $line .= ", (char *)\"$item\"";
        }
        $cnt++;
        if ($cnt == 4) {
            $line .= " },";
            prt("$line\n");
            $cnt = 0;
            $line = '';
        }
    }

    $line = "  { 0, 0, 0, 0 }";
    prt("$line\n");
    $line = " );";
    prt("$line\n");
}

#########################################
### MAIN ###
#parse_args(@ARGV);
#prt( "$pgmname: in [$cwd]: Hello, World...\n" );
#process_in_file($in_file);
gen_table();
pgm_exit(0,"");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-09-11\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

# eof - template.pl
