#!/perl -w
# NAME: perms.pl
# AIM: Convert unix permission string to dec, hex, and OCTAL display
# each triplet: rwx = 4 + 2 + 1 = 7
# 31/03/2008 - geoff mclane - http://geoffair.net/mperl
use strict;
use warnings;
unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $doit = 1;
my $istg = '';
my $pos = 0;
my $num = 0;
my $onum1 = 0;
my $onum2 = 0;
my $onum3 = 0;

my $Inum1 = '';
my $Inum2 = '';
my $Inum3 = '';
my $Inum = '';
my $Gnum1 = '';
my $Gnum2 = '';
my $Gnum3 = '';
my $Gnum = '';
my $Wnum1 = '';
my $Wnum2 = '';
my $Wnum3 = '';
my $Wnum = '';
my $trip1 = 0;
my $trip2 = 0;
my $trip3 = 0;
my $trips = 0;
my $msg = '';

if (@ARGV) {
	$istg = pop @ARGV;
	show_perms($istg);
} else {
	while ($doit) {
		## print "Gimme a number in decimal, octal, or hex: ";
		prt( "Gimme a unix permissions string: " );
		$istg = <STDIN>;
		chomp $istg;
		if ( defined($istg) && length($istg) ) {
			# expect -rwx-r--r--
			my $len = length($istg);
			if ($len == 10) {
				show_perms($istg);
			} else {
				prt( "Permision string has to be 10 letters long!\n" );
			}
		} else {
			$doit = 0;
			prt( "exiting ...\n" );
		}
	}
}

close_log($outfile,0);
exit(0);

sub show_perms {
	my ($stg) = shift;
	$pos = 0;
	my $ch = substr($stg, $pos, 1);
	if( $ch eq '-' ) {
		prt( "file : \n" );
	} elsif ( $ch eq 'd' ) {
		prt( "directory : \n" );
	} else {
		prt( "Permission string MUST start with '-' or 'd', at present ...\n" );
		return;
	}
	#######################################
	$trip1 = 0;
	$pos++;
	$ch = substr($stg, $pos, 1);
	if ($ch eq 'r') {
		$Inum1 = '1';
		$trip1 += 4;
	} elsif ( $ch eq '-' ) {
		$Inum1 = '0';
	} else {
		$pos++;
		prt( "Permission string MUST have with '-' or 'r', as $pos char ...\n" );
		return;
	}
	$pos++;
	$ch = substr($stg, $pos, 1);
	if ($ch eq 'w') {
		$Inum2 = '1';
		$trip1 += 2;
	} elsif ( $ch eq '-' ) {
		$Inum2 = '0';
	} else {
		$pos++;
		prt( "Permission string MUST have with '-' or 'w', as $pos char ...\n" );
		return;
	}
	$pos++;
	$ch = substr($stg, $pos, 1);
	if ($ch eq 'x') {
		$trip1 += 1;
		$Inum3 = '1';
	} elsif ( $ch eq '-' ) {
		$Inum3 = '0';
	} else {
		$pos++;
		prt( "Permission string MUST have with '-' or 'x', as $pos char ...\n" );
		return;
	}
	$Inum = $Inum1.$Inum2.$Inum3;
	$onum1 = oct($Inum);
	prt( "1: $trip1 = " );
	$msg = sprintf( "%d %x %o", $onum1, $onum1, $onum1 );
	prt( "$msg\n" );

	$trip2 = 0;
	$pos++;
	$ch = substr($stg, $pos, 1);
	if ($ch eq 'r') {
		$Gnum1 = '1';
		$trip2 += 4;
	} elsif ( $ch eq '-' ) {
		$Gnum1 = '0';
	} else {
		$pos++;
		prt( "Permission string MUST have with '-' or 'r', as $pos char ...\n" );
		return;
	}
	$pos++;
	$ch = substr($stg, $pos, 1);
	if ($ch eq 'w') {
		$trip2 += 2;
		$Gnum2 = '1';
	} elsif ( $ch eq '-' ) {
		$Gnum2 = '0';
	} else {
		$pos++;
		prt( "Permission string MUST have with '-' or 'w', as $pos char ...\n" );
		return;
	}
	$pos++;
	$ch = substr($stg, $pos, 1);
	if ($ch eq 'x') {
		$trip2 += 1;
		$Gnum3 = '1';
	} elsif ( $ch eq '-' ) {
		$Gnum3 = '0';
	} else {
		$pos++;
		prt( "Permission string MUST have with '-' or 'x', as $pos char ...\n" );
		return;
	}
	$Gnum = $Gnum1.$Gnum2.$Gnum3;
	$onum2 = oct($Gnum);
	prt( "2: $trip2 = " );
	$msg = sprintf( "%d %x %o", $onum2, $onum2, $onum2 );
	prt( "$msg\n" );

	$trip3 = 0;
	$pos++;
	$ch = substr($stg, $pos, 1);
	if ($ch eq 'r') {
		$trip3 += 4;
		$Wnum1 = '1';
	} elsif ( $ch eq '-' ) {
		$Wnum1 = '0';
	} else {
		$pos++;
		prt( "Permission string MUST have with '-' or 'r', as $pos char ...\n" );
		return;
	}
	$pos++;
	$ch = substr($stg, $pos, 1);
	if ($ch eq 'w') {
		$trip3 += 2;
		$Wnum2 = '1';
	} elsif ( $ch eq '-' ) {
		$Wnum2 = '0';
	} else {
		$pos++;
		prt( "Permission string MUST have with '-' or 'w', as $pos char ...\n" );
		return;
	}
	$pos++;
	$ch = substr($stg, $pos, 1);
	if ($ch eq 'x') {
		$trip3 += 1;
		$Wnum3 = '1';
	} elsif ( $ch eq '-' ) {
		$Wnum3 = '0';
	} else {
		$pos++;
		prt( "Permission string MUST have with '-' or 'x', as $pos char ...\n" );
		return;
	}
	$Wnum = $Wnum1.$Wnum2.$Wnum3;
	$onum3 = oct($Wnum);
	prt( "3: $trip3 = " );
	$msg = sprintf( "%d %x %o", $onum3, $onum3, $onum3 );
	prt( "$msg\n" );

	$trips = "$trip1"."$trip2"."$trip3";
	$num = oct($trips);
	prt( "res: $trips = " );
	$msg = sprintf( "%d %x %o", $num, $num, $num );
	prt( "$msg\n" );
}

# eof - perms.pl
