#!/Perl
# This section of code gets a list of the files that end in
# .gif that are in the current directory and returns on of them
# at random. scraped from the web!

# make sure STDOUT is in binary mode!
binmode STDOUT;

#Tell the browser not to cache this image
print "Cache-control: no-cache\n";

# The header must tell the browser we are returning an image!
print "Content-type: image/gif\n\n";

# get a list of the files
### @files = <*.gif>;
@files = <../java/images/tumble/*.gif>;
$numfiles = @files;

# pick one randonly
srand;
$fnum = int(rand($numfiles));
# read the image file and send to the browser
send_image($files[$fnum]);
exit;


sub send_image {
    local($filename) = $_[0];

    # attempt to open the file
    if (! open(F,$filename) ) {
	# Can't open the file - this is a fatal error!
	#fatal_error("Can't find the file $filename\n");
	# No sense sending back a message - the browser expects
	# an image and won't display text! Just quit.
	exit;
    }
    # force the file handle to binary mode
    binmode F;

    local($line);
    # the file is open - read everything and send to
    # the browser
    while (read(F,$line,4096)) {
	print $line;
    }
    close(F);               # close the file
}

#eof
