#!/usr/bin/perl
# NAME: showsymbols.pl
# AIM: Enumerate the namespace sort of 'hash'...
# 04/09/2010 geoff mclane http://geoffair.net/mperl
use strict; use warnings; use diagnostics;
my $pack = __PACKAGE__;
sub prt{ print shift; }
our $pack2 = $pack;
sub getSymbolType($) {
    my ($entry) = shift;
    my ($typ);
    no strict 'refs'; # allow symbol table viewing
    if (defined ${$entry}) {
        $typ = "scalar ";
    } elsif (defined @{$entry}) {
        $typ = "array  ";
    } elsif (defined %{$entry}) {
        $typ = "hash   ";
    } elsif (defined &{$entry}) {
        $typ = "sub    ";
    } else {
        $typ = "uncased";
    }
    return "$typ";
}
sub getSymbol($) {
    my ($entry) = shift;
    my $typ = '';
    no strict 'refs'; # allow symbol table viewing
    if (defined ${$entry}) {
        $typ = '$';
    } elsif (defined @{$entry}) {
        $typ = '@';
    } elsif (defined %{$entry}) {
        $typ = '%';
    }
    return $typ;
}
sub dispSymbols($) {
    my ($hashRef) = shift;
    my (%symbols,@symbols,$typ,$cnt,$entry,$r1,$r2,$sym,$r3,$obj);
    %symbols = %{$hashRef};
    @symbols = sort(keys(%symbols));
    prt("Show defined symbols in package [$pack]\n");
    $cnt = 0;
    foreach $entry (@symbols) {
        $typ = getSymbolType($entry);
        $sym = getSymbol($entry);
        $r1 = ref($entry);  # these yield nothing!
        $r2 = ref($symbols{$entry}); # why???
        $r3 = '';
        #$obj = $sym.$entry;
        #$r3 = ref($obj) if (length($sym));
        prt("$typ ".sprintf("%-20.20s| %s [$sym $r1 $r2 $r3]\n", $entry, $symbols{$entry}));
        $cnt++;
    }
    prt("Done $cnt symbols in package [$pack]\n");
    prt("Note 'sym' and 'pack' defined with 'my' do NOT appear, while 'our \$pack2' does...\n");
}
my $sym = '\%'.$pack.'::';
dispSymbols(eval $sym);
# eof
