#!/Perl
use Carp;
# use HiRes timer
use Time::HiRes qw( usleep ualarm gettimeofday tv_interval nanosleep );

print "Hello, World... Slurp a config file test ...\n";
my $file = shift || 'config.txt';
$t0 = [gettimeofday];
my $text = read_file_f( $file ) ;
my %config = $text =~ /^(\w+)=(.+)$/mg ;
my $key;
foreach $key (keys %config) {
	print "$key=$config{$key}\n";
}
$elapsed = tv_interval ( $t0, [gettimeofday]);
print "$0 ran for $elapsed seconds ...\n";

sub read_file_s
{
    my ($file) = @_;

    local($/) = wantarray ? $/ : undef;
    local(*F);
    my $r;
    my (@r);

    open(F, "<$file") || die "ERROR: open $file: $!";
    @r = <F>;
    close(F) || die "ERROR: close $file: $!";

    return $r[0] unless wantarray;
    return @r;
}

sub read_file_f {
    my( $file_name, %args ) = @_ ;
    my $buf ;
    my $buf_ref = $args{'buf_ref'} || \$buf ;
    my $mode = O_RDONLY ;
    $mode |= O_BINARY if $args{'binmode'} ;
    local( *FH ) ;
    sysopen( FH, $file_name, $mode ) or
        carp "Can't open $file_name: $!" ;

    my $size_left = -s FH ;
    while( $size_left > 0 ) {
        my $read_cnt = sysread( FH, ${$buf_ref},
            $size_left, length ${$buf_ref} ) ;

        unless( $read_cnt ) {
            carp "read error in file $file_name: $!" ;
            last ;
        }

		$size_left -= $read_cnt ;
    }
# handle void context (return scalar by buffer reference)
    return unless defined wantarray ;
# handle list context
    return split m|?<$/|g, ${$buf_ref} if wantarray ;
# handle scalar context
    return ${$buf_ref} ;
}

# eof slurptest.pl
