#!/perl -w
# NAME: svnexclude.pl
# AIM: Very specific utility to REMOVE diffs of files in '.svn' folders ...
# 22/10/2007 - geoff mclane - geoffair.net/mperl
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
my $in_file = 'C:\FG\FGCOM\tempdiff2';
my $out_file = 'tempnew.txt';
my $out_disc = 'tempdisc.txt';
my @discards = ();
if (open INF, "<$in_file") {
	my @lines = <INF>;
	close INF;
	my $lncnt = scalar @lines;
	prt( "Processing $lncnt lines from $in_file ...\n" );
	my @newlns = ();
	for (my $i = 0; $i < $lncnt; $i++) {
		my $line = $lines[$i];
		my $tln = trim_all($line);
		if ($line =~ /^diff\s+-ur\s+(.+)/i) {
			#prt( "$tln\n" );
			my $paths = $1;
			my $ll = length($paths);
			my $pth = '';
			my $ch = '';
			my $fnd = 0;
			for (my $j = 0; $j < $ll; $j++) {
				$ch = substr($paths, $j, 1);
				if ($ch =~ /(\\|\/)/) {
					if ($pth =~ /^\.svn$/i) {
						$fnd = 1;
						last;
					}
					$pth = '';
				} else {
					$pth .= $ch;
				}
			}
			if ($fnd) {
				# have an .svn diff - get to its end
				push(@discards,$line);
				$i++;	# go to NEXT line
				$fnd = 0;
				for (; $i < $lncnt; $i++) {
					$line = $lines[$i];
					if ($line =~ /^diff\s+-ur\s+(.+)/i) {
						$fnd = 1;
						last;
					}
					push(@discards,$line);
				}
				if ($fnd) {
					$i--;	# back up one
					next;	# and loop to take this to top
				}
				$line = '';
			}
		}
		push(@newlns, $line) if (length($line));
	}
	$lncnt = scalar @newlns;
	prt( "Got $lncnt new lines ...\n" );
	write2file( join('', @newlns), $out_file );
	prt( "Written to $out_file ...\n" );
	write2file( join('', @discards), $out_disc);
	prt( "Discards written to $out_disc ...\n" );
} else {
	prt( "ERROR: Failed to open $in_file ... $! ...\n" );
}


close_log($outfile,1);
exit(0);

# eof - svnexlude.pl
