#!/perl -w
# NAME: 
# AIM:
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.htm";
open_log($outfile);

my $wrap = 32;
my $cnt = 0;
my $i = 0;
my $msg = '';
my $val = 0;
my $htm_head = <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
 <head>
  <meta http-equiv="Content-Language"
        content="en">
  <meta http-equiv="Content-Type"
        content="text/html; charset=us-ascii">
  <meta name="Generator"
        content="EditPlus">
  <meta name="Author"
        content="Geoff McLane">
  <meta name="Keywords"
        content="geoff, mclane, UNICODE character set">
  <meta name="Description"
        content="Generation of complete UNICODE character set">
  <title>
   Uncode Page
  </title>
  <style type="text/css">
  .cn { font-family : "Courier New"; }
  </style>
 </head>
 <body>
EOF

prt( $htm_head );
prt( "<h1>Unicode Page</h1\n" );
prt( "<p class=\"cn\">Test 1<br>\n" );
for ($i = 0; $i < 32768; $i++) {
	if ($cnt == 0) {
		prt( sprintf("%05d-%05d: ", $i, ($i + $wrap - 1) ) );
	}
	prt( "&#$i;" );
	$cnt++;
	if ($cnt >= $wrap) {
		$msg = ' (Hex ';
		$val = $i - ($wrap - 1);
		$msg .= dec2hex( $val );
		$msg .= '-';
		$msg .= dec2hex( $i );
		$msg .= ')';
		prt( "$msg<br>\n" );
		$cnt = 0;
	}
}
prt( "<br>End Set 1<\p>\n" );
prt( "<p class=\"cn\">Test 2<br>\n" );
for (; $i < 65536; $i++) {
	if ($cnt == 0) {
		prt( sprintf("%05d-%05d: ", $i, ($i + $wrap - 1) ) );
	}
	prt( "&#$i;" );
	$cnt++;
	if ($cnt >= $wrap) {
		$msg = ' (Hex ';
		$val = $i - ($wrap - 1);
		$msg .= dec2hex( $val );
		$msg .= '-';
		$msg .= dec2hex( $i );
		$msg .= ')';
		prt( "$msg<br>\n" );
		$cnt = 0;
	}
}
prt( "<br>End Set 2<\p>\n" );
prt( "</body>\n" );
prt( "</html>\n" );

close_log($outfile,1);
exit(0);

################
### subs
sub dec2hex {
    my $decnum = $_[0];     # parameter passed to the subfunction
    my $hexnum;     # the final hex number
    my $tempval;
	if ($decnum == 0) {
		return '0';
	}
    while ($decnum != 0) {
		# get the remainder (modulus function)
		# by dividing by 16
		$tempval = $decnum % 16;
		# convert to the appropriate letter
		# if the value is greater than 9
		if ($tempval > 9) {
			$tempval = chr($tempval + 55);
		}
		# 'concatenate' the number to 
		# what we have so far in what will
		# be the final variable
		$hexnum = $tempval . $hexnum ;
		# new actually divide by 16, and 
		# keep the integer value of the 
		# answer
		$decnum = int($decnum / 16); 
		# if we cant divide by 16, this is the
		# last step
		if ($decnum < 16) {
			# convert to letters again..
			if ($decnum > 9) {
				$decnum = chr($decnum + 55);
			}
			# add this onto the final answer.. 
			# reset decnum variable to zero so loop
			# will exit
			$hexnum = $decnum . $hexnum; 
			$decnum = 0 
		}
    }
    return $hexnum;
} # end sub

# eof
