#!perl -w
# NAME: timing.pl
# AIM: Test high resolution timing
# 17/12/2008 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use Time::HiRes qw(gettimeofday tv_interval);       # provide more accurate timings
#my @begin = gettimeofday();
my $begin = [ gettimeofday ];
my $cnt = 0;
sub bump_cnt {
    my ($c) = shift;
    $$c++;
}
sub run_test {
    my ($max) = shift;
    for (my $i = 0; $i < $max; $i++) {
        bump_cnt( \$cnt );
    }
}
run_test( 1000000 );
#my @end = gettimeofday();
my $end = [ gettimeofday ];
#my $interval = tv_interval( \@begin, \@end );
my $interval = tv_interval( $begin, $end );
print "$cnt iterations: Ran for $interval seconds ...\n";
# eof - timing.pl
