#!/Perl
# AIM: Source list from MSVC8 project file
# First try, using XML::Simple, so
use Data::Dumper;
use XML::Simple;
require "logfile.pl" or die "Missing logfile.pl ...\n"; # my simple log file
my $dbg_on1 = 0;
my $dbg_on2 = 1;
# set a DEFAULT input file name
#my $in_file = 'F:\FG0910-4\PLIB\src\pui\pui.vcproj';
my $in_file = 'F:\FG0910-4\flightgear\projects\VC8\FlightGear.vcproj';
my $in_dir = 'F:\FG0910-4\PLIB\src\pui';
$in_file = pop @ARGV if (@ARGV);
$in_dir = pop @ARGV if (@ARGV);
# log file stuff
my ($LF);
my $outfile = 'temp'.$0.'.txt';
open_log($outfile);
my $file = '';
my $ff = '';
my $fl1 = 'Files';
my $fl2 = 'File';
my $fl3 = 'RelativePath';
my $fl4 = 'Filter';
my $cnt = 0;
my @csrc_array = ();
my @hsrc_array = ();
my @osrc_array = ();
my @cdir_array = ();
my @hdir_array = ();
my @odir_array = ();

my @files = ();
prt( "$0 ... Hello, World ...\n" );
if ( ( -f $in_file) && ( -d $in_dir ) ) {
	get_xml_sources($in_file);
	#get_dir_sources();
	#cmp_c_sources();
} else {
	prt( "ERROR: Can not locate [$in_file] or [$in_dir] ... aborting ...\n" );
}

close_log($outfile,1);
exit(0);

##############################################
### utitlity subs
sub cmp_c_sources {
	my ($f1, $f2);
	my $fnd = 0;
	prt( "\nComparing C/C++ sources ...\n" );
	foreach $f1 (@csrc_array) {
		$fnd = 0;
		foreach $f2 (@cdir_array) {
			if ( lc(file_name($f1)) eq lc(file_name($f2)) ) {
				$fnd = 1;
				last;
			}
		}
		if ($fnd == 0) {
			prt( "NOT FOUND [$f1] from \@csrc_array in \@cdir_array!\n" );
		}
	}
	foreach $f1 (@cdir_array) {
		$fnd = 0;
		foreach $f2 (@csrc_array) {
			if ( lc(file_name($f1)) eq lc(file_name($f2)) ) {
				$fnd = 1;
				last;
			}
		}
		if ($fnd == 0) {
			prt( "NOT FOUND [$f1] from \@cdir_array in \@csrc_array!\n" );
		}
	}
}

sub get_dir_sources {
	opendir(DIR, $in_dir) or mydie( "ERROR: Unable to open directory [$in_dir] ...\n" );
	@files = readdir(DIR);
	closedir DIR;
	$cnt = 0;
	foreach $file (@files) {
		if (($file eq '.') || ($file eq '..')) {
			next;
		}
		$cnt++;
		$ff = $in_dir . '\\' . $file;
		prt( "$cnt $file ($ff)\n" );

		if (is_c_source($file)) {
			push(@cdir_array,$file);
		} elsif (is_h_source($file)) {
			push(@hdir_array,$file);
		} else {
			push(@odir_array,$file);
		}
	}
	prt( "Got ".scalar @cdir_array." C/C++ files, ".scalar @hdir_array. " header files" );
	if (@odir_array) {
		prt( " and ".scalar @odir_array." files" );
	}
	prt("\n");
}

sub get_xml_sources {
	my ($in) = shift;
	my $in_fd = file_dirname($in);
	prt( "Loading [$in] in directory [$in_fd] ...\n" );
	# create object
	my $xml = new XML::Simple;
	#my $xml = new XML::Simple (KeyAttr=>[]);

	# read XML file
	my $data = $xml->XMLin($in);
	# print output
	#prt( Dumper($data) );
	prt( "Getting array of $fl1 ...\n" );
	my $files = $data->{$fl1};
	#my $files = $data->{$fl1}->{$fl2};
	#my $files = $data->{$fl1}->{$fl2}->{$fl3};
	prt( Dumper($files) ) if ($dbg_on1);
	prt( "Processing for each $fl2 ...\n" );
	$cnt = 0;
	foreach my $e (@{$files->{$fl2}}) {
		$cnt++;
		#prt( Dumper($e) );
		$file = $e->{$fl3};
		$ff = $in_fd . $file;
		#prt( $e->{$fl3}."\n" );
		prt( "$cnt $file ($ff)\n" );
		if (is_c_source($file)) {
			push(@csrc_array,$file);
		} elsif (is_h_source($file)) {
			push(@hsrc_array,$file);
		} else {
			push(@osrc_array,$file);
		}
	}
	if ($cnt == 0) {
		prt( "\nFAILED using [$fl1][$fl2] ... try [$fl1][$fl4] ...\n" );
		$files = $data->{$fl1}->{$fl4};
		prt( Dumper($files) ) if ($dbg_on2);
		#my $dfiles = $files->{$fl2};
		#prt( Dumper($dfiles) ) if ($dbg_on2);
		foreach my $k (keys %{$files}) {
			$cnt++;
			#my $tmp = $files->{$k};
			if ($k eq $fl2) {
				my $tmp = $data->{$fl1}->{$fl4}->{$k};
				prt( Dumper($tmp) );
			}
			prt( "$cnt $k [".$files{$k}."]\n" );
		}
	}
	prt( "Got ".scalar @csrc_array." C/C++ files, ".scalar @hsrc_array. " header files" );
	if (@osrc_array) {
		prt( " and ".scalar @osrc_array." files" );
	}
	prt("\n");
}

sub is_c_source {
	my $f = shift;
	if ( ($f =~ /\.c$/i) || ($f =~ /\.cpp$/i) || ($f =~ /\.cxx$/i) ) {
		return 1;
	}
	return 0;
}

sub is_h_source {
	my $f = shift;
	if ( ($f =~ /\.h$/i) || ($f =~ /\.hpp$/i) || ($f =~ /\.hxx$/i) ) {
		return 1;
	}
	return 0;
}

# eof - vc8srcs01.pl

